<?php
/**
 * Single Product tabs
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/tabs/tabs.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.8.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Filter tabs and allow third parties to add their own.
 *
 * Each tab is an array containing title, callback and priority.
 *
 * @see woocommerce_default_product_tabs()
 */
$product_tabs = apply_filters( 'woocommerce_product_tabs', array() );

if ( ! empty( $product_tabs ) ) :

	global $product;

	$product_purchasable = $product->is_purchasable();

	$product_tab_mode = ( ! empty( get_theme_mod( 'kls_product_tabs_mode' ) ) ? get_theme_mod( 'kls_product_tabs_mode' ) : 'accordion' );

	// Todo, when reviews are disabled and no description is filled in it won't show the tab for the order.
	if ( 'tabs' == $product_tab_mode || 'tabs-small' == $product_tab_mode ) : ?>
		<div class="tabs-wrapper">
			<ul class="tabs-list" role="tablist">
				<?php if ( 'v6' == $GLOBALS['kls_product_style_version'] && isset( $product_purchasable ) && $product_purchasable > 0 ) : ?>
					<li class="tabs-toggle active" role="tab" data-tab-id="summary">
						<p><?php esc_html_e( 'Create your order', 'klasse-theme' ); ?></p>
					</li>
					<?php
				endif;
				foreach ( $product_tabs as $key => $product_tab ) :
					?>
					<li class="tabs-toggle <?php echo ( 'v6' !== $GLOBALS['kls_product_style_version'] && get_theme_mod( 'product_first_tab_open_toggle' ) == 1 && $product_tab['title'] == 'Beschrijving' ? ' active' : '' ); ?>" role="tab" data-tab-id="<?php echo esc_attr( $key ); ?>">
						<?php echo wp_kses_post( apply_filters( 'woocommerce_product_' . $key . '_tab_title', $product_tab['title'], $key ) ); ?>
					</li>
				<?php endforeach; ?>
			</ul>

			<?php if ( 'v6' == $GLOBALS['kls_product_style_version'] && isset( $product_purchasable ) && $product_purchasable > 0 ) : ?>
				<div class="tabs-item summary active" data-tab-id="summary">
					<div class="tabs-content<?php echo ( get_theme_mod( 'product_first_tab_open_toggle' ) == 1 ? ' show' : '' ); ?>">
					<?php
					do_action( 'kls_add_to_cart_form_tab' );
					?>
					</div>
				</div>
				<?php
			endif;
			foreach ( $product_tabs as $key => $product_tab ) :
				?>
				<div class="tabs-item 
				<?php
				echo ( is_string( $product_tab['callback'] ) ? strtolower( $product_tab['callback'] ) : '' );
				echo ( get_theme_mod( 'product_description_read_more_toggle' ) == 1 && 'Beschrijving' == $product_tab['title'] ? ' read-more-container' : '' );
				?>
				 <?php echo ( 'v6' !== $GLOBALS['kls_product_style_version'] && get_theme_mod( 'product_first_tab_open_toggle' ) == 1 && $product_tab['title'] == 'Beschrijving' ? ' active' : '' ); ?>" data-tab-id="<?php echo esc_attr( $key ); ?>">
					<div class="tabs-content">
						<?php
						if ( get_theme_mod( 'product_description_read_more_toggle' ) == 1 && 'Beschrijving' == $product_tab['title'] ) {
							echo '<div class="read-more-content">';
						}

						if ( isset( $product_tab['callback'] ) ) {
							call_user_func( $product_tab['callback'], $key, $product_tab );
						}

						if ( 'Beschrijving' == $product_tab['title'] ) {
							do_action( 'kls_long_description' );
						}

						if ( get_theme_mod( 'product_description_read_more_toggle' ) == 1 && 'Beschrijving' == $product_tab['title'] ) {
							echo '</div><p class="button-link read-more-button">' . esc_html__( 'Read more...', 'klasse-theme' ) . '</p>';
						}
						?>
					</div>
				</div>
			<?php endforeach; ?>
		</div>
		<?php
	elseif('simple' == $product_tab_mode):
		?>
			<div class="woocommerce-tabs">
			<?php foreach ( $product_tabs as $key => $product_tab ) : ?>
				<div class="woocommerce-Tabs-panel woocommerce-Tabs-panel--<?php echo esc_attr( $key ); ?> panel" id="tab-<?php echo esc_attr( $key ); ?>" role="tabpanel" aria-labelledby="tab-title-<?php echo esc_attr( $key ); ?>">
					<h2><strong><?php
					echo wp_kses_post( apply_filters( 'woocommerce_product_' . $key . '_tab_title', $product_tab['title'], $key ) );
					?></strong></h2>

					<?php
					if ( isset( $product_tab['callback'] ) ) {
						call_user_func( $product_tab['callback'], $key, $product_tab );
					}
					?>
				</div>
			<?php endforeach; ?>

			<?php do_action( 'woocommerce_product_after_tabs' ); ?>
		</div>
	<?php
	else :
		$i = 0;
		?>
		<div class="accordion-wrapper">
			<?php
			if ( 'v6' == $GLOBALS['kls_product_style_version'] ) :
				$i++;
				?>
				<div data_tab_id="<?php echo $i; ?>" class="accordion-item show summary">
					<div class="accordion-toggle<?php echo ( get_theme_mod( 'product_first_tab_open_toggle' ) == 1 && $i == '1' ? ' show' : '' ); ?>">
						<p><?php esc_html_e( 'Create your order', 'klasse-theme' ); ?></p>
					</div>
					<div class="accordion-content<?php echo ( get_theme_mod( 'product_first_tab_open_toggle' ) == 1 && $i == '1' ? ' show' : '' ); ?>">
						<?php
						do_action( 'kls_add_to_cart_form_tab' );
						?>
					</div>
				</div>
				<?php
			endif;

			$tabs_amount = count( $product_tabs );

			foreach ( $product_tabs as $key => $product_tab ) :
				$i++;
				?>
				<div data_tab_id="<?php echo $i; ?>" class="accordion-item 
											 <?php
												echo ( is_string( $product_tab['callback'] ) ? strtolower( $product_tab['callback'] ) : '' );
												echo ( get_theme_mod( 'product_first_tab_open_toggle' ) == 1 && get_theme_mod( 'product_description_read_more_toggle' ) == 1 && 'Beschrijving' == $product_tab['title'] ? ' read-more-container' : '' );
												?>
				">
					<div class="accordion-toggle<?php echo ( 'v6' !== $GLOBALS['kls_product_style_version'] && get_theme_mod( 'product_first_tab_open_toggle' ) == 1 && $i == '1' ? ' show' : '' ); ?>">
						<p>
							<?php echo wp_kses_post( apply_filters( 'woocommerce_product_' . $key . '_tab_title', $product_tab['title'], $key ) ); ?>
						</p>
					</div>
					<div class="accordion-content<?php echo ( 'v6' !== $GLOBALS['kls_product_style_version'] && get_theme_mod( 'product_first_tab_open_toggle' ) == 1 && $i == '1' ? ' show' : '' ); ?>" style="<?php echo ( 'v6' !== $GLOBALS['kls_product_style_version'] && get_theme_mod( 'product_first_tab_open_toggle' ) == 1 && $i == '1' ? '' : ' display:none;' ); ?>">
						<?php
						if ( get_theme_mod( 'product_first_tab_open_toggle' ) == 1 && get_theme_mod( 'product_description_read_more_toggle' ) == 1 && 'Beschrijving' == $product_tab['title'] ) {
							echo '<div class="read-more-content">';
						}

						if ( isset( $product_tab['callback'] ) ) {
							call_user_func( $product_tab['callback'], $key, $product_tab );
						}

						if ( get_theme_mod( 'product_first_tab_open_toggle' ) == 1 && get_theme_mod( 'product_description_read_more_toggle' ) == 1 && 'Beschrijving' == $product_tab['title'] ) {
							echo '</div><p class="button-link read-more-button">' . esc_html__( 'Read more...', 'klasse-theme' ) . '</p>';
						}
						?>
					</div>
				</div>
			<?php endforeach; ?>
		</div>
		<?php
	endif;
endif;
