<?php

/**
 * Order Customer Details
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 5.6.0
 */

defined( 'ABSPATH' ) || exit;
$show_shipping = ! wc_ship_to_billing_address_only() && $order->needs_shipping_address();
?>
<section class="woocommerce-customer-details">

	<?php
	if ( $show_shipping ) :
		?>

  <div class="theme-row">
		<div class="theme-col theme-col-6">

		<?php
	endif;
	?>

	<h2 class="woocommerce-column__title"><?php esc_html_e( 'Billing address', 'klasse-theme' ); ?></h2>

  <div>
		<?php echo wp_kses_post( $order->get_formatted_billing_address( esc_html__( 'N/A', 'klasse-theme' ) ) ); ?>

		<?php
		if ( $order->get_billing_phone() ) :
			?>
			<p class="woocommerce-customer-details--phone"><?php echo esc_html( $order->get_billing_phone() ); ?></p>
			<?php
		endif;
		?>

		<?php
		if ( $order->get_billing_email() ) :
			?>
			<p class="woocommerce-customer-details--email"><?php echo esc_html( $order->get_billing_email() ); ?></p>
			<?php
		endif;
		?>
		</div>

	<?php
	if ( $show_shipping ) :
		?>

	  </div><!-- /.col-1 -->

		<div class="theme-col theme-col-6">
			<h2 class="woocommerce-column__title"><?php esc_html_e( 'Shipping address', 'klasse-theme' ); ?></h2>
			<div>
				<?php echo wp_kses_post( $order->get_formatted_shipping_address( esc_html__( 'N/A', 'klasse-theme' ) ) ); ?>

				<?php
				if ( $order->get_shipping_phone() ) :
					?>
					<p class="woocommerce-customer-details--phone"><?php echo esc_html( $order->get_shipping_phone() ); ?></p>
					<?php
				endif;
				?>
				</div>
	 </div><!-- /.col-2 -->

	</div><!-- /.col2-set -->

		<?php
	endif;
	?>

	<?php do_action( 'woocommerce_order_details_after_customer_details', $order ); ?>

	<a href="<?php echo esc_url( wc_get_account_endpoint_url( 'orders' ) ); ?>" class="theme-button theme-button-primary"><?php esc_html_e( 'Go to your account', 'klasse-theme' ); ?></a>

</section>
