<?php

/**
 * My Account navigation
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 2.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

do_action( 'woocommerce_before_account_navigation' );
$wishlist    = defined( 'YITH_WCWL' );
$account_arr = array(
	// 'dashboard'          => __( 'Dashboard', 'klasse-theme' ),
	// 'orders'          => __( 'Orders', 'klasse-theme' ),
	// 'downloads'       => __( 'Downloads', 'klasse-theme' ),
	// 'edit-address'    => __( 'Addresses', 'klasse-theme' ),
	// 'edit-account'    => __( 'Account details', 'klasse-theme' ),
	// 'gift-cards' => __( 'Gift cards', 'klasse-theme' ),
	// 'wishlist'        => __( 'Wishlist', 'klasse-theme' ),
	// 'customer-logout' => __( 'Logout', 'klasse-theme' )
);
?>
<div class="account-navigation">
	<h3>
		<?php esc_html_e( 'My account', 'klasse-theme' ); ?>
		</h5>
		<ul>
			<li class="<?php echo wc_get_account_menu_item_classes( 'dashboard' ); ?>">
				<a href="<?php echo wc_get_account_endpoint_url( 'dashboard' ); ?>">
					<?php echo __( 'Dashboard', 'klasse-theme' ); ?>
				</a>
			</li>

			<li class="<?php echo wc_get_account_menu_item_classes( 'orders' ); ?>">
				<a href="<?php echo wc_get_account_endpoint_url( 'orders' ); ?>">
					<?php echo __( 'Orders', 'klasse-theme' ); ?>
				</a>
			</li>

			<?php
			if ( get_theme_mod( 'my_account_downloads_toggle' ) == 1 ) {
				?>
			<li class="<?php echo wc_get_account_menu_item_classes( 'downloads' ); ?>">
				<a href="<?php echo wc_get_account_endpoint_url( 'downloads' ); ?>">
					<?php echo __( 'Downloads', 'klasse-theme' ); ?>
				</a>
			</li>
				<?php
			}
			?>

			<li class="<?php echo wc_get_account_menu_item_classes( 'edit-address' ); ?>">
				<a href="<?php echo wc_get_account_endpoint_url( 'edit-address' ); ?>">
					<?php echo __( 'Addresses', 'klasse-theme' ); ?>
				</a>
			</li>

			<li class="<?php echo wc_get_account_menu_item_classes( 'edit-account' ); ?>">
				<a href="<?php echo wc_get_account_endpoint_url( 'edit-account' ); ?>">
					<?php echo __( 'Account details', 'klasse-theme' ); ?>
				</a>
			</li>

			<?php
			if ( function_exists( 'YITH_YWGC' ) ) {
				?>
				<li class="<?php echo wc_get_account_menu_item_classes( 'gift-cards' ); ?>">
					<a href="<?php echo wc_get_account_endpoint_url( 'gift-cards' ); ?>">
						<?php echo __( 'Gift cards', 'klasse-theme' ); ?>
					</a>
				</li>
				<?php
			}

			if ( defined( 'YITH_WCWL' ) ) {
				?>
				<li class="<?php echo YITH_WCWL()->get_wishlist_url(); ?>">
					<a href="<?php echo YITH_WCWL()->get_wishlist_url(); ?>">
						<?php echo __( 'Wishlist', 'klasse-theme' ); ?>
					</a>
				</li>
				<?php
			}

			if ( class_exists( 'WC_Points_Rewards' ) ) {
				?>
				<li class="<?php echo wc_get_account_menu_item_classes( 'points-and-rewards' ); ?>">
					<a href="<?php echo wc_get_account_endpoint_url( 'points-and-rewards' ); ?>">
						<?php echo __( 'Points and rewards', 'klasse-theme' ); ?>
					</a>
				</li>
				<?php
			}
			?>

			<li class="<?php echo wc_get_account_menu_item_classes( 'customer-logout' ); ?>">
				<a href="<?php echo wc_get_account_endpoint_url( 'customer-logout' ); ?>">
					<?php echo __( 'Logout', 'klasse-theme' ); ?>
				</a>
			</li>
		</ul>
</div>

<?php
do_action( 'woocommerce_after_account_navigation' );
