<?php

/**
 * Lost password confirmation text.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.9.0
 */

defined( 'ABSPATH' ) || exit;
?>
<div class="theme-container">
	<?php do_action( 'kls_breadcrumb' ); ?>

	<div class="theme-row">
		<div class="theme-col theme-col-6">
			<?php do_action( 'woocommerce_before_lost_password_confirmation_message' ); ?>
			<h3 class="account-page-title"><?php echo esc_html__( 'Password reset email has been sent.', 'klasse-theme' ); ?></h3>

			<p><?php echo esc_html( apply_filters( 'woocommerce_lost_password_confirmation_message', esc_html__( 'A password reset email has been sent to the email address on file for your account, but may take several minutes to show up in your inbox. Please wait at least 10 minutes before attempting another reset.', 'klasse-theme' ) ) ); ?></p>

			<?php do_action( 'woocommerce_after_lost_password_confirmation_message' ); ?>
		</div>
	</div>
</div>
