<?php

/**
 * Lost password form
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit;?>

<div class="theme-container">
	<?php
	do_action( 'kls_breadcrumb' );

	do_action( 'woocommerce_before_lost_password_form' );
	?>

	<div class="theme-row">
		<div class="theme-col theme-col-center theme-col-6">
			<h2><?php esc_html_e( 'Lost password', 'klasse-theme' ); ?></h2>

			<form method="post" class="woocommerce-ResetPassword lost_reset_password">

                <p><?php echo apply_filters( 'woocommerce_lost_password_message', esc_html__( 'Lost your password? Please enter your username or email address. You will receive a link to create a new password via email.', 'klasse-theme' ) ); ?></p><?php // @codingStandardsIgnoreLine ?>

				<div class="woocommerce-form-row woocommerce-form-row--first form-row form-row-wide">
					<label for="user_login"><?php esc_html_e( 'Username or email', 'klasse-theme' ); ?></label>
					<input class="woocommerce-Input woocommerce-Input--text input-text" type="text" name="user_login" id="user_login" autocomplete="username" />
				</div>

				<div class="clear"></div>

				<?php do_action( 'woocommerce_lostpassword_form' ); ?>

				<p class="woocommerce-form-row form-row">
					<input type="hidden" name="wc_reset_password" value="true" />
					<button type="submit" class="theme-button theme-button-primary" value="<?php esc_attr_e( 'Reset password', 'klasse-theme' ); ?>"><?php esc_html_e( 'Reset password', 'klasse-theme' ); ?></button>
				</p>

				<?php wp_nonce_field( 'lost_password', 'woocommerce-lost-password-nonce' ); ?>

			</form>
		</div>
	</div>
</div>
<?php
do_action( 'woocommerce_after_lost_password_form' );
