<?php

/**
 * My Account Dashboard
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
	// Exit if accessed directly.
}

$allowed_html = array(
	'a' => array(
		'href' => array(),
	),
);
$wishlist     = defined( 'YITH_WCWL' );
$account_arr  = array(
	// 'orders'          => array( __( 'Orders', 'klasse-theme' ), 'fas fa-box-open' ),
	// 'downloads'       => array( __( 'Downloads', 'klasse-theme' ), 'fas fa-cloud-download-alt' ),
	// 'edit-address'    => array( __( 'Addresses', 'klasse-theme' ), 'fas fa-map-marker-alt' ),
	// 'edit-account'    => array( __( 'Account details', 'klasse-theme' ), 'fas fa-user-alt' ),
	// 'customer-logout' => array( __( 'Logout', 'klasse-theme' ), 'fas fa-sign-out-alt' ),
);
?>

<div class="account-dashboard-text-wrapper">
	<p>
		<?php
		printf(/* translators: 1: user display name 2: logout url */
			wp_kses( __( 'Hello %1$s (not %1$s? <a href="%2$s">Log out</a>)', 'klasse-theme' ), $allowed_html ),
			'<strong>' . esc_html( $current_user->display_name ) . '</strong>',
			esc_url( wc_logout_url() )
		);
		?>
	</p>

	<p>
		<?php
		/* translators: 1: Orders URL 2: Address URL 3: Account URL. */
		$dashboard_desc = __( 'From your account dashboard you can view your <a href="%1$s">recent orders</a>, manage your <a href="%2$s">billing address</a>, and <a href="%3$s">edit your password and account details</a>.', 'klasse-theme' );
		if ( wc_shipping_enabled() ) {
			/* translators: 1: Orders URL 2: Addresses URL 3: Account URL. */
			$dashboard_desc = __( 'From your account dashboard you can view your <a href="%1$s">recent orders</a>, manage your <a href="%2$s">shipping and billing addresses</a>, and <a href="%3$s">edit your password and account details</a>.', 'klasse-theme' );
		}
		printf(
			wp_kses( $dashboard_desc, $allowed_html ),
			esc_url( wc_get_endpoint_url( 'orders' ) ),
			esc_url( wc_get_endpoint_url( 'edit-address' ) ),
			esc_url( wc_get_endpoint_url( 'edit-account' ) )
		);
		?>
	</p>
</div>
<div class="account-dashboard">
	<div class="account-dashboard-item">
		<a href="<?php echo wc_get_account_endpoint_url( 'orders' ); ?>">
			<i class="fas fa-box-open"></i>
			<h4><?php echo __( 'Orders', 'klasse-theme' ); ?></h4>
		</a>
	</div>

	<?php if ( get_theme_mod( 'my_account_downloads_toggle' ) == 1 ) { ?>
		<div class="account-dashboard-item">
			<a href="<?php echo wc_get_account_endpoint_url( 'downloads' ); ?>">
				<i class="fas fa-cloud-download-alt"></i>
				<h4><?php echo __( 'Downloads', 'klasse-theme' ); ?></h4>
			</a>
		</div>
	<?php } ?>

	<div class="account-dashboard-item">
		<a href="<?php echo wc_get_account_endpoint_url( 'edit-address' ); ?>">
			<i class="fas fa-map-marker-alt"></i>
			<h4><?php echo __( 'Addresses', 'klasse-theme' ); ?></h4>
		</a>
	</div>

	<div class="account-dashboard-item">
		<a href="<?php echo wc_get_account_endpoint_url( 'edit-account' ); ?>">
			<i class="fas fa-user-alt"></i>
			<h4><?php echo __( 'Account details', 'klasse-theme' ); ?></h4>
		</a>
	</div>

	<?php if ( function_exists( 'YITH_YWGC' ) ) { ?>
		<div class="account-dashboard-item">
			<a href="<?php echo wc_get_account_endpoint_url( 'gift-cards' ); ?>">
				<i class="fas fa-gift"></i>
				<h4><?php echo __( 'Gift cards', 'klasse-theme' ); ?></h4>
			</a>
		</div>
		<?php
	}

	if ( defined( 'YITH_WCWL' ) ) {
		?>
		<div class="account-dashboard-item">
			<a href="<?php echo YITH_WCWL()->get_wishlist_url(); ?>">
				<i class="fas fa-heart"></i>
				<h4><?php echo __( 'Wishlist', 'klasse-theme' ); ?></h4>
			</a>
		</div>
		<?php
	}

	if ( class_exists( 'WC_Points_Rewards' ) ) {
		?>
		<div class="account-dashboard-item">
			<a href="<?php echo wc_get_account_endpoint_url( 'points-and-rewards' ); ?>">
				<i class="fas fa-award"></i>
				<h4><?php echo __( 'Points and rewards', 'klasse-theme' ); ?></h4>
			</a>
		</div>
	<?php } ?>

	<div class="account-dashboard-item">
		<a href="<?php echo wc_get_account_endpoint_url( 'customer-logout' ); ?>">
			<i class="fas fa-sign-out-alt"></i>
			<h4><?php echo __( 'Logout', 'klasse-theme' ); ?></h4>
		</a>
	</div>
</div>
<?php
	/**
	 * My Account dashboard.
	 *
	 * @since 2.6.0
	 */
	do_action( 'woocommerce_account_dashboard' );

	/**
	 * Deprecated woocommerce_before_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_before_my_account' );

	/**
	 * Deprecated woocommerce_after_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_after_my_account' );

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
