<?php
/**
 * Gift Cards form in the Cart/Checkout
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce Gift Cards
 * @since   1.3.5
 * @version 1.3.5
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

do_action( 'woocommerce_gc_before_apply_gift_card_form' );

?><div class="add_gift_card_form">
	<h4><?php esc_html_e( 'Have a gift card?', 'klasse-theme' ); ?></h4>
	<div id="wc_gc_cart_redeem_form">
		<div class="wc_gc_add_gift_card_form__notices"></div>
		<input placeholder="<?php esc_attr_e( 'Enter your code&hellip;', 'klasse-theme' ); ?>" type="text" name="wc_gc_cart_code" id="wc_gc_cart_code" autocomplete="off" />
		<button type="button" name="wc_gc_cart_redeem_send" id="wc_gc_cart_redeem_send"><?php esc_html_e( 'Apply', 'klasse-theme' ); ?></button>
	</div>
</div><?php

do_action( 'woocommerce_gc_after_apply_gift_card_form' );
?>
