<style>
	body #page-container .woocommerce-customer-details .theme-row {
		width: 100% !important;
	}

	.woocommerce-order-downloads__title,
	.woocommerce-order-details__title {
		font-weight: bold;
	}

	.woocommerce-order-overview {
		display: flex;
		justify-content: space-around;
		margin-bottom: 30px;
	}

	.order-item {
		width: 20%;
		text-align: center;
	}

	.order-item strong {
		display: block;
	}

	.order-details.shop_table{
		margin-bottom: 0;
	}

	.woocommerce-order-details {
		margin-bottom: 20px;
	}

	@media(hover:hover){
		.download-product a:hover,
		.account-orders-table td a:not(.button):hover {
			text-decoration: underline;
		}
	}

	.woocommerce-order-downloads{
		margin-bottom: 20px;
	}

	.woocommerce-customer-details .theme-row {
		width: 100% !important;
		margin-bottom: 20px !important;
	}

	.shop_table td{
		padding: 10px !important;
	}

	.form-tracking-container{
		width: 75%;
		margin: 0 auto !important;
		margin-bottom: 50px;
	}

	.shop_table tfoot {
		border-top: 1px solid #eee;
		border-bottom: 1px solid #eee;
	}

	.shop_table thead tr {
		border-bottom: 1px solid #eeeeee;
	}

	.woocommerce-table__line-item:last-child td {
		padding-bottom: 20px !important;
	}

	.form-tracking-container{
		padding: 5%;
		background: #ffffff;
		box-shadow: 0 5px 8px rgb(0 0 0 / 15%);
		border-radius: 5px;
		margin-top: 10px !important;
		box-sizing: border-box;
	}

	.theme-container.background-color{
		padding-bottom: 50px;
	}

	.woocommerce-thankyou-order-details {
		padding-bottom: 20px;
		border-bottom-width: 1px;
		border-bottom-style: solid;
		border-color: #eeeeee;
	}

	@media (max-width: 980px) {
		.form-tracking-container{
			width: 90%;
		}
	}
	
</style>

<div class="theme-container background-color first">
	<?php do_action( 'kls_breadcrumb' ); ?>
	
	<div class="form-tracking-container">
		<div class="theme-row">
			<div class="theme-col theme-col-12">
				<div class="woocommerce-order-overview woocommerce-thankyou-order-details order_details">
					<div class="woocommerce-order-overview__order order order-item">
						<strong><?php esc_html_e( 'Order number:', 'klasse-theme' ); ?></strong>
						<?php echo $args['order']->get_order_number(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
					</div>

					<div class="woocommerce-order-overview__status status order-item">
						<strong><?php esc_html_e( 'Status', 'klasse-theme' ); ?></strong>
						<?php echo wc_get_order_status_name( $args['order']->get_status() ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
					</div>

					<div class="woocommerce-order-overview__date date order-item">
						<strong><?php esc_html_e( 'Date:', 'klasse-theme' ); ?></strong>
						<?php echo wc_format_datetime( $args['order']->get_date_created() ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
					</div>

					<div class="woocommerce-order-overview__total total order-item">
						<strong><?php esc_html_e( 'Total:', 'klasse-theme' ); ?></strong>
						<?php echo $args['order']->get_formatted_order_total(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
					</div>
				</div>
			</div>
		</div>
		<div class="theme-row">
			<div class="theme-col theme-col-12">
				<?php if ( $args['notes'] ) : ?>
				<h2><?php esc_html_e( 'Order updates', 'klasse-theme' ); ?></h2>
				<ol class="commentlist notes">
					<?php foreach ( $args['notes'] as $note ) : ?>
					<li class="comment note">
						<div class="comment_container">
							<div class="comment-text">
								<p class="meta"><?php echo date_i18n( esc_html__( 'l jS \o\f F Y, h:ia', 'klasse-theme' ), strtotime( $note->comment_date ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>
								<div class="description">
									<?php echo wpautop( wptexturize( $note->comment_content ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
								</div>
								<div class="clear"></div>
							</div>
							<div class="clear"></div>
						</div>
					</li>
					<?php endforeach; ?>
				</ol>
				<?php endif; ?>

				<?php do_action( 'woocommerce_view_order', $args['order']->get_id() ); ?>
			</div>
		</div>
	</div>
</div>
