<?php
defined( 'ABSPATH' ) || exit;

global $product;
if ( get_theme_mod( 'kls_product_banner_toggle', 0 ) == 1 ) :
	?>
	<div class="theme-container theme-banner theme-product-banner">
		<?php
		if ( ! wp_attachment_is_image( get_theme_mod( 'kls_product_banner_background_image' ) ) ) {
			?>
			<video autoplay muted loop>
				<source src="<?php echo esc_url_raw( wp_get_attachment_url( get_theme_mod( 'kls_product_banner_background_image', '' ) ) ); ?>" type=" <?php echo wp_check_filetype( wp_get_attachment_url( get_theme_mod( 'kls_product_banner_background_image', '' ) ) )['type']; ?>">
			</video>
			<?php
		}
		?>
		<div class="theme-row">
			<div class="theme-col-12">
				<h1 class="product_title entry-title"><?php echo esc_html( get_the_title() ); ?></h1>
				<div class="breadcrumb">
				<?php
				if ( function_exists( 'woocommerce_breadcrumb' ) ) {
					$args = array(
						'delimiter' => ' / ',
					);
					woocommerce_breadcrumb( $args );
				} elseif ( function_exists( 'yoast_breadcrumb' ) ) {
					yoast_breadcrumb();
				}
				?>
				</div>
			</div>
		</div>
	</div>
<?php else : ?>
	<div class="theme-container <?php echo ( get_theme_mod( 'kls_product_first_container_background', 0 ) == 1 ? 'background-color' : '' ); ?> theme-breadcrumb-container">
		<?php do_action( 'kls_breadcrumb' ); ?>
	</div>
<?php endif; ?>

<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>
	<div class="theme-container <?php echo ( get_theme_mod( 'kls_product_first_container_background', 0 ) == 1 ? 'background-color' : '' ); ?>">
		<?php

		/**
		 * Hook: woocommerce_before_single_product.
		 *
		 * @hooked woocommerce_output_all_notices - 10
		 */

		do_action( 'woocommerce_before_single_product' );
		?>
		<div class="theme-row">
			<div class="theme-col theme-col-<?php echo esc_html( get_theme_mod( 'kls_product_image_width', '5' ) ); ?>">
			<?php
				/**
				 * Hook: woocommerce_before_single_product_summary.
				 *
				 * @hooked woocommerce_show_product_sale_flash - 10
				 * @hooked woocommerce_show_product_images - 20
				 */
				do_action( 'woocommerce_before_single_product_summary' );
			?>
			</div>

			<div class="theme-col theme-col-<?php echo esc_html( get_theme_mod( 'kls_product_summary_width', '7' ) ); ?>">
				<div class="summary entry-summary">
				<?php
					/**
					 * Hook: woocommerce_single_product_summary.
					 *
					 * @hooked woocommerce_template_single_title - 5
					 * @hooked woocommerce_template_single_rating - 10
					 * @hooked woocommerce_template_single_price - 10
					 * @hooked woocommerce_template_single_excerpt - 20
					 * @hooked woocommerce_template_single_add_to_cart - 30
					 * @hooked woocommerce_template_single_meta - 40
					 * @hooked woocommerce_template_single_sharing - 50
					 * @hooked WC_Structured_Data::generate_product_data() - 60
					 */
					do_action( 'woocommerce_single_product_summary' );
				?>
				</div>
			</div>
		</div>
	</div>

	<div class="theme-container">
		<div class="theme-row">
			<div class="theme-col theme-col-12">
			<?php
				/**
				 * Hook: woocommerce_after_single_product_summary.
				 *
				 * @hooked woocommerce_output_product_data_tabs - 10
				 * @hooked woocommerce_upsell_display - 15
				 * @hooked woocommerce_output_related_products - 20
				 */
				do_action( 'woocommerce_after_single_product_summary' );
			?>
			</div>
		</div>

		<?php if ( get_theme_mod( 'product_recently_viewed_products_toggle' ) == 1 ) { ?>
			<div class="theme-row">
				<div class="theme-col theme-col-12">
					<?php
					do_action( 'recently_viewed_products' );
					?>
				</div>
			</div>
		<?php } ?>
	</div>

	<?php if ( get_theme_mod( 'product_add_divi_shortcode_id' ) != 'none' ) : ?>
		<div class="theme-container">
			<?php echo do_shortcode( '[et_pb_section global_module="' . get_theme_mod( 'product_add_divi_shortcode_id' ) . '"][/et_pb_section]' ); ?>
		</div>
	<?php endif; ?>

</div>
