<?php

/**
 * Thankyou page
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.7.0
 */

defined( 'ABSPATH' ) || exit;
?>
<div class="theme-container first">
  <div class="theme-row">
		<div class="theme-col theme-col-12">
<?php echo get_template_part( '/template-parts/woocommerce/checkout-breadcrumb', $GLOBALS['kls_checkout_flow_style_version'] ); ?>

<div class="woocommerce-order">

	<?php
	if ( $args['order'] ) :
		do_action( 'woocommerce_before_thankyou', $args['order']->get_id() );
		?>

		<?php
		if ( $args['order']->has_status( 'failed' ) ) :
			?>

			<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed"><?php esc_html_e( 'Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.', 'klasse-theme' ); ?></p>

		  <p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed-actions">
				<a href="<?php echo esc_url( $args['order']->get_checkout_payment_url() ); ?>" class="button pay"><?php esc_html_e( 'Pay', 'klasse-theme' ); ?></a>
				<?php
				if ( is_user_logged_in() ) :
					?>
					<a href="<?php echo esc_url( wc_get_page_permalink( 'myaccount' ) ); ?>" class="button pay"><?php esc_html_e( 'My account', 'klasse-theme' ); ?></a>
					<?php
				endif;
				?>
		  </p>

			<?php
		else :
			?>

			<p class="woocommerce-notice woocommerce-notice--success woocommerce-thankyou-order-received"><i class="fas fa-check"></i> <?php echo apply_filters( 'woocommerce_thankyou_order_received_text', esc_html__( 'Thank you. Your order has been received.', 'klasse-theme' ), $args['order'] ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>

		   <div class="woocommerce-order-overview woocommerce-thankyou-order-details order_details">

			 <div class="woocommerce-order-overview__order order order-item">
					<?php esc_html_e( 'Order number:', 'klasse-theme' ); ?>
					<strong><?php echo $args['order']->get_order_number(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
			 </div>

				<div class="woocommerce-order-overview__status status order-item">
					<?php esc_html_e( 'Status', 'klasse-theme' ); ?>
					<strong><?php echo wc_get_order_status_name( $args['order']->get_status() ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
			  </div>

				<div class="woocommerce-order-overview__date date order-item">
					<?php esc_html_e( 'Date:', 'klasse-theme' ); ?>
					<strong><?php echo wc_format_datetime( $args['order']->get_date_created() ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
			   </div>

				<div class="woocommerce-order-overview__total total order-item">
					<?php esc_html_e( 'Total:', 'klasse-theme' ); ?>
					<strong><?php echo $args['order']->get_formatted_order_total(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
			   </div>

				<?php
				if ( $args['order']->get_payment_method_title() ) :
					?>
				 <div class="woocommerce-order-overview__payment-method method order-item">
						<?php esc_html_e( 'Payment method:', 'klasse-theme' ); ?>
						<strong><?php echo wp_kses_post( $args['order']->get_payment_method_title() ); ?></strong>
					</div>
					<?php
				endif;
				?>
			</div>

			<?php
		endif;
		?>

		<?php do_action( 'woocommerce_thankyou_' . $args['order']->get_payment_method(), $args['order']->get_id() ); ?>
		<?php do_action( 'woocommerce_thankyou', $args['order']->get_id() ); ?>

		<?php
	else :
		?>

		<p class="woocommerce-notice woocommerce-notice--success woocommerce-thankyou-order-received"><?php echo apply_filters( 'woocommerce_thankyou_order_received_text', esc_html__( 'Thank you. Your order has been received.', 'klasse-theme' ), null ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>

		<?php
	endif;
	?>

</div>
</div>
	</div>
</div>
