
<table class="woocommerce-checkout-review-order-table order_details">
	<tbody>
		<?php
		do_action( 'woocommerce_review_order_before_cart_contents' );
		do_action( 'woocommerce_review_order_after_cart_contents' );
		?>
	</tbody>
	<tfoot>
		<tr class="cart-totals-container">
			<td colspan="2">
				<div class="cart-totals-summary-item">
					<div class="cart-totals-summary-item-icon">
						<i class="fas fa-box-open"></i>
					</div>
					<div class="cart-totals-summary-item-text">
						<p><?php esc_html_e( 'Delivery address', 'klasse-theme' ); ?></p>
						<?php
						if ( ! empty( WC()->cart->get_customer()->get_shipping_address() ) && ! empty( WC()->cart->get_customer()->get_shipping_postcode() ) && ! empty( WC()->cart->get_customer()->get_shipping_city() ) ) {
							echo WC()->cart->get_customer()->get_shipping_address() . ', ' . WC()->cart->get_customer()->get_shipping_postcode() . ' ' . WC()->cart->get_customer()->get_shipping_city();
						} else {
							esc_html_e( 'Not yet filled in', 'klasse-theme' );
						}
						?>
					</div>
				</div>
			</td>
		</tr>

		<tr class="cart-totals-container">
			<td colspan="2">
				<div class="cart-totals-summary-item">
					<div class="cart-totals-summary-item-icon">
						<i class="fas fa-truck"></i>
					</div>
					<div class="cart-totals-summary-item-text">
						<p><?php esc_html_e( 'Shipping', 'klasse-theme' ); ?></p>
						<?php
						if ( ! empty( WC()->session->get( 'chosen_shipping_methods' )[0] ) ) {
							foreach ( WC()->session->get( 'shipping_for_package_0' )['rates'] as $method_id => $rate ) {
								if ( WC()->session->get( 'chosen_shipping_methods' )[0] == $method_id ) {
									$rate_label = $rate->label;

									if ( ! empty( $rate_label ) ) {
										echo '<p class="shipping-total">
											<strong class="label">' . $rate_label . ': </strong>
											<span class="totals">' . WC()->cart->get_cart_shipping_total() . '</span>
										</p>';
									}
								}
							}
						} else {
							esc_html_e( 'Not yet chosen', 'klasse-theme' );
						}
						?>
					</div>
				</div>
			</td>
		</tr>

		<?php if ( WC()->cart->needs_payment() ) : ?>
			<tr class="cart-totals-container">
				<td colspan="2">
					<div class="cart-totals-summary-item">
						<div class="cart-totals-summary-item-icon">
							<i class="fas fa-credit-card"></i>
						</div>
						<div class="cart-totals-summary-item-text">
							<p><?php esc_html_e( 'Payment method', 'klasse-theme' ); ?></p>
							<?php
							$selected_payment_method_id = WC()->session->get( 'chosen_payment_method' );
							if ( isset( $selected_payment_method_id ) && ! empty( $selected_payment_method_id ) ) {
								echo WC()->payment_gateways->payment_gateways()[ $selected_payment_method_id ]->get_title();
							} else {
								esc_html_e( 'Not yet chosen', 'klasse-theme' );
							}
							?>
						</div>
					</div>
				</td>
			</tr>
		<?php endif; ?>

		<tr class="order-subtotal cart-totals-prices-first">
			<th><?php esc_html_e( 'Subtotal', 'klasse-theme' ); ?></th>
			<td data-title="<?php esc_attr_e( 'Subtotal', 'klasse-theme' ); ?>"><?php echo WC()->cart->get_total_ex_tax(); ?></td>
		</tr>
		
		<?php foreach ( WC()->cart->get_coupons() as $code => $coupon ) : ?>
			<tr class="cart-discount coupon-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
				<th class="totals-title"><?php wc_cart_totals_coupon_label( $coupon ); ?></th>
				<td data-title="<?php echo esc_attr( wc_cart_totals_coupon_label( $coupon, false ) ); ?>"><?php wc_cart_totals_coupon_html( $coupon ); ?></td>
			</tr>
		<?php endforeach; ?>
		
		<?php do_action( 'woocommerce_cart_totals_before_order_total' ); ?>

		<?php do_action( 'woocommerce_cart_totals_after_order_total' ); ?>

		<?php foreach ( WC()->cart->get_fees() as $fee ) : ?>
			<tr class="fee">
				<th class="totals-title"><?php echo esc_html( $fee->name ); ?></th>
				<td data-title="<?php echo esc_attr( $fee->name ); ?>"><?php wc_cart_totals_fee_html( $fee ); ?></td>
			</tr>
		<?php endforeach; ?>

		<?php do_action( 'woocommerce_review_order_before_order_total' ); ?>

		<tr class="order-total">
			<th class="totals-title"><?php esc_html_e( 'Total', 'klasse-theme' ); ?></th>
			<td class="total" data-title="<?php esc_attr_e( 'Total', 'klasse-theme' ); ?>"><?php wc_cart_totals_order_total_html(); ?></td>
		</tr>
		<?php do_action( 'woocommerce_review_order_after_order_total' ); ?>

		<?php if ( wc_tax_enabled() && ! WC()->cart->display_prices_including_tax() ) : ?>
			<?php if ( 'itemized' === get_option( 'woocommerce_tax_total_display' ) ) : ?>
				<?php foreach ( WC()->cart->get_tax_totals() as $code => $tax ) : // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited ?>
					<tr class="tax-rate tax-rate-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
						<th><?php echo esc_html( $tax->label ); ?></th>
						<td><?php echo wp_kses_post( $tax->formatted_amount ); ?></td>
					</tr>
				<?php endforeach; ?>
			<?php else : ?>
				<tr class="tax-total">
					<th><?php echo esc_html( WC()->countries->tax_or_vat() ); ?></th>
					<td><?php wc_cart_totals_taxes_total_html(); ?></td>
				</tr>
			<?php endif; ?>
		<?php endif; ?>
	</tfoot>
</table>
