<div class="theme-container background-color first">
<?php
echo get_template_part( '/template-parts/woocommerce/checkout-breadcrumb', $GLOBALS['kls_checkout_flow_style_version'] );
do_action( 'woocommerce_before_checkout_form', $args['checkout'] );

// If checkout registration is disabled and not logged in, the user cannot checkout.
if ( ! $args['checkout']->is_registration_enabled() && $args['checkout']->is_registration_required() && ! is_user_logged_in() ) {
	echo esc_html( apply_filters( 'woocommerce_checkout_must_be_logged_in_message', __( 'You must be logged in to checkout.', 'klasse-theme' ) ) );
	return;
}?>

<form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">
	<div class="theme-row">
		<?php if ( $args['checkout']->get_checkout_fields() ) : ?>
			<div class="theme-col theme-col-7">
				<?php do_action( 'woocommerce_checkout_before_customer_details' ); ?>

				<div class="checkout-customer-details" id="customer_details">
					<?php do_action( 'woocommerce_checkout_billing' ); ?>
					<?php do_action( 'woocommerce_checkout_shipping' ); ?>
				</div>

				<?php do_action( 'woocommerce_checkout_after_customer_details' ); ?>
			</div>
		<?php endif; ?>

		<div class="theme-col theme-col-5">
			<?php if ( wc_coupons_enabled() || function_exists( 'YITH_YWGC' ) ) : ?>
				<div class="accordion-wrapper">
					<?php if ( wc_coupons_enabled() ) : ?>
						<div class="accordion-item accordion-coupon show">
							<div class="accordion-toggle show">
								<p><?php echo __( 'Coupon code', 'klasse-theme' ); ?></p>
							</div>
							<div class="accordion-content show">
								<p><?php esc_html_e( 'If you have a coupon code, please apply it below.', 'klasse-theme' ); ?></p>
									<!-- <form class="checkout_coupon woocommerce-form-coupon" method="post"> -->
										<input type="text" name="coupon_code_under" class="input-text" placeholder="<?php esc_attr_e( 'Coupon code', 'klasse-theme' ); ?>" id="coupon_code_under" value="" />
										<button type="submit" class="button theme-button theme-button-secundary" name="coupon_code_under" value="<?php esc_attr_e( 'Apply coupon', 'klasse-theme' ); ?>" form="checkout_coupon_form"><?php esc_html_e( 'Apply coupon', 'klasse-theme' ); ?></button>

										<div class="clear"></div>
									<!-- </form> -->
							</div>
						</div>
					<?php endif; ?>

					<?php if ( function_exists( 'YITH_YWGC' ) ) : ?>
					<div class="accordion-item accordion-giftcard accordion-primary">
						<div class="accordion-toggle">
							<p><?php echo __( 'Giftcard', 'klasse-theme' ); ?></p>
						</div>
						<div class="accordion-content" style="display:none;">
							<div class="ywgc_enter_code" method="post" style="">
								<p><?php echo get_option( 'ywgc_text_in_the_form', esc_html__( 'Apply the gift card code in the following field', 'klasse-theme' ) ); ?></p>

								<input type="text" name="gift_card_code" class="input-text"
									placeholder="<?php echo esc_attr( apply_filters( 'ywgc_checkout_box_placeholder', _x( 'Gift card code', 'Apply gift card', 'klasse-theme' ) ) ); ?>"
									id="giftcard_code" value="" />

								<button type="submit" class="button ywgc_apply_gift_card_button" name="ywgc_apply_gift_card" value="<?php echo get_option( 'ywgc_apply_gift_card_button_text', esc_html__( 'Apply Gift Card', 'klasse-theme' ) ); ?>"><?php echo get_option( 'ywgc_apply_gift_card_button_text', esc_html__( 'Apply Gift Card', 'klasse-theme' ) ); ?></button>
								<input type="hidden" name="is_gift_card" value="1" />

								<div class="clear"></div>

								<?php if ( WC()->cart->total < get_option( 'ywgc_minimal_cart_total_value' ) ) : ?>
									<div class="yith_wc_gift_card_blank_brightness"></div>
								<?php endif; ?>
							</div>
						</div>
					</div>
					<?php endif; ?>
				</div>
			<?php endif; ?>

			<div class="checkout-totals">
				<?php do_action( 'woocommerce_checkout_before_order_review_heading' ); ?>
				
				<h2 id="order_review_heading"><?php esc_html_e( 'Your order', 'klasse-theme' ); ?></h2>
				
				<?php do_action( 'woocommerce_checkout_before_order_review' ); ?>

				<div id="order_review" class="woocommerce-checkout-review-order">
					<?php do_action( 'woocommerce_checkout_order_review' ); ?>
				</div>

				<?php do_action( 'woocommerce_checkout_after_order_review' ); ?>
			</div>
		</div>
	</div>
</form>
<?php
do_action( 'woocommerce_after_checkout_form', $args['checkout'] );
?>
</div>
