<div class="checkout_flow_totals cart_totals <?php echo ( WC()->customer->has_calculated_shipping() ) ? 'calculated_shipping' : ''; ?>">

	<?php do_action( 'woocommerce_before_cart_totals' ); ?>

	<table cellspacing="0" class="cart-collaterals_table">
		<tr class="cart-totals-container">
			<td colspan="2">
				<div class="cart-totals-summary-item">
					<div class="cart-totals-summary-item-icon">
						<i class="fas fa-box-open"></i>
					</div>
					<div class="cart-totals-summary-item-text">
						<p><?php esc_html_e( 'Delivery address', 'klasse-theme' ); ?></p>
						<?php
						if ( ! empty( WC()->cart->get_customer()->get_shipping_address() ) && ! empty( WC()->cart->get_customer()->get_shipping_postcode() ) && ! empty( WC()->cart->get_customer()->get_shipping_city() ) ) {
							echo WC()->cart->get_customer()->get_shipping_address() . ', ' . WC()->cart->get_customer()->get_shipping_postcode() . ' ' . WC()->cart->get_customer()->get_shipping_city();
						} else {
							esc_html_e( 'Not yet filled in', 'klasse-theme' );
						}
						?>
					</div>
				</div>
			</td>
		</tr>

		<tr class="cart-totals-container">
			<td colspan="2">
				<div class="cart-totals-summary-item">
					<div class="cart-totals-summary-item-icon">
						<i class="fas fa-truck"></i>
					</div>
					<div class="cart-totals-summary-item-text">
						<p><?php esc_html_e( 'Shipping', 'klasse-theme' ); ?></p>
						<?php
						if ( ! empty( WC()->session->get( 'chosen_shipping_methods' )[0] ) ) {
							foreach ( WC()->session->get( 'shipping_for_package_0' )['rates'] as $method_id => $rate ) {
								if ( WC()->session->get( 'chosen_shipping_methods' )[0] == $method_id ) {
									$rate_label = $rate->label;

									if ( ! empty( $rate_label ) ) {
										echo '<p class="shipping-total">
											<strong class="label">' . $rate_label . ': </strong>
											<span class="totals">' . WC()->cart->get_cart_shipping_total() . '</span>
										</p>';
									}
								}
							}
						} else {
							esc_html_e( 'Not yet chosen', 'klasse-theme' );
						}
						?>
					</div>
				</div>
			</td>
		</tr>

		<?php if ( WC()->cart->needs_payment() ) : ?>
		<tr class="cart-totals-container">
			<td colspan="2">
				<div class="cart-totals-summary-item">
					<div class="cart-totals-summary-item-icon">
						<i class="fas fa-credit-card"></i>
					</div>
					<div class="cart-totals-summary-item-text">
						<p><?php esc_html_e( 'Payment method', 'klasse-theme' ); ?></p>
						<?php
						$selected_payment_method_id = WC()->session->get( 'chosen_payment_method' );
						if ( isset( $selected_payment_method_id ) && ! empty( $selected_payment_method_id ) ) {
							echo WC()->payment_gateways->payment_gateways()[ $selected_payment_method_id ]->get_title();
						} else {
							esc_html_e( 'Not yet chosen', 'klasse-theme' );
						}
						?>
					</div>
				</div>
			</td>
		</tr>
		<?php endif; ?>

		<tr class="order-subtotal cart-totals-prices-first">
			<th><?php esc_html_e( 'Subtotal', 'klasse-theme' ); ?></th>
			<td data-title="<?php esc_attr_e( 'Subtotal', 'klasse-theme' ); ?>"><?php echo WC()->cart->get_total_ex_tax(); ?></td>
		</tr>
		
		<?php foreach ( WC()->cart->get_coupons() as $code => $coupon ) : ?>
			<tr class="cart-discount coupon-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
				<th class="totals-title"><?php wc_cart_totals_coupon_label( $coupon ); ?></th>
				<td data-title="<?php echo esc_attr( wc_cart_totals_coupon_label( $coupon, false ) ); ?>"><?php wc_cart_totals_coupon_html( $coupon ); ?></td>
			</tr>
		<?php endforeach; ?>
		
		<?php do_action( 'woocommerce_cart_totals_before_order_total' ); ?>

		<?php do_action( 'woocommerce_cart_totals_after_order_total' ); ?>

		<?php foreach ( WC()->cart->get_fees() as $fee ) : ?>
			<tr class="fee">
				<th class="totals-title"><?php echo esc_html( $fee->name ); ?></th>
				<td data-title="<?php echo esc_attr( $fee->name ); ?>"><?php wc_cart_totals_fee_html( $fee ); ?></td>
			</tr>
		<?php endforeach; ?>

		<tr class="order-total">
			<th class="totals-title"><?php esc_html_e( 'Total', 'klasse-theme' ); ?></th>
			<td data-title="<?php esc_attr_e( 'Total', 'klasse-theme' ); ?>"><?php wc_cart_totals_order_total_html(); ?></td>
		</tr>

		<?php
		if ( wc_tax_enabled() && ! WC()->cart->display_prices_including_tax() ) {
			$taxable_address = WC()->customer->get_taxable_address();
			$estimated_text  = '';

			if ( WC()->customer->is_customer_outside_base() && ! WC()->customer->has_calculated_shipping() ) {
				/* translators: %s location. */
				$estimated_text = sprintf( ' <small>' . esc_html__( '(estimated for %s)', 'klasse-theme' ) . '</small>', WC()->countries->estimated_for_prefix( $taxable_address[0] ) . WC()->countries->countries[ $taxable_address[0] ] );
			}

			if ( 'itemized' === get_option( 'woocommerce_tax_total_display' ) ) {
				foreach ( WC()->cart->get_tax_totals() as $code => $tax ) { // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
					?>
					<tr class="tax-rate tax-rate-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
						<th><?php echo esc_html( $tax->label ) . $estimated_text; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></th>
						<td data-title="<?php echo esc_attr( $tax->label ); ?>"><?php echo wp_kses_post( $tax->formatted_amount ); ?></td>
					</tr>
					<?php
				}
			} else {
				?>
				<tr class="tax-total">
					<th><?php echo esc_html( WC()->countries->tax_or_vat() ) . $estimated_text; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></th>
					<td data-title="<?php echo esc_attr( WC()->countries->tax_or_vat() ); ?>"><?php wc_cart_totals_taxes_total_html(); ?></td>
				</tr>
				<?php
			}
		}
		?>

	</table>

	<div class="wc-proceed-to-checkout">
		<?php do_action( 'woocommerce_proceed_to_checkout' ); ?>
		<div class="cart-small-actions">
			<a href="?clear-cart" class="button-link"><?php esc_html_e( 'Empty cart', 'klasse-theme' ); ?></a>
		</div>
	</div>

	<?php do_action( 'woocommerce_after_cart_totals' ); ?>

</div>
