<?php
/**
 * Empty cart page
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit;
?>

<div class="theme-container first background-color">
	<div class="theme-row">
		<div class="theme-col theme-col-12">
			<h1><strong><?php esc_html_e( 'Complete order', 'klasse-theme' ); ?></strong></h1>
		</div>
	</div>

	<div class="theme-row">
		<div class="theme-col theme-col-8 items-col">
			<?php echo get_template_part( '/template-parts/woocommerce/checkout-breadcrumb', $GLOBALS['kls_checkout_flow_style_version'] ); ?>
			<div class="woocommerce-cart-container woocommerce-cart-container-form">
				<table class="shop_table shop_table_responsive cart woocommerce-cart-form__contents" cellspacing="0">
					<tbody>
						<tr>
							<td colspan="2">
								<div class="cart-text-container">
									<div class="cart-text-container-icon">
										<i class="fas fa-shopping-cart"></i>
									</div>
									<div class="cart-text-container-text">
										<h2><?php esc_html_e( 'Your shopping cart is empty', 'klasse-theme' ); ?></h2>
										<p>&nbsp;</p>
										<p class="return-to-shop">
											<a href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>" class="theme-button theme-button-primary"><?php esc_html_e( 'Return to the shop', 'klasse-theme' ); ?></a>
										</p>
									</div>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>

		<div class="theme-col theme-col-4">
			<div class="cart-collaterals sticky-module">
				<div class="cart_totals <?php echo ( WC()->customer->has_calculated_shipping() ) ? 'calculated_shipping' : ''; ?>">
					<table cellspacing="0" class="cart-collaterals_table">
						<tr class="cart-totals-container">
							<td colspan="2">
								<div class="cart-totals-summary-item">
									<div class="cart-totals-summary-item-icon">
										<i class="fas fa-box-open"></i>
									</div>
									<div class="cart-totals-summary-item-text">
										<p><?php esc_html_e( 'Delivery address', 'klasse-theme' ); ?></p>
										<?php
										if ( ! empty( WC()->cart->get_customer()->get_billing_address() ) && ! empty( WC()->cart->get_customer()->get_billing_postcode() ) && ! empty( WC()->cart->get_customer()->get_billing_city() ) ) {
											echo WC()->cart->get_customer()->get_billing_address() . ', ' . WC()->cart->get_customer()->get_billing_postcode() . ' ' . WC()->cart->get_customer()->get_billing_city();
										} else {
											esc_html_e( 'Not yet filled in', 'klasse-theme' );
										}
										?>
									</div>
								</div>
							</td>
						</tr>

						<tr class="cart-totals-container">
							<td colspan="2">
								<div class="cart-totals-summary-item">
									<div class="cart-totals-summary-item-icon">
										<i class="fas fa-truck"></i>
									</div>
									<div class="cart-totals-summary-item-text">
										<p><?php esc_html_e( 'Shipping', 'klasse-theme' ); ?></p>
										<?php
										if ( ! empty( WC()->session->get( 'chosen_shipping_methods' )[0] ) ) {
											foreach ( WC()->session->get( 'shipping_for_package_0' )['rates'] as $method_id => $rate ) {
												if ( WC()->session->get( 'chosen_shipping_methods' )[0] == $method_id ) {
													$rate_label = $rate->label;

													if ( ! empty( $rate_label ) ) {
														echo '<p class="shipping-total">
															<strong class="label">' . $rate_label . ': </strong>
															<span class="totals">' . WC()->cart->get_cart_shipping_total() . '</span>
														</p>';
													}
												}
											}
										} else {
											esc_html_e( 'Not yet chosen', 'klasse-theme' );
										}
										?>
									</div>
								</div>
							</td>
						</tr>

						<tr class="cart-totals-container">
							<td colspan="2">
								<div class="cart-totals-summary-item">
									<div class="cart-totals-summary-item-icon">
										<i class="fas fa-credit-card"></i>
									</div>
									<div class="cart-totals-summary-item-text">
										<p><?php esc_html_e( 'Payment method', 'klasse-theme' ); ?></p>
										<?php
										$selected_payment_method_id = WC()->session->get( 'chosen_payment_method' );
										if ( isset( $selected_payment_method_id ) ) {
											echo WC()->payment_gateways->payment_gateways()[ $selected_payment_method_id ]->get_title();
										} else {
											esc_html_e( 'Not yet chosen', 'klasse-theme' );
										}
										?>
									</div>
								</div>
							</td>
						</tr>
					</table>
				</div>
			</div>
		</div>
	</div>

	<?php
	if ( get_theme_mod( 'cart_recently_viewed_products_toggle' ) == 1 ) {
		?>
	<div class="theme-row">
		<div class="theme-col theme-col-12">
			<?php do_action( 'recently_viewed_products' ); ?>
		</div>
	</div>
	<?php } ?>
</div>
