<?php
/**
 * Empty cart page
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit;
?>
<div class="theme-container">
   <div class="theme-row">
		<div class="theme-col theme-col-12">
			<?php echo get_template_part( '/template-parts/woocommerce/checkout-breadcrumb', $GLOBALS['kls_checkout_flow_style_version'] ); ?>
			<div class="cart-empty-page">
				<i class="fa fa-shopping-cart icon"></i>
					<p class="cart-empty"><?php esc_html_e( 'No products added to the cart', 'klasse-theme' ); ?></p>
					<p class="return-to-shop">
					<a class="button wc-backward btn-v-dark btn-go-shop theme-button theme-button-primary" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">
						<?php esc_html_e( 'Return to the shop', 'klasse-theme' ); ?>
					</a>
				</p>
			</div>
			<?php
			if ( get_theme_mod( 'cart_recently_viewed_products_toggle' ) == 1 ) {
				?>
			<div class="theme-row">
				<div class="theme-col theme-col-12">
					<?php do_action( 'recently_viewed_products' ); ?>
				</div>
			</div>
			<?php } ?>
		</div>
	</div>
</div>
