<?php
// Args from the shortcode
$shortcode_args = $args;
$exclude_id     = $shortcode_args['exclude_id'];
$include_id     = $shortcode_args['include_id'];
$hide           = $shortcode_args['hide_empty'];
$orderby        = $shortcode_args['orderby'];
$order          = $shortcode_args['order'];
$layout_class   = $shortcode_args['layout'];
$maximum        = $shortcode_args['maximum'];

// Args for the loop
$args = array(
	'taxonomy'      => 'product_cat',
	'orderby'       => ( $orderby ? $orderby : 'menu_order' ),
	'order'         => ( $order ? $order : 'asc' ),
	'show_count'    => 0,
	'pad_count'     => 0,
	'hierarchical ' => 0,
	'hide_empty'    => $hide,
);

$loop           = new WP_Query( $args );
$all_categories = get_categories( $args );
$i              = 0;

echo '<div class="category-block-layout ' . $layout_class . '">';
foreach ( $all_categories as $cat ) {
	if ( $cat->category_parent == 0 ) {
		if ( ! in_array( $cat->term_id, $exclude_id ) || isset( $include_id ) && in_array( $cat->term_id, $include_id ) ) {
			if ( ++$i == ( $maximum + 1 ) ) {
				break;
			}

			$thumbnail_id   = get_term_meta( $cat->term_id, 'thumbnail_id', true );
			$cat_short_desc = get_term_meta( $cat->term_id, 'kls_short_desc', true );
			echo '
            <div class="category-block-layout-item">
                <a href="' . get_term_link( $cat->slug, 'product_cat' ) . '">
                    <div class="category-block-layout-item-image-container">
                        <div class="category-block-layout-item-image"><img src="' . wp_get_attachment_image_url( $thumbnail_id, 'category-block-layout-image' ) . '" data-no-lazy="1"></div>
                    </div>
                    <div class="category-block-layout-item-content-container">
                        <div class="category-block-layout-content">
                            <p><strong>' . $cat->name . '</strong>' . $cat_short_desc . ' <i class="fas fa-chevron-right"></i></p>
                        </div>
                    </div>
                </a>
            </div>';
		}
	}
};
echo '</div>';

wp_reset_query();

// Add SyncSilo script.
if ( get_option( 'kls_syncsilo_compatibility_toggle' ) == 'on' && defined( 'YITH_WCQV' ) ) :
	wp_enqueue_script( 'wwa_pc/js/wp.hooks', 'https://js-cdn.syncsilo.com/wwa-configurator.min.js', array(), $GLOBALS['kls_theme_version'] );
endif;
