<div class="menu-sidebar-container">
	<div class="menu-sidebar-menu-wrapper">
		<?php
		$host = get_site_url() . $_SERVER['REQUEST_URI'];

		if ( get_theme_mod( 'kls_sidebar_logo_toggle' ) == 1 ) :
			?>
			<div class="menu-sidebar-logo-container">
				<a href="<?php echo esc_url( home_url() ); ?>" class="logo">
					<img src="<?php echo esc_url( $GLOBALS['customer_logo'][0] ); ?>" alt="Logo van <?php echo esc_html( $GLOBALS['customer_name'] ); ?>" width="<?php echo esc_html( $GLOBALS['customer_logo'][1] ); ?>" height="<?php echo esc_html( $GLOBALS['customer_logo'][2] ); ?>" class="logo-img" data-no-lazy="1"/>
				</a>
			</div>
			<?php
		endif;
		?>
		<ul>
			<?php
			if ( ! empty( get_theme_mod( 'kls_sidebar_dashboard_link' ) ) ) {
				$dashboard_url = get_permalink( get_theme_mod( 'kls_sidebar_dashboard_link' ) );
			} else {
				$dashboard_url = wc_get_account_endpoint_url( 'dashboard' );
			}
			?>
			<li class="
			<?php
			echo esc_url( $dashboard_url );
			echo $host == $dashboard_url ? ' is-active' : '';
			?>
			">
				<a href="<?php echo esc_url( $dashboard_url ); ?>"><span class="menu-sidebar-icon"><i class="fas fa-tachometer-alt"></i></span><span><?php esc_html_e( 'Dashboard', 'klasse-theme' ); ?></span></a>
			</li>
			<li class="<?php echo esc_html( wc_get_account_menu_item_classes( 'orders' ) ); ?>">
				<a href="<?php echo esc_url( wc_get_account_endpoint_url( 'orders' ) ); ?>"><span class="menu-sidebar-icon"><i class="fas fa-box-open"></i></span><span><?php esc_html_e( 'Orders', 'klasse-theme' ); ?></span></a>
			</li>
			<li class="
			<?php
			echo esc_html( get_permalink( wc_get_page_id( 'shop' ) ) );
			echo ( is_shop() ? ' is-active' : '' );
			?>
			">
				<a href="<?php echo esc_url( get_permalink( wc_get_page_id( 'shop' ) ) ); ?>"><span class="menu-sidebar-icon"><i class="fas fa-box"></i></span><span><?php esc_html_e( 'Products', 'klasse-theme' ); ?></span></a>
			</li>
			<?php
			if ( function_exists( 'YITH_YWGC' ) ) {
				?>
				<li class="<?php echo esc_html( wc_get_account_menu_item_classes( 'gift-cards' ) ); ?>">
					<a href="<?php echo esc_url( wc_get_account_endpoint_url( 'gift-cards' ) ); ?>"><span class="menu-sidebar-icon"><i class="fas fa-star"></i></span><span><?php esc_html_e( 'Gift cards', 'klasse-theme' ); ?></span></a>
				</li>
				<?php
			}

			if ( defined( 'YITH_WCWL' ) ) {
				?>
				<li class="
				<?php
				echo esc_html( YITH_WCWL()->get_wishlist_url() );
				echo ( $host == YITH_WCWL()->get_wishlist_url() ? ' is-active' : '' );
				?>
				">
					<a href="<?php echo esc_url( YITH_WCWL()->get_wishlist_url() ); ?>"><span class="menu-sidebar-icon"><i class="fas fa-star"></i></span><span><?php esc_html_e( 'Wishlist', 'klasse-theme' ); ?></span></a>
				</li>
				<?php
			}
			?>
		</ul>
	</div>
	<div class="menu-sidebar-information">
		<ul>
			<li class="<?php echo esc_html( wc_get_account_menu_item_classes( 'dashboard' ) ); ?>">
				<?php global $current_user; ?>
				<a href="<?php echo esc_url( wc_get_account_endpoint_url( 'dashboard' ) ); ?>"><span class="menu-sidebar-icon"><i class="fas fa-user"></i></span><span><strong><?php esc_html_e( 'Logged in as', 'klasse-theme' ); ?></strong><br><?php echo esc_html( $current_user->user_email ); ?></span></a>
			</li>
			<li class="<?php echo esc_html( wc_get_account_menu_item_classes( 'edit-account' ) ); ?>">
				<a href="<?php echo esc_url( wc_get_account_endpoint_url( 'edit-account' ) ); ?>"><span class="menu-sidebar-icon"><i class="fas fa-cog"></i></span><span><?php esc_html_e( 'Settings', 'klasse-theme' ); ?></span></a>
			</li>
			<li class="<?php echo esc_html( wc_get_account_menu_item_classes( 'customer-logout' ) ); ?>">
				<a href="<?php echo esc_url( wc_get_account_endpoint_url( 'customer-logout' ) ); ?>"><span class="menu-sidebar-icon"><i class="fas fa-sign-out-alt"></i></span><span><?php esc_html_e( 'Logout', 'klasse-theme' ); ?></span></a>
			</li>
		</ul>
	</div>
	<div class="sidebar-menu-toggle"><i class="fas fa-chevron-right"></i></div>
</div>
