<?php if ( get_theme_mod( 'mobile_bottom_bar_logo_above_content_toggle' ) == '1' ) : ?>
<div class="mobile-navigation-content-logo">
	<div class="mobile-navigation-content-logo-row">
		<a href="<?php echo home_url(); ?>" class="logo">
			<img src="<?php echo $GLOBALS['customer_logo'][0]; ?>" alt="Logo van <?php echo $GLOBALS['customer_name']; ?>" width="<?php echo $GLOBALS['customer_logo'][1]; ?>" height="<?php echo $GLOBALS['customer_logo'][2]; ?>" class="logo-img"/>
		</a>
	</div>
</div>
<?php endif; ?>

<div class="mobile-navigation">
	<div class="mobile-navigation-wrapper">
		<div class="mobile-navigation-menu-wrapper">
			<div class="mobile-menu-toggle">
				<span></span>
				<span></span>
				<span></span>
			</div>
		</div>

		<?php if ( get_theme_mod( 'general_menu_my_account_toggle' ) == '1' ) : ?>
			<div class="mobile-navigation-item">
				<div class="menu-my-account">
					<?php echo '<a href="' . get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) . '"' . ' title="' . __( 'My account', 'klasse-theme' ) . '"><i class="fas fa-user-alt"></i> <div class="item-text">' . __( 'Account', 'klasse-theme' ) . '</div></a>'; ?>
				</div>
			</div>
		<?php endif; ?>

		<div class="mobile-navigation-item">
			<div class="menu-contact">
				<a href="<?php echo kls_translate_theme_mod( 'mobile_bottom_bar_v2_contact_link', 'Bottom bar shop V2 contact knop link', 'nl' ); ?>"><i class="<?php echo get_theme_mod( 'mobile_bottom_bar_v2_contact_icon', 'fas fa-envelope' ); ?>"></i> <div class="item-text"><?php echo kls_translate_theme_mod( 'mobile_bottom_bar_v2_contact_text', 'Bottom bar shop V2 contact knop tekst', 'nl' ); ?></div></a>
			</div>
		</div>

		<?php if ( get_theme_mod( 'kls_mobile_bottom_bar_search_toggle' ) == '1' ) : ?>
			<div class="mobile-navigation-item">
				<div class="menu-search mobile-search">
					<div class="menu-search-mobile-icon">
						<i class="fas fa-search"></i>
						<div class="item-text"><?php _e( 'Search', 'klasse-theme' ); ?></div>
					</div>
					<div class="mobile-search-container">
						<div class="menu-search-form-wrapper">
							<?php
							if ( get_theme_mod( 'search_toggle' ) == '1' ) :
								if ( ! defined( 'YITH_WCAS' ) ) :
									echo get_search_form();
								else :
									echo do_shortcode( '[yith_woocommerce_ajax_search]' );
								endif;
							endif;
							?>
						</div>
					</div>
				</div>
			</div>
		<?php endif; ?>

		<?php if ( defined( 'YITH_WCWL' ) && get_theme_mod( 'general_menu_wishlist_toggle' ) == '1' ) : ?>
			<div class="mobile-navigation-item">
				<div class="menu-wishlist">
					
					<?php
					$wc_count = ( function_exists( 'yith_wcwl_count_products' ) ? yith_wcwl_count_products() : '0' );
					$yith_url = ( function_exists( 'YITH_WCWL' ) ? YITH_WCWL()->get_wishlist_url() : '' );
					echo '<a href="' . esc_url( $yith_url ) . '"' . ' title="' . esc_attr__( 'Wishlist', 'klasse-theme' ) . '"><div class="menu-cart-icon-wrapper"><i class="fas fa-heart"></i><span class="menu-wishlist-count">' . intval( $wc_count ) . '</span></div> <div class="item-text">' . __( 'Wishlist', 'klasse-theme' ) . '</div></a>';
					?>
				</div>
			</div>
		<?php endif; ?>

		<?php
		if ( get_theme_mod( 'general_menu_cart_toggle' ) == '1' ) :
			$items = ( function_exists( 'WC' ) ? count( WC()->cart->get_cart() ) : '0' );
			?>
		<div class="mobile-navigation-item">
			<div class="menu-cart">
				<div class="menu-cart-icon">
					<div class="menu-cart-icon-wrapper">
						<i class="fas fa-shopping-cart"></i>
						<div class="menu-cart-count"><span class="cart-count"><?php echo ( function_exists( 'WC' ) ? WC()->cart->get_cart_contents_count() : '0' ); ?></span></div>
					</div>
					<div class="item-text"><?php echo __( 'Cart', 'klasse-theme' ); ?></div>
				</div>

				<?php do_action( 'kls_mini_cart_v1' ); ?>
			</div>
		</div>
		<?php endif; ?>
	</div>
</div>
