<nav class="main-nav">
	<div class="main-navigation-wrapper">
		<a href="<?php echo home_url(); ?>" class="logo">
			<img src="<?php echo $GLOBALS['customer_logo'][0]; ?>" alt="Logo van <?php echo $GLOBALS['customer_name']; ?>" width="<?php echo $GLOBALS['customer_logo'][1]; ?>" height="<?php echo $GLOBALS['customer_logo'][2]; ?>" class="logo-img" data-no-lazy="1"/>
		</a>

		<div class="menu-icon-search-container">
			<div class="nav-menu">
				<?php
				if ( get_theme_mod( 'search_toggle' ) == '1' ) :
					?>
						<div class="mobile-menu-search">
							<i class="fas fa-search"></i>
						</div>
					<?php
				endif;
				if ( class_exists( 'WooCommerce' ) ) :
					if ( get_theme_mod( 'general_menu_my_account_toggle' ) == '1' ) :
						?>
						<div class="menu-my-account">
							<?php echo '<a href="' . get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) . '"' . ' title="' . __( 'My account', 'klasse-theme' ) . '"><i class="fas fa-user-alt"></i></a>'; ?>
						</div>
						<?php
					endif;

					if ( defined( 'YITH_WCWL' ) && get_theme_mod( 'general_menu_wishlist_toggle' ) == '1' ) :
						?>
						<div class="menu-wishlist">
							<?php
							$wc_count = yith_wcwl_count_products();
							echo '<a href="' . esc_url( YITH_WCWL()->get_wishlist_url() ) . '"' . ' title="' . esc_attr__( 'Wishlist', 'klasse-theme' ) . '"><i class="fas fa-heart"></i><span class="menu-wishlist-count">' . intval( $wc_count ) . '</span></a>';
							?>
						</div>
					<?php endif; ?>

					<?php
					if ( get_theme_mod( 'general_menu_cart_toggle' ) == '1' ) :
						$items = sizeof( WC()->cart->get_cart() );
						?>
						<div class="menu-cart">
							<div class="menu-cart-icon">
								<i class="fas fa-shopping-cart"></i>
								<div class="menu-cart-count"><span class="cart-count"><?php echo WC()->cart->get_cart_contents_count(); ?></span></div>
								<a href="<?php echo wc_get_cart_url(); ?>" class="cart-link"><span class="hidden"><?php echo __( 'View cart', 'klasse-theme' ); ?></span></a>
							</div>

							<?php do_action( 'kls_mini_cart_v1' ); ?>
						</div>
						<?php
					endif;
				endif;
				?>
			</div>

			<?php
			if ( get_theme_mod( 'search_toggle' ) == '1' ) :
				if ( ! defined( 'YITH_WCAS' ) ) :
					echo get_search_form();
				else :
					echo do_shortcode( '[yith_woocommerce_ajax_search]' );
				endif;
			endif;
			?>
		</div>
	</div>
	<div class="main-navigation-menu-wrapper">
		<?php if ( get_theme_mod( 'navigation_rating_toggle' ) == 1 ) : ?>
			<div class="rating-wrapper">
			<?php
		endif;

		wp_nav_menu(
			array(
				'theme_location' => 'primary',
				'container'      => false,
				'fallback_cb'    => false,
			)
		);

		if ( get_theme_mod( 'navigation_rating_toggle' ) == 1 ) :
			kls_star_rating();
		endif;

		if ( get_theme_mod( 'navigation_rating_toggle' ) == 1 ) :
			?>
		</div>
		<?php endif; ?>
	</div>
</nav>

