<nav class="main-nav">
	<div class="main-navigation-wrapper">
		<a href="<?php echo home_url(); ?>" class="logo">
			<img src="<?php echo $GLOBALS['customer_logo'][0]; ?>" alt="Logo van <?php echo $GLOBALS['customer_name']; ?>" width="<?php echo $GLOBALS['customer_logo'][1]; ?>" height="<?php echo $GLOBALS['customer_logo'][2]; ?>" class="logo-img" data-no-lazy="1"/>
		</a>

		<!-- <div class="nav-menu"> -->
			<?php
			wp_nav_menu(
				array(
					'theme_location' => 'primary',
					'container'      => false,
					'fallback_cb'    => false,
				)
			);
			?>

			<?php if ( get_theme_mod( 'search_toggle' ) == '1' ) : ?>
			<div class="menu-search">
				<i class="fas fa-search"></i> <span class="item-text"></span>
				<div class="menu-search-form-wrapper">
					<?php
					if ( get_theme_mod( 'search_toggle' ) == '1' ) :
						if ( ! defined( 'YITH_WCAS' ) ) :
							echo get_search_form();
						else :
							echo do_shortcode( '[yith_woocommerce_ajax_search]' );
						endif;
					endif;
					?>
				</div>
			</div>
			<?php endif; ?>

			<?php
			if ( class_exists( 'WooCommerce' ) ) :
				if ( get_theme_mod( 'general_menu_my_account_toggle' ) == '1' ) :
					?>
					<div class="menu-my-account">
						<?php echo '<a href="' . get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) . '"' . ' title="' . __( 'My account', 'klasse-theme' ) . '"><i class="fas fa-user-alt"></i></a>'; ?>
					</div>
					<?php
				endif;

				if ( defined( 'YITH_WCWL' ) && get_theme_mod( 'general_menu_wishlist_toggle' ) == '1' ) :
					?>
					<div class="menu-wishlist">
						<?php
						$wc_count = yith_wcwl_count_products();
						echo '<a href="' . esc_url( YITH_WCWL()->get_wishlist_url() ) . '"' . ' title="' . esc_attr__( 'Wishlist', 'klasse-theme' ) . '"><i class="fas fa-heart"></i><span class="menu-wishlist-count">' . intval( $wc_count ) . '</span></a>';
						?>
					</div>
				<?php endif; ?>

				<?php
				if ( get_theme_mod( 'general_menu_cart_toggle' ) == '1' ) :
					$items = sizeof( WC()->cart->get_cart() );
					?>
					<div class="menu-cart">
						<div class="menu-cart-icon">
							<i class="fas fa-shopping-cart"></i>
							<div class="menu-cart-count"><span class="cart-count"><?php echo WC()->cart->get_cart_contents_count(); ?></span></div>
							<a href="<?php echo wc_get_cart_url(); ?>" class="cart-link"><span class="hidden"><?php echo __( 'View cart', 'klasse-theme' ); ?></span></a>
						</div>

						<?php do_action( 'kls_mini_cart_v1' ); ?>
					</div>
					<?php
				endif;
			endif;

			if ( get_theme_mod( 'navigation_rating_toggle' ) == 1 ) :
				kls_star_rating();
			endif;
			?>

		<!-- </div> -->

		<?php if ( get_theme_mod( 'main_navigation_button_primary_toggle' ) == 1 || get_theme_mod( 'main_navigation_button_secundary_toggle' ) == 1 ) : ?>
			<div class="menu-buttons-container">
				<?php if ( get_theme_mod( 'main_navigation_button_primary_toggle' ) == 1 ) : ?>
					<a href="<?php echo kls_translate_theme_mod( 'main_navigation_button_primary_link', 'Primaire knop link', 'nl' ); ?>" <?php echo ( get_theme_mod( 'main_navigation_button_primary_link_blank' ) == 1 ? 'target="_blank"' : '' ); ?> class="theme-button theme-button-secundary"><?php echo kls_translate_theme_mod( 'main_navigation_button_primary_text', 'Primaire knop tekst', 'nl' ); ?></a>
				<?php endif; ?>
				
				<?php if ( get_theme_mod( 'main_navigation_button_secundary_toggle' ) == 1 ) : ?>
					<a href="<?php echo ( get_theme_mod( 'main_navigation_button_secundary_link_af' ) == 1 ? get_option( 'kls_anytime_registration' ) : kls_translate_theme_mod( 'main_navigation_button_secundary_link', 'Secundaire knop link', 'nl' ) ); ?>" <?php echo ( get_theme_mod( 'main_navigation_button_secundary_link_blank' ) == 1 ? 'target="_blank"' : '' ); ?> class="theme-button theme-button-primary"><?php echo kls_translate_theme_mod( 'main_navigation_button_secundary_text', 'Secundaire knop tekst', 'nl' ); ?></a>
				<?php endif; ?>
			</div>
		<?php endif; ?>
	</div>
</nav>

