jQuery(document).ready(function ($) {
	/**
	 * Check tab for filled in items.
	 * 
	 * @param {string} $tab - .parent() into the tab's item.
	 * 
	 * @since 0.1.75
	 * @author Joeri van der Stek <joeri @klassebv.nl>
	 */
	function checkTabFieldValues($tab) {
		var $errorMessages = $tab.find('.error-message, .required-field-error-message');

		// Check if any checkbox is checked or any input is filled in.
		var hasCheckedCheckbox = $tab.find('.pewc-item:not(.pewc-hidden-field) input[type="checkbox"]:checked').length > 0;

		// Check for selected options inside select element.
		if ($tab.find('.pewc-item-select:not(.pewc-hidden-field)').length > 0) {
			var hasSelectedSelect = $tab.find('.pewc-item-select:not(.pewc-hidden-field)').attr('data-field-value').length > 0;
		}

		// Check for standard variation checkboxes.
		if ($tab.find('.variable-item').length > 0) {
			var hasVariableCheckbox = $tab.find('.variable-item[aria-checked="true"]').length > 0;
		}

		// Check for filled inputs or textarea's.
		var hasFilledInput = $tab.find('.pewc-item:not(.pewc-hidden-field) input[type="text"], .pewc-item:not(.pewc-hidden-field) input[type="number"], .pewc-item:not(.pewc-hidden-field) input[type="email"], .pewc-item:not(.pewc-hidden-field) textarea').filter(function () {
			return $.trim($(this).val()) !== '';
		}).length > 0;

		// Check for filled upload field.
		var uploadActive = $tab.find('.pewc-item.pewc-group-upload:not(.pewc-hidden-field)');
		var hasFilledUpload = uploadActive.length > 0 ? uploadActive.attr('data-field-value') > 0 : false;

		// Check if all required fields are filled in
		var hasRequiredField = $tab.find('.required-field:not(.pewc-hidden-field):not(.pewc-group-upload)').filter(function () {
			var fieldType = $(this).data('field-type');
			if (fieldType === 'checkbox') {
				return $(this).find('input[type="checkbox"]:checked').length === 0;
			} else if (fieldType === 'radio') {
				return $(this).find('input[type="radio"]:checked').length === 0;
			} else {
				return $.trim($(this).find('input[type="text"], input[type="number"], input[type="email"], textarea').val()) === '';
			}
		}).length === 0;

		updateTotals();

		if (!hasRequiredField || !hasCheckedCheckbox && !hasSelectedSelect && !hasFilledInput && !hasFilledUpload && !hasVariableCheckbox) {
			$errorMessages.show();
			$tab.addClass('error-step').removeClass('done');

			return false;
		} else {
			$errorMessages.hide();
			$tab.removeClass('active').removeClass('error-step').addClass('done');

			return true;
		}
	}

	/**
	 * Add the accordion variation functionality.
	 * 
	 * @since 0.1.75
	 * @author Joeri van der Stek <joeri @klassebv.nl>
	 */
	function klsAccordionVariationToggler() {
		var $variations = $('.variations');
		var $variationsChildren = $variations.find('tbody>tr');
		var $firstVariations = $variationsChildren.filter(':first-child');
		var $remainingVariations = $variationsChildren.not(':first-child');
		var $variableItems = $variations.find('.variable-item');

		var $pewcGroupWrap = $('.pewc-product-extra-groups-wrap .pewc-group-wrap');
		var $firstPewcGroupWrap = $pewcGroupWrap.filter('.first-group');
		var $remainingPewcGroupWrap = $pewcGroupWrap.not('.first-group');

		var $groupHeadings = $('.product-type-variable .variations_form .variations>tbody>tr>.label, .pewc-group-wrap .pewc-group-heading-wrapper');
		var $groupHeadingsCount = $('.product-type-variable .variations_form .variations>tbody>tr>.label, .pewc-group-wrap .pewc-group-heading-wrapper').length;

		var $variationForm = $('.product-type-variable .variations_form .variations tr>td.value');

		var $groupContentWrapper = $('.pewc-group-wrap .pewc-group-content-wrapper');

		var $menuHeight = 150; // Todo, this should be based on the header height.

		$i = 0;
		$groupHeadings.each(function () {
			$i++;
			$(this).parent().attr('data-step-count', $i);
		});

		if ($firstVariations.length) {
			$remainingVariations.addClass('hidden');
			$pewcGroupWrap.addClass('hidden');
			$firstVariations.addClass('active');
		} else {
			$remainingPewcGroupWrap.addClass('hidden');
			$firstPewcGroupWrap.addClass('active');
		}

		// Standard variations toggler.
		$variableItems.each(function () {
			$(this).on('click', function () {
				var $this = $(this);
				var $parent = $this.parent().parent().parent();

				$parent.removeClass('active').removeClass('not-done').addClass('done');
				$parent.next().removeClass('hidden').addClass('active');

				if ($parent.next().find('li[aria-checked="true"]').length > 0) {
					$parent.next().addClass('done');
				} else {
					$parent.next().removeClass('done');
				}

				if ($parent.is(':last-child')) {
					$parent.parent().parent().next().find('.first-group.pewc-group-wrap').removeClass('hidden').addClass('active');
				}

				$([document.documentElement, document.body]).animate({
					scrollTop: $this.parent().offset().top - $menuHeight
				}, 200);
			});
		});

		// Toggle the clicked tab.
		$groupHeadings.on('click', function () {
			var $this = $(this);
			var $parent = $this.parent();

			checkTabFieldValues($parent);

			if ($parent.data('step-count') == $groupHeadingsCount) {
				checkAllTabFieldValues(false);
			}

			$('.variations_form, .pewc-groups-standard').find('.active').removeClass('active');

			$parent.addClass('active');

			$([document.documentElement, document.body]).animate({
				scrollTop: $this.offset().top - $menuHeight
			}, 200);
		});

		// Add theme button and error message to all the tabs.
		$variationForm.append('<div class="kls-variation-button-container"><p class="theme-button theme-button-secundary">' + variation_vars.next + '</p></div>')
			.append('<div class="error-message" style="display:none;">' + variation_vars.selection_error + '</div>');
		$groupContentWrapper.append('<div class="kls-variation-button-container"><p class="theme-button theme-button-secundary">' + variation_vars.next + '</p></div>')
			.append('<div class="error-message" style="display:none;">' + variation_vars.selection_error + '</div>');
		$('.single_add_to_cart_button').parent().append('<div class="error-message" style="display:none;">' + variation_vars.add_to_cart_error + '</div>');

		$('.kls-variation-button-container .theme-button').on('click', function () {
			var $this = $(this);
			var $parent = $this.parent().parent().parent();
			var $next = $parent.nextAll('.pewc-group-wrap, .pewc-total-field-wrapper').first();

			var $checkedFields = checkTabFieldValues($parent);

			if (!$checkedFields) {
				$([document.documentElement, document.body]).animate({
					scrollTop: $parent.offset().top - $menuHeight
				}, 200);
			} else {
				$next.removeClass('hidden').addClass('active');

				$([document.documentElement, document.body]).animate({
					scrollTop: $next.offset().top - $menuHeight
				}, 200);
			}

			if ($parent.data('step-count') == $groupHeadingsCount) {
				checkAllTabFieldValues(false);
			}
		});

		// On click on the image select the item
		$(document).on('click', '.pewc-item-checkbox', function () {
			var $this = $(this);
			var $checkbox = $this.find('input');

			$this.parent().find('.pewc-active-field').removeClass('pewc-active-field');

			if ($checkbox.is(':checked')) {
				$checkbox.prop('checked', false);
			} else {
				$checkbox.prop('checked', true);
			}

			updateTotals();
		});

		// On add to cart button click.
		$(document).on('click', '.single_add_to_cart_button', function (e) {
			if ($pewcGroupWrap.length > 0) {
				var $checkFields = checkAllTabFieldValues(true);

				if ($checkFields == false) {
					e.preventDefault();
				}
			}
		});
	}

	/**
	 * Update all the PEWC triggers.
	 * 
	 * @since 0.1.75
	 * @author Joeri van der Stek <joeri @klassebv.nl>
	 */
	function updateTotals() {
		$('body').trigger('pewc_force_update_total_js');
		$('body').trigger('pewc_trigger_calculations');
		$('body').trigger('pewc_check_conditions');
	}

	klsAccordionVariationToggler();

	/**
	 * Check all the tabs for not filled fields.
	 * 
	 * @since 0.1.75
	 * @author Joeri van der Stek <joeri @klassebv.nl>
	 */
	function checkAllTabFieldValues($submit) {
		var $allFieldsValid = true;

		$('.pewc-product-extra-groups-wrap .pewc-group-wrap').each(function () {
			var $this = $(this);
			var $checkedFields = checkTabFieldValues($this);

			if (!$checkedFields) {
				$allFieldsValid = false;
			}
		});

		var $this = $('.single_add_to_cart_button');
		var $parent = $this.parent();

		if ($allFieldsValid) {
			$parent.find('.error-message').hide();

			if ($submit == true) {
				return true;
			}
		} else {
			$parent.find('.error-message').show();

			$([document.documentElement, document.body]).animate({
				scrollTop: $('.tabs-item.summary').offset().top - 150 // Todo, this should be a variable from the init.
			}, 200);

			return false;
		}
	}

	// On quickview button click.
	$(document).on('click', '.yith-wcqv-button', function () {
		$(document).one('ajaxComplete', function (event, xhr, settings) {
			if (settings.data.indexOf('yith_load_product_quick_view') >= 0) {
				klsAccordionVariationToggler();
			}
		});
	});
});