<?php
/**
 * Klasse breadcrumb
 *
 * @since 0.0.14
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_breadcrumb() {     ?>
	<div class="theme-row">
		<div class="theme-col theme-col-12">
			<div class="breadcrumb">
			<?php
			if ( function_exists( 'woocommerce_breadcrumb' ) ) {
				$args = array(
					'delimiter' => ' / ',
				);
				woocommerce_breadcrumb( $args );
			} elseif ( function_exists( 'yoast_breadcrumb' ) ) {
				yoast_breadcrumb();
			}
			?>
			</div>
		</div>
	</div>
	<?php
}
add_action( 'kls_breadcrumb', 'kls_breadcrumb' );

/**
 * Add header to body_open class
 *
 * @since 0.0.42
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_header() {
	if ( get_theme_mod( 'navigation_toggle' ) == 1 ) :
		if ( ! is_page_template( 'empty-page.php' ) ) :
			if ( get_theme_mod( 'top_navigation_toggle' ) == 1 || get_theme_mod( 'main_navigation_toggle' ) == 1 ) :
				?>
				<header>
					<?php
					if ( get_theme_mod( 'top_navigation_toggle' ) == 1 ) :
						echo get_template_part( '/template-parts/navigation/top/top', $GLOBALS['kls_top_navigation_version'] );
					endif;

					if ( get_theme_mod( 'main_navigation_toggle' ) == 1 ) :
						echo get_template_part( '/template-parts/navigation/main/main', $GLOBALS['kls_main_navigation_version'] );
					endif;

					if ( get_theme_mod( 'kls_sidebar_navigation_toggle' ) == 1 ) :
						if ( (get_theme_mod( 'kls_sidebar_only_loggedin' ) == 1 && is_user_logged_in() ) || get_theme_mod( 'kls_sidebar_only_loggedin' ) == 0 ) :
							echo get_template_part( '/template-parts/navigation/sidebar/sidebar', $GLOBALS['kls_sidebar_navigation_version'] );
						endif;
					endif;
					?>
				</header>
				
				<?php do_action( 'kls_mini_cart_v2' ); ?>

				<?php
				// Add navigation.
				echo get_template_part( '/template-parts/navigation/mobile/mobile', $GLOBALS['kls_mobile_navigation_version'] );

				// Add menu.
				echo get_template_part( '/template-parts/navigation/mobile-menu/mobile-navigation', $GLOBALS['kls_mobile_menu_version'] );
			endif;
		endif;
	endif;
}
add_action( 'wp_body_open', 'kls_header' );

/**
 * Add footer to wp_footer
 *
 * @since 0.0.42
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_footer() {
	if ( get_theme_mod( 'footer_toggle' ) == '1' ) :
		if ( ! is_page_template( 'empty-page.php' ) ) :
			?>
			<footer class="widget-footer">
				<?php if ( get_theme_mod( 'main_footer_toggle' ) == '1' ) : ?>
					<?php
					if ( get_theme_mod( 'footer_creation_type' ) == 'default' ) :
						echo get_template_part( '/template-parts/footer/main/main', $GLOBALS['kls_footer_version'] );
					elseif ( get_theme_mod( 'footer_creation_type' ) == 'widgets' ) :
						?>
						<div class="footer-top-wrapper theme-container">
							<div class="footer-item-wrapper footer-columns-4 theme-row">
								<div class="footer-item-col theme-col theme-col-3"><?php dynamic_sidebar( 'footer-1' ); ?></div>
								<div class="footer-item-col theme-col theme-col-3"><?php dynamic_sidebar( 'footer-2' ); ?></div>
								<div class="footer-item-col theme-col theme-col-3"><?php dynamic_sidebar( 'footer-3' ); ?></div>
								<div class="footer-item-col theme-col theme-col-3"><?php dynamic_sidebar( 'footer-4' ); ?></div>
							</div>
						</div>
					<?php endif; ?>
				<?php endif; ?>
				
				<?php
				if ( get_theme_mod( 'bottom_footer_toggle' ) == '1' ) :
					echo get_template_part( '/template-parts/footer/bottom/bottom', $GLOBALS['kls_footer_version'] );
				endif;
				?>
			</footer>
			<?php
		endif;
	endif;
}
add_action( 'wp_footer', 'kls_footer' );

/**
 * Add css class to highlighted primary menu button
 *
 * @since 0.0.64
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_menu_primary_button( $classes, $menu_item ) {
	$show_as_button = get_post_meta( $menu_item->ID, '_kls-primary-button', true );
	if ( $show_as_button ) {
		$classes[] = 'menu-button menu-button-primary';
	}
	return $classes;
}
add_filter( 'nav_menu_css_class', 'kls_menu_primary_button', 10, 2 );

/**
 * Add css class to highlighted secundary menu button
 *
 * @since 0.0.64
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_menu_secundary_button( $classes, $menu_item ) {
	$show_as_button = get_post_meta( $menu_item->ID, '_kls-secundary-button', true );
	if ( $show_as_button ) {
		$classes[] = 'menu-button menu-button-secundary';
	}
	return $classes;
}
add_filter( 'nav_menu_css_class', 'kls_menu_secundary_button', 10, 2 );

/**
 * Add css class to highlighted secundary menu button
 *
 * @since 0.1.58
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_menu_hot_label( $classes, $menu_item ) {
	$show_as_button = get_post_meta( $menu_item->ID, '_kls-show-hot-label', true );
	if ( $show_as_button ) {
		$classes[] = 'menu-hot-label';
	}
	return $classes;
}
add_filter( 'nav_menu_css_class', 'kls_menu_hot_label', 10, 2 );

/**
 * Add custom image sizes
 *
 * @since 0.0.66
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
add_image_size( 'category-slider-image', 500, 300, true );
add_image_size( 'category-block-layout-image', 800, 800, true );

/**
 * Fix the password protected styling
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.37
 */
function fb_the_password_form() {
	global $post;

	$label  = 'pwbox-' . ( empty( $post->ID ) ? rand() : $post->ID );
	$output = '
    <div class="theme-container theme-container-pwbox">
        <div class="theme-row" style="margin: 20px auto !important;">
            <div class="theme-col theme-col-12">
                <form action="' . get_option( 'siteurl' ) . '/wp-login.php?action=postpass" method="post">
                <p>' . __( 'Please fill in the password below:', 'klasse-theme' ) . '</p>
                <p class="nf-field-element"><label for="' . $label . '">' . __( 'Password' ) . ' <input name="post_password" id="' . $label . '" type="password" size="20" /></label></p>
                <p><input type="submit" name="Submit" class="theme-button theme-button-primary" value="' . esc_attr__( 'Submit' ) . '" /></p>
                </form>
            </div>
        </div>
    </div>';

	return $output;
}
add_filter( 'the_password_form', 'fb_the_password_form' );

/**
 * Allow more mime/filetypes
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.45
 */
function kls_correct_filetypes( $data, $file, $filename, $mimes, $real_mime ) {
	if ( ! empty( $data['ext'] ) && ! empty( $data['type'] ) ) {
		return $data;
	}

	$wp_file_type = wp_check_filetype( $filename, $mimes );

	if ( 'ttf' === $wp_file_type['ext'] ) { // Ttf
		$data['ext']  = 'ttf';
		$data['type'] = 'font/ttf';
	}

	if ( 'otf' === $wp_file_type['ext'] ) { // Otf
		$data['ext']  = 'otf';
		$data['type'] = 'font/otf';
	}

	if ( 'eot' === $wp_file_type['ext'] ) { // EOT
		$data['ext']  = 'eot';
		$data['type'] = 'font/eot';
	}

	if ( 'svg' === $wp_file_type['ext'] ) { // SVG
		$data['ext']  = 'svg';
		$data['type'] = 'image/svg+xml';
	}

	if ( 'woff' === $wp_file_type['ext'] ) { // Woff
		$data['ext']  = 'woff';
		$data['type'] = 'font/woff';
	}

	if ( 'woff2' === $wp_file_type['ext'] ) { // Woff2
		$data['ext']  = 'woff2';
		$data['type'] = 'font/woff2';
	}

	if ( 'webp' === $wp_file_type['ext'] ) { // Webp
		$data['ext']  = 'webp';
		$data['type'] = 'image/webp';
	}

	return $data;
}
add_filter( 'wp_check_filetype_and_ext', 'kls_correct_filetypes', 10, 5 );

function kls_allow_custom_mime_types( $mimes ) {
	// New allowed mime types.
	$mimes['ttf']   = 'font/ttf';
	$mimes['otf']   = 'font/otf';
	$mimes['eot']   = 'font/eot';
	$mimes['svg']   = 'image/svg+xml';
	$mimes['webp']  = 'image/webp';
	$mimes['woff']  = 'font/woff';
	$mimes['woff2'] = 'font/woff2';

	return $mimes;
}
add_filter( 'upload_mimes', 'kls_allow_custom_mime_types' );

/**
 * Remove and enqueue a new Divi Stylesheet.
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.61
 */
if ( class_exists( 'ET_Builder_Plugin' ) ) {
	function kls_remove_inline_style( $handler ) {
		wp_style_is( $handler, 'enqueued' )
			&& wp_style_add_data( $handler, 'after', '' );
	}

	function kls_divi_style_replace() {
		// Remove previous inline style.
		kls_remove_inline_style( 'divi-builder-style-inline' );

		// Build the new styling.
		$stylesheet                   = ET_BUILDER_PLUGIN_DIR . '/css/style.min.css';
		$stylesheet                   = str_replace( '..', '', $stylesheet );
		$stylesheet_contents          = file_get_contents( $stylesheet );
		$url_match                    = '/url\(\.\.\//i';
		$stylesheet_contents_replaced = preg_replace( $url_match, 'url(' . ET_BUILDER_PLUGIN_URI . '/', $stylesheet_contents );
		$stylesheet_contents_replaced = preg_replace( '/\.et_pb_module/', '.et_pb_module:not(.override_styling)', $stylesheet_contents_replaced );
		$stylesheet_contents_replaced = preg_replace( '/#et-boc \.et-l \.hentry.*?}/', '', $stylesheet_contents_replaced );

		if ( false !== $stylesheet_contents ) {
			wp_register_style( 'divi-builder-style-inline', false, array(), $GLOBALS['theme_style_version'] );
			wp_enqueue_style( 'divi-builder-style-inline' );
			wp_add_inline_style( 'divi-builder-style-inline', $stylesheet_contents_replaced );
		}
	}
	add_action( 'wp_print_styles', 'kls_divi_style_replace' );
}
