<?php

/**
 * Set the Woocommerce layout
 *
 * @since 0.0.12
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */

add_action( 'wp', 'kls_product_layout' );
function kls_product_layout() {
	// Remove product tab title
	add_filter( 'woocommerce_product_description_heading', '__return_null' );
	add_filter( 'woocommerce_product_additional_information_heading', '__return_null' );
	
	$priority = has_action('woocommerce_single_product_summary', 'woocommerce_output_product_data_tabs');
	remove_action( 'woocommerce_single_product_summary', 'woocommerce_output_product_data_tabs', $priority );
	add_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs' );

	// Move related products
	remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);
	add_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 99);

	// Remove the sidebar from the product page
	if (is_product()) {
		remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );
	}
}

 // Remove additional information tab
add_filter( 'woocommerce_product_tabs', 'kls_remove_additional_information_tab', 100, 1 );
function kls_remove_additional_information_tab( $tabs ) {
    unset($tabs['additional_information']);

    return $tabs;
}


// Add "additional information" after add to cart
add_action( 'woocommerce_after_single_product_summary', 'kls_additional_info_under_add_to_cart', 35 );
function kls_additional_info_under_add_to_cart() {
    global $product;

    if ( $product && ( $product->has_attributes() || apply_filters( 'wc_product_enable_dimensions_display', $product->has_weight() || $product->has_dimensions() ) ) ) {
		echo '<div class="specifications-tab"><h2><strong>Specificaties</strong></h2>';
        wc_display_product_attributes( $product );
		echo '</div>';
    }
}

/**
 * Add view cart button
 *
 * @since 0.0.12
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
add_action( 'woocommerce_after_add_to_cart_button', 'kls_view_cart_button', 35 );
function kls_view_cart_button() {
	echo '<a href="' . wc_get_cart_url() . '" tabindex="1" class="button wc-forward theme-button theme-button-secundary">' . __( 'View cart', 'klasse-theme' ) . '</a>';
}

/**
 * Change add-to-cart button text
 *
 * @since 0.0.36
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
add_filter( 'woocommerce_product_single_add_to_cart_text', 'kls_change_add_to_cart_text' );
add_filter( 'woocommerce_product_add_to_cart_text', 'kls_change_add_to_cart_text' );
function kls_change_add_to_cart_text() {
	return __( 'Add to cart', 'klasse-theme' );
}

/**
 * Show usp data
 *
 * @since 0.0.12
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_show_product_usps() {
	global $post;
	if ( get_post_meta( $post->ID, 'usp_1', true ) || get_post_meta( $post->ID, 'usp_2', true ) || get_post_meta( $post->ID, 'usp_3', true ) || get_post_meta( $post->ID, 'usp_4', true ) || get_post_meta( $post->ID, 'usp_5', true ) || get_post_meta( $post->ID, 'usp_6', true ) ) {
		if ( get_post_meta( $post->ID, 'usp_1', true ) ) {
			$usps[] = get_post_meta( $post->ID, 'usp_1', true );
		}
		if ( get_post_meta( $post->ID, 'usp_2', true ) ) {
			$usps[] = get_post_meta( $post->ID, 'usp_2', true );
		}
		if ( get_post_meta( $post->ID, 'usp_3', true ) ) {
			$usps[] = get_post_meta( $post->ID, 'usp_3', true );
		}
		if ( get_post_meta( $post->ID, 'usp_4', true ) ) {
			$usps[] = get_post_meta( $post->ID, 'usp_4', true );
		}
		if ( get_post_meta( $post->ID, 'usp_5', true ) ) {
			$usps[] = get_post_meta( $post->ID, 'usp_5', true );
		}
		if ( get_post_meta( $post->ID, 'usp_6', true ) ) {
			$usps[] = get_post_meta( $post->ID, 'usp_6', true );
		}
	} elseif ( get_option( 'kls_customer_usp_1' ) || get_option( 'kls_customer_usp_2' ) || get_option( 'kls_customer_usp_3' ) || get_option( 'kls_customer_usp_4' ) ) {
		if ( get_theme_mod( 'product_usps_toggle' ) == 1 ) {
			if ( get_option( 'kls_customer_usp_1' ) ) {
				$usps[] = get_option( 'kls_customer_usp_1' );
			}
			if ( get_option( 'kls_customer_usp_2' ) ) {
				$usps[] = get_option( 'kls_customer_usp_2' );
			}
			if ( get_option( 'kls_customer_usp_3' ) ) {
				$usps[] = get_option( 'kls_customer_usp_3' );
			}
			if ( get_option( 'kls_customer_usp_4' ) ) {
				$usps[] = get_option( 'kls_customer_usp_4' );
			}
		}
	}

	// Show usp's if usps is defined
	if ( isset( $usps ) ) {
		echo '<div class="product-usp-wrapper"><ul>';
		foreach ( $usps as $usp ) {
			echo '<li>' . $usp . '</li>';
		}
		echo '</ul></div>';
	}
}
add_action( 'woocommerce_after_add_to_cart_form', 'kls_show_product_usps', 55 );
add_action( 'yith_gift_cards_template_after_add_to_cart_button', 'kls_show_product_usps', 55 );
