<?php

/**
 * Set the Woocommerce layout
 *
 * @since 0.0.12
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_product_layout() {
	 // Product tabs.
	remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs' );
	add_action( 'kls_product_tabs', 'woocommerce_output_product_data_tabs', 100 );
	// Remove product tab title.
	add_filter( 'woocommerce_product_description_heading', '__return_null' );
	add_filter( 'woocommerce_product_additional_information_heading', '__return_null' );
	// Move the add_to_cart form.
	remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
	add_action( 'kls_add_to_cart_form_tab', 'woocommerce_template_single_add_to_cart', 30 );
	// add_action( 'yith_wcqv_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
	// Move the short description form.
	remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20 );
	add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', ( get_theme_mod( 'kls_product_v6_description_location', 100 ) == null ? 100 : get_theme_mod( 'kls_product_v6_description_location' ) ) );
	// Move the price.
	remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
	add_action( 'kls_add_to_cart_form_tab', 'woocommerce_template_single_price', 10 );
	// Remove the sidebar from the product page.
	if ( is_product() ) {
		remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );
	}
}
add_action( 'wp', 'kls_product_layout' );

/**
 * Show usp data
 *
 * @since 0.0.12
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_show_product_usps() {
	global $post;
	if ( get_post_meta( $post->ID, 'usp_1', true ) || get_post_meta( $post->ID, 'usp_2', true ) || get_post_meta( $post->ID, 'usp_3', true ) || get_post_meta( $post->ID, 'usp_4', true ) ) {
		if ( get_post_meta( $post->ID, 'usp_1', true ) ) {
			$usps[] = get_post_meta( $post->ID, 'usp_1', true );
		}
		if ( get_post_meta( $post->ID, 'usp_2', true ) ) {
			$usps[] = get_post_meta( $post->ID, 'usp_2', true );
		}
		if ( get_post_meta( $post->ID, 'usp_3', true ) ) {
			$usps[] = get_post_meta( $post->ID, 'usp_3', true );
		}
		if ( get_post_meta( $post->ID, 'usp_4', true ) ) {
			$usps[] = get_post_meta( $post->ID, 'usp_4', true );
		}
	} elseif ( get_option( 'kls_customer_usp_1' ) || get_option( 'kls_customer_usp_2' ) || get_option( 'kls_customer_usp_3' ) || get_option( 'kls_customer_usp_4' ) ) {
		if ( 1 == get_theme_mod( 'product_usps_toggle' ) ) {
			if ( get_option( 'kls_customer_usp_1' ) ) {
				$usps[] = get_option( 'kls_customer_usp_1' );
			}
			if ( get_option( 'kls_customer_usp_2' ) ) {
				$usps[] = get_option( 'kls_customer_usp_2' );
			}
			if ( get_option( 'kls_customer_usp_3' ) ) {
				$usps[] = get_option( 'kls_customer_usp_3' );
			}
			if ( get_option( 'kls_customer_usp_4' ) ) {
				$usps[] = get_option( 'kls_customer_usp_4' );
			}
		}
	}

	// Show usp's if usps is defined.
	if ( isset( $usps ) ) {
		echo '<div class="product-usp-wrapper"><ul>';
		foreach ( $usps as $usp ) {
			echo '<li>' . $usp . '</li>';
		}
		echo '</ul></div>';
	}
}
add_action( 'woocommerce_single_product_summary', 'kls_show_product_usps', ( get_theme_mod( 'kls_product_v6_usp_location', 20 ) == null ? 20 : get_theme_mod( 'kls_product_v6_usp_location' ) ) );
add_action( 'yith_gift_cards_template_after_add_to_cart_button', 'kls_show_product_usps', ( get_theme_mod( 'kls_product_v6_usp_location', 20 ) == null ? 20 : get_theme_mod( 'kls_product_v6_usp_location' ) ) );

/**
 * Add view cart button
 *
 * @since 0.0.12
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_view_cart_button() {
	echo '<a href="' . wc_get_cart_url() . '" tabindex="1" class="button wc-forward theme-button theme-button-secundary">' . __( 'View cart', 'klasse-theme' ) . '</a>';
}
add_action( 'woocommerce_after_add_to_cart_button', 'kls_view_cart_button', 35 );

/**
 * Change add-to-cart button text
 *
 * @since 0.0.36
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_change_add_to_cart_text() {
	return __( 'Add to cart', 'klasse-theme' );
}
add_filter( 'woocommerce_product_single_add_to_cart_text', 'kls_change_add_to_cart_text' );
add_filter( 'woocommerce_product_add_to_cart_text', 'kls_change_add_to_cart_text' );

/**
 * Add start order button
 *
 * @since 0.1.56
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_start_order_button() {
	 global $product;

	$product_purchasable = $product->is_purchasable();
	if ( isset( $product_purchasable ) && $product_purchasable > 0 ) {
		echo '<a href="#order" tabindex="1" class="button wc-forward theme-button theme-button-primary theme-button-full-width theme-order-button">' . esc_html__( 'Start your order', 'klasse-theme' ) . '</a>';
	}
}
add_action( 'woocommerce_single_product_summary', 'kls_start_order_button', ( get_theme_mod( 'kls_product_v6_button_location', 50 ) == null ? 50 : get_theme_mod( 'kls_product_v6_button_location' ) ) );

/**
 * Add product description title
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.57
 */
function kls_product_summary_title() {
	global $post;
	if ( ! empty( $post->post_excerpt ) && get_theme_mod( 'kls_product_v6_description_title_toggle', 1 ) == 1 ) {
		echo '<h3>' . esc_html__( 'Product description', 'klasse-theme' ) . '</h3>';
	}
}
add_action( 'woocommerce_single_product_summary', 'kls_product_summary_title', 52 );

/**
 * Remove the additional information tab
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.57
 */
if ( get_theme_mod( 'kls_product_specifications_in_description' ) == 1 ) {
	function kls_remove_additional_information_tab( $tabs ) {
		unset( $tabs['additional_information'] );

		return $tabs;
	}
	add_filter( 'woocommerce_product_tabs', 'kls_remove_additional_information_tab', 100, 1 );

	/**
	 * Add the additional information to the description tab
	 *
	 * @author Joeri van der Stek <joeri@klassebv.nl>
	 *
	 * @since 0.1.57
	 */
	function kls_additional_info_under_add_to_cart() {
		global $product;

		if ( $product && ( $product->has_attributes() || apply_filters( 'wc_product_enable_dimensions_display', $product->has_weight() || $product->has_dimensions() ) ) ) {
			wc_display_product_attributes( $product );
		}
	}
	add_action( 'kls_long_description', 'kls_additional_info_under_add_to_cart', 35 );
}
