<?php

/**
 * Set the checkout flow layout
 *
 * @since 0.1.62
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
add_action( 'wp', 'kls_checkout_flow_layout' );
function kls_checkout_flow_layout() {
	/* YITH Gift Cards - hide the section for gift card code submission on cart page */
	if ( ! function_exists( 'yith_ywgc_hide' ) ) {
		function yith_ywgc_hide( $show_field ) {
			if ( is_cart() || is_checkout() ) {
				$show_field = false;
			}

			return $show_field;
		}
	}
	add_filter( 'yith_gift_cards_show_field', 'yith_ywgc_hide' );
	// Standard create account checked on checkout.
	add_filter( 'woocommerce_create_account_default_checked', '__return_true' );
}


/**
 * Update cart on quantity change
 *
 * @since 0.0.28
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function ajax_qty_cart() {
	// Set item key as the hash found in input.qty's name.
	$cart_item_key = $_POST['hash'];
	// Get the array of values owned by the product we're updating.
	$threeball_product_values = WC()->cart->get_cart_item( $cart_item_key );
	// Get the quantity of the item in the cart.
	$threeball_product_quantity = apply_filters( 'woocommerce_stock_amount_cart_item', apply_filters( 'woocommerce_stock_amount', preg_replace( '/[^0-9\.]/', '', filter_var( $_POST['quantity'], FILTER_SANITIZE_NUMBER_INT ) ) ), $cart_item_key );
	// Update cart validation.
	$passed_validation = apply_filters( 'woocommerce_update_cart_validation', true, $cart_item_key, $threeball_product_values, $threeball_product_quantity );
	// Update the quantity of the item in the cart.
	if ( $passed_validation ) {
		WC()->cart->set_quantity( $cart_item_key, $threeball_product_quantity, true );
	}

	// Refresh the page.
	echo do_shortcode( '[woocommerce_cart]' );
	die();
}
add_action( 'wp_ajax_qty_cart', 'ajax_qty_cart' );
add_action( 'wp_ajax_nopriv_qty_cart', 'ajax_qty_cart' );
