<?php

// [Dev] Todo, split this up in multiple files.

/**
 * Set the standard Woocommerce layout
 *
 * @since 0.0.12
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
add_action('wp', 'kls_standard_woocommerce_layout');
function kls_standard_woocommerce_layout()
{
	// Cross sells cart page.
	remove_action('woocommerce_cart_collaterals', 'woocommerce_cross_sell_display');
	add_action('woocommerce_after_cart_table', 'woocommerce_cross_sell_display');
}

/**
 * Disable standard Woocommerce styling
 *
 * @since 0.0.12
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if (get_theme_mod('general_disable_standard_woocommerce_styling_toggle') == '1') {
	add_filter('woocommerce_enqueue_styles', 'kls_woocommerce_dequeue_styles');

	function kls_woocommerce_dequeue_styles($enqueue_styles)
	{
		unset($enqueue_styles['woocommerce-general']);
		unset($enqueue_styles['woocommerce-layout']);
		unset($enqueue_styles['woocommerce-smallscreen']);
		return $enqueue_styles;
	}
}

/**
 * Update cart counts on add to cart
 *
 * @since 0.0.12
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
add_filter('woocommerce_add_to_cart_fragments', 'kls_update_cart_fragments', 10, 1);

function kls_update_cart_fragments($fragments)
{
	$fragments['span.cart-count'] = '<span class="cart-count">' . WC()->cart->get_cart_contents_count() . '</span>';
	return $fragments;
}

/**
 * Remove select2 dropdown
 *
 * @since 0.0.12
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_dequeue_plugin_styles()
{
	if (class_exists('woocommerce')) {
		wp_dequeue_style('select2');
		wp_deregister_style('select2');

		wp_dequeue_script('selectWoo');
		wp_deregister_script('selectWoo');

		wp_dequeue_style('wc-block-vendors-style');
		wp_dequeue_style('wc-block-style');

		wp_dequeue_style('wp-block-library');
		wp_dequeue_style('wp-block-library-theme');
	}
	wp_deregister_style('font-awesome');
	wp_dequeue_style('font-awesome');
	wp_deregister_style('yith-wcwl-font-awesome');
	wp_dequeue_style('yith-wcwl-font-awesome');
	wp_deregister_style('yith-quick-view');
	wp_dequeue_style('yith-quick-view');
}
add_action('wp_enqueue_scripts', 'kls_dequeue_plugin_styles', 100);

/**
 * Add body class if product is in cart
 *
 * @since 0.0.12
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_check_if_product_in_cart($product_id)
{
	if (!WC()->cart->is_empty()) {
		foreach (WC()->cart->get_cart() as $cart_item) {
			$cart_item_ids = array($cart_item['product_id'], $cart_item['variation_id']);
			if (in_array($product_id, $cart_item_ids)) {
				return true;
			}
		}
		return false;
	}
	return false;
}

add_filter('body_class', 'kls_body_class_for_cart_items');
function kls_body_class_for_cart_items($classes)
{
	// Check user currently is in product page
	if (!is_singular('product')) {
		return $classes;
	}

	if (kls_check_if_product_in_cart(get_the_id())) {
		$classes[] = 'product-in-cart';
	}

	return $classes;
}

/**
 * Add product usps
 *
 * @since 0.0.12
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
add_action('woocommerce_product_options_general_product_data', 'kls_add_product_usps');
function kls_add_product_usps()
{
	echo '<div class="options_group">';

	woocommerce_wp_text_input(
		array(
			'id' => 'usp_1',
			'value' => get_post_meta(get_the_ID(), 'usp_1', true),
			'label' => 'Product USP 1',
		)
	);

	woocommerce_wp_text_input(
		array(
			'id' => 'usp_2',
			'value' => get_post_meta(get_the_ID(), 'usp_2', true),
			'label' => 'Product USP 2',
		)
	);

	woocommerce_wp_text_input(
		array(
			'id' => 'usp_3',
			'value' => get_post_meta(get_the_ID(), 'usp_3', true),
			'label' => 'Product USP 3',
		)
	);

	woocommerce_wp_text_input(
		array(
			'id' => 'usp_4',
			'value' => get_post_meta(get_the_ID(), 'usp_4', true),
			'label' => 'Product USP 4',
		)
	);

	woocommerce_wp_text_input(
		array(
			'id' => 'usp_5',
			'value' => get_post_meta(get_the_ID(), 'usp_5', true),
			'label' => 'Product USP 5',
		)
	);

	woocommerce_wp_text_input(
		array(
			'id' => 'usp_6',
			'value' => get_post_meta(get_the_ID(), 'usp_6', true),
			'label' => 'Product USP 6',
		)
	);
	echo '</div>';
}

// Save usp data
add_action('woocommerce_process_product_meta', 'kls_save_fields', 10, 2);
function kls_save_fields($id, $post)
{
	update_post_meta($id, 'usp_1', $_POST['usp_1']);
	update_post_meta($id, 'usp_2', $_POST['usp_2']);
	update_post_meta($id, 'usp_3', $_POST['usp_3']);
	update_post_meta($id, 'usp_4', $_POST['usp_4']);
	update_post_meta($id, 'usp_5', $_POST['usp_5']);
	update_post_meta($id, 'usp_6', $_POST['usp_6']);
}

add_action('woocommerce_product_bulk_edit_start', 'kls_add_product_usps');

function kls_product_usp_bulk_edit_save($product)
{
	$post_id = $product->get_id();

	if (isset($_REQUEST['usp_1'])) {
		update_post_meta($post_id, 'usp_1', $_REQUEST['usp_1']);
	}

	if (isset($_REQUEST['usp_2'])) {
		update_post_meta($post_id, 'usp_2', $_REQUEST['usp_2']);
	}

	if (isset($_REQUEST['usp_3'])) {
		update_post_meta($post_id, 'usp_3', $_REQUEST['usp_3']);
	}

	if (isset($_REQUEST['usp_4'])) {
		update_post_meta($post_id, 'usp_4', $_REQUEST['usp_4']);
	}

	if (isset($_REQUEST['usp_5'])) {
		update_post_meta($post_id, 'usp_5', $_REQUEST['usp_5']);
	}

	if (isset($_REQUEST['usp_6'])) {
		update_post_meta($post_id, 'usp_6', $_REQUEST['usp_6']);
	}
}
add_action('woocommerce_product_bulk_edit_save', 'kls_product_usp_bulk_edit_save');


/**
 * Change price when variable changes
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.0.12
 */
add_action('woocommerce_before_add_to_cart_form', 'kls_selected_variation_price_replace_variable_price_range');
function kls_selected_variation_price_replace_variable_price_range()
{
	global $product;

	if ($product->is_type('variable')):
		?>
		<style>
			.woocommerce-variation-price {
				display: none;
			}
		</style>
		<script>
			jQuery(function ($) {
				$('form.cart').each(function () {
					var price = $(this).parent().find('p.price');
					var html = $(price).html();

					$(this).on('show_variation', function (event, data) {
						if (data.price_html) {
							$(price).html(data.price_html);
						}
					}).on('hide_variation', function (event) {
						$(price).html(html);
					});
				});
			});
		</script>
		<?php
	endif;
}

/**
 * Remove meta data if toggled
 *
 * @since 0.0.13
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if (get_theme_mod('product_sku_toggle') == 0 && get_theme_mod('product_categories_toggle') == 0 && get_theme_mod('product_tags_toggle') == 0) {
	remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);
}

// [Dev] Todo, this shouldn't work like this. It should be unloaded on the frontend and the backend should stay.
if (get_theme_mod('product_sku_toggle') == 0) {
	add_filter('wc_product_sku_enabled', '__return_false');
}

/**
 * Refresh wishlist count
 *
 * @since 0.0.14
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if (defined('YITH_WCWL') && get_theme_mod('general_menu_wishlist_toggle') == '1') {
	function kls_refresh_wishlist_count()
	{
		if (class_exists('Woocommerce') && defined('YITH_WCWL')) {
			echo yith_wcwl_count_products();
		}
		exit();
	}
	add_action('wp_ajax_kls_refresh_wishlist_count', 'kls_refresh_wishlist_count');
	add_action('wp_ajax_nopriv_kls_refresh_wishlist_count', 'kls_refresh_wishlist_count');
}

/**
 * Recently viewed products
 *
 * @since 0.0.18
 * @author Joeri van der Stek <joeri@klassebv.nl>
 * @var $wishlist_items
 */
function kls_recently_viewed_products($wishlist_items)
{
	$viewed_products = !empty($_COOKIE['woocommerce_recently_viewed']) ? (array) explode('|', wp_unslash($_COOKIE['woocommerce_recently_viewed'])) : array();
	$viewed_products = array_reverse(array_filter(array_map('absint', $viewed_products)));

	if (empty($viewed_products)) {
		return;
	}

	if (!empty(get_theme_mod('general_recently_viewed_products_title_text'))) {
		$heading = kls_translate_theme_mod('general_recently_viewed_products_title_text', 'Recently viewed products title text', 'nl');
	} else {
		$heading = apply_filters('woocommerce_product_related_products_heading', __('Recently viewed products', 'klasse-theme'));
	}

	if ('v2' == $GLOBALS['theme_style_version']):
		$title = '
		<div class="heading-big">
			<h3>' . __('Something for everyone', 'klasse-theme') . '</h3>
			<h2>' . esc_html($heading) . '</h2>
		</div>';
	elseif ('v1' == $GLOBALS['theme_style_version']):
		$title = '<h2>' . esc_html($heading) . '</h2>';
	else:
		$title = '<div class="heading-big"><h2>' . esc_html($heading) . '</h2></div>';
	endif;

	$products_to_exclude = array();

	// If is cart.
	if (is_cart()) {
		$limit = get_theme_mod('cart_recently_viewed_products_amount');
		$columns = get_theme_mod('cart_recently_viewed_products_amount');

		foreach (WC()->cart->get_cart() as $cart_item) {
			$products_to_exclude[] = $cart_item['product_id'];
		}

		// If is yith wishlist page.
	} elseif (function_exists('yith_wcwl_is_wishlist_page') && yith_wcwl_is_wishlist_page() == 1) {
		$limit = get_theme_mod('wishlist_recently_viewed_products_amount');
		$columns = get_theme_mod('wishlist_recently_viewed_products_amount');

		foreach ($wishlist_items as $wishlist_item) {
			$products_to_exclude[] = $wishlist_item['product_id'];
		}
		// Else.
	} else {
		// $limit = '4';
		$limit = (!empty(get_theme_mod('product_recently_viewed_products_count')) ? get_theme_mod('product_recently_viewed_products_count') : '4');
		$columns = (!empty(get_theme_mod('product_recently_viewed_column_count')) ? get_theme_mod('product_recently_viewed_column_count') : '4');
		$product_ids = $viewed_products;
	}

	$product_ids = array_diff($viewed_products, $products_to_exclude);

	$product_ids = implode(',', $product_ids);

	echo '<div class="recently-viewed">' . $title . do_shortcode("[products ids='$product_ids' limit='$limit' columns='$columns' orderby='post__in']") . '</div>';
}
add_action('recently_viewed_products', 'kls_recently_viewed_products');


/**
 * Toggle Woocommerce product tracking
 *
 * @since 0.0.18
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_track_product_view()
{
	if (!is_singular('product') /* xnagyg: remove this condition to run: || ! is_active_widget( false, false, 'woocommerce_recently_viewed_products', true )*/) {
		return;
	}

	global $post;

	if (empty($_COOKIE['woocommerce_recently_viewed'])) { // @codingStandardsIgnoreLine.
		$viewed_products = array();
	} else {
		$viewed_products = wp_parse_id_list((array) explode('|', wp_unslash($_COOKIE['woocommerce_recently_viewed']))); // @codingStandardsIgnoreLine.
	}

	// Unset if already in viewed products list.
	$keys = array_flip($viewed_products);

	if (isset($keys[$post->ID])) {
		unset($viewed_products[$keys[$post->ID]]);
	}

	$viewed_products[] = $post->ID;

	if (count($viewed_products) > 5) {
		array_shift($viewed_products);
	}

	// Store for session only.
	wc_setcookie('woocommerce_recently_viewed', implode('|', $viewed_products));
}
remove_action('template_redirect', 'wc_track_product_view', 20);
add_action('template_redirect', 'kls_track_product_view', 20);

/**
 * Change checkout field order
 *
 * @since 0.0.18
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if (get_theme_mod('checkout_field_order_toggle') == 1) {
	function kls_override_checkout_fields($fields)
	{
		$fields['billing']['billing_first_name']['priority'] = 1;
		$fields['billing']['billing_last_name']['priority'] = 2;
		$fields['billing']['billing_email']['priority'] = 3;
		$fields['billing']['billing_phone']['priority'] = 4;
		$fields['billing']['billing_company']['priority'] = 5;
		if (get_theme_mod('kls_checkout_toggle_vat_field', '0') == '1') {
			$fields['billing']['billing_vat']['priority'] = 6;
			$fields['billing']['billing_vat']['class'][] = 'update_totals_on_change';
		}
		$fields['billing']['billing_country']['priority'] = 7;
		$fields['billing']['billing_state']['priority'] = 8;
		$fields['billing']['billing_address_1']['priority'] = 9;
		$fields['billing']['billing_address_2']['priority'] = 10;
		$fields['billing']['billing_city']['priority'] = 11;
		$fields['billing']['billing_postcode']['priority'] = 12;

		$fields['shipping']['shipping_first_name']['priority'] = 1;
		$fields['shipping']['shipping_last_name']['priority'] = 2;
		$fields['shipping']['shipping_company']['priority'] = 5;
		$fields['shipping']['shipping_country']['priority'] = 6;
		$fields['shipping']['shipping_state']['priority'] = 7;
		$fields['shipping']['shipping_address_1']['priority'] = 8;
		$fields['shipping']['shipping_address_2']['priority'] = 9;
		$fields['shipping']['shipping_city']['priority'] = 10;
		$fields['shipping']['shipping_postcode']['priority'] = 11;

		return $fields;
	}
	add_filter('woocommerce_checkout_fields', 'kls_override_checkout_fields', 1);

	function kls_override_default_locale_fields($fields)
	{
		$fields['state']['priority'] = 5;
		$fields['address_1']['priority'] = 6;
		$fields['address_2']['priority'] = 7;
		return $fields;
	}
	add_filter('woocommerce_default_address_fields', 'kls_override_default_locale_fields');
}

/**
 * Toggle wishlist from product archive
 *
 * @since 0.0.18
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if (get_theme_mod('archive_wishlist_toggle') == 0) {
	remove_action('woocommerce_shop_loop_item_title', 'kls_move_wishlist_button', 45);
	remove_action('woocommerce_after_shop_loop_item', 'kls_move_wishlist_button', 45);
}

/**
 * Toggle price from product archive
 *
 * @since 0.0.18
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if (get_theme_mod('archive_price_toggle') == 0) {
	remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10);
}

/**
 * Change product page related products amount
 *
 * @since 0.0.18
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
add_filter('woocommerce_output_related_products_args', 'kls_product_related_products_amount', 20);

function kls_product_related_products_amount($args)
{
	if (get_theme_mod('product_related_products_count')) {
		$args['posts_per_page'] = get_theme_mod('product_related_products_count');
	} else {
		$args['posts_per_page'] = 4;
	}

	if (get_theme_mod('product_related_products_column_count')) {
		$args['columns'] = get_theme_mod('product_related_products_column_count');
	} else {
		$args['columns'] = 4;
	}
	return $args;
}

/**
 * Change product page upsells amount
 *
 * @since 0.0.18
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
/**
 * Change number of upsells output
 */
add_filter('woocommerce_upsell_display_args', 'kls_product_upsells_amount', 20);

function kls_product_upsells_amount($args)
{
	if (get_theme_mod('product_up_sells_count')) {
		$args['posts_per_page'] = get_theme_mod('product_up_sells_count');
	} else {
		$args['posts_per_page'] = 4;
	}

	if (get_theme_mod('product_up_sells_column_count')) {
		$args['columns'] = get_theme_mod('product_up_sells_column_count');
	} else {
		$args['columns'] = 4;
	}
	return $args;
}

/**
 * Add product image hover effect
 *
 * @since 0.0.18
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if (get_theme_mod('general_image_zoom_effect_toggle') == 1) {
	function kls_on_hover_shop_loop_image()
	{
		$image_id = wc_get_product()->get_gallery_image_ids();

		if ($image_id) {
			echo wp_get_attachment_image($image_id[0], $size = 'woocommerce_thumbnail');
		} else {
			echo wp_get_attachment_image(wc_get_product()->get_image_id(), $size = 'woocommerce_thumbnail');
		}
	}
	add_action('woocommerce_before_shop_loop_item_title', 'kls_on_hover_shop_loop_image');
}

/**
 * Add product category short description
 *
 * @since 0.0.66
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
// Product Cat Create page
function kls_taxonomy_add_new_meta_field()
{
	?>
	<div class="form-field">
		<label for="kls_short_desc">
			<?php _e('Short description', 'klasse-theme'); ?>
		</label>
		<textarea name="kls_short_desc" id="kls_short_desc"></textarea>
		<p class="description">
			<?php _e('Enter a short description for the category slider. Keep it under 50 character.', 'klasse-theme'); ?>
		</p>
	</div>
	<?php
}

// Product Cat Edit page
function kls_taxonomy_edit_meta_field($term)
{

	// Getting term ID
	$term_id = $term->term_id;

	// Retrieve the existing value(s) for this meta field.
	$kls_short_desc = get_term_meta($term_id, 'kls_short_desc', true);

	ob_start();
	wp_editor(
		$kls_short_desc,
		'post_meta_box',
		array(
			'textarea_name' => 'kls_short_desc',
			'wpautop' => true,
			'media_buttons' => false,
			'textarea_rows' => 5
		)
	);
	$output = ob_get_clean();
	?>
	<tr class="form-field">
		<th scope="row" valign="top"><label for="kls_short_desc">
				<?php _e('Short Description', 'klasse-theme'); ?>
			</label></th>
		<td>
			<!-- <textarea name="kls_short_desc" id="kls_short_desc"><?php echo esc_attr($kls_short_desc) ? esc_attr($kls_short_desc) : ''; ?></textarea> -->
			<?php echo $output; ?>
			<p class="description">
				<?php _e('Enter a short description for the category slider. Keep it under 50 character.', 'klasse-theme'); ?>
			</p>
		</td>
	</tr>
	<?php
}
add_action('product_cat_add_form_fields', 'kls_taxonomy_add_new_meta_field', 10, 1);
add_action('product_cat_edit_form_fields', 'kls_taxonomy_edit_meta_field', 10, 1);

function kls_taxonomy_add_new_title_field()
{
	?>
	<div class="form-field">
		<label for="kls_cat_title">
			<?php _e('Category title', 'klasse-theme'); ?>
		</label>
		<input name="kls_cat_title" id="kls_cat_title">
		<p class="description">
			<?php _e('Enter a title to overwrite the H1 on the category page.', 'klasse-theme'); ?>
		</p>
	</div>
	<?php
}

// Product Cat Edit page
function kls_taxonomy_edit_title_field($term)
{
	// Getting term ID
	$term_id = $term->term_id;

	// Retrieve the existing value(s) for this meta field.
	$kls_cat_title = get_term_meta($term_id, 'kls_cat_title', true);
	?>
	<tr class="form-field">
		<th scope="row" valign="top"><label for="kls_cat_title">
				<?php _e('Category title', 'klasse-theme'); ?>
			</label></th>
		<td>
			<input name="kls_cat_title" id="kls_cat_title" size="40" value="<?php echo esc_attr($kls_cat_title) ? esc_attr($kls_cat_title) : ''; ?>" />
			<p class="description">
				<?php _e('Enter a title to overwrite the H1 on the category page.', 'klasse-theme'); ?>
			</p>
		</td>
	</tr>
	<?php
}
add_action('product_cat_add_form_fields', 'kls_taxonomy_add_new_title_field', 10, 1);
add_action('product_cat_edit_form_fields', 'kls_taxonomy_edit_title_field', 10, 1);

// Save extra taxonomy fields callback function.
function kls_save_taxonomy_custom_meta($term_id)
{
	$kls_short_desc = filter_input(INPUT_POST, 'kls_short_desc');

	update_term_meta($term_id, 'kls_short_desc', $kls_short_desc);

	$kls_category_title = filter_input(INPUT_POST, 'kls_cat_title');

	update_term_meta($term_id, 'kls_cat_title', $kls_category_title);
}
add_action('edited_product_cat', 'kls_save_taxonomy_custom_meta', 10, 1);
add_action('create_product_cat', 'kls_save_taxonomy_custom_meta', 10, 1);


/**
 * Custom star rating
 *
 * @since 0.0.72
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_star_rating()
{
	if (get_option('kls_ratings_select') == 'Manually') {
		$percentagerating = get_option('kls_rating');
		$reviewsurl = get_option('kls_rating_url');
		$averagerating = get_option('kls_rating_text');
		if (get_option('kls_rating_image')):
			$ratingimage = wp_get_attachment_image_src(get_option('kls_rating_image'), 'full')[0];
		else:
			$ratingimage = 0;
		endif;

	} elseif (get_option('kls_ratings_select') == 'Kiyoh') {
		$xml = simplexml_load_file(get_option('kls_kiyoh_url'), 'SimpleXMLElement', LIBXML_COMPACT);

		$percentagerating = (string) $xml->percentageRecommendation[0];
		$reviewsurl = (string) $xml->viewReviewUrl[0];
		$averagerating = (string) $xml->averageRating[0];
		$ratingimage = KT_ASSETS_PATH . 'images/kiyoh.svg';
	} elseif (get_option('kls_ratings_select') == 'Site-Reviews-plugin') {
		$percentagerating = (glsr_get_ratings(array('status' => 'approved'))['average'] * 100 / 5);
		$reviewsurl = get_option('kls_rating_url');
		$averagerating = glsr_get_ratings(array('status' => 'approved'))['average'];
		if (get_option('kls_rating_image')):
			$ratingimage = wp_get_attachment_image_src(get_option('kls_rating_image'), 'full')[0];
		else:
			$ratingimage = 0;
		endif;
	}
	?>

	<div class="kls-rating-container">
		<a class="kls-rating" href="<?php echo $reviewsurl; ?>" target="_blank">
			<span class="kls-rating-stars">
				<?php
				if ($percentagerating <= '10') {
					echo '<i class="fas fa-star-half-alt"></i>';
				} elseif ($percentagerating >= '20') {
					echo '<i class="fas fa-star"></i>';
				}

				if ($percentagerating >= '30' && $percentagerating < '40') {
					echo '<i class="fas fa-star-half-alt"></i>';
				} elseif ($percentagerating >= '40') {
					echo '<i class="fas fa-star"></i>';
				} else {
					echo '<i class="far fa-star"></i>';
				}

				if ($percentagerating >= '50' && $percentagerating < '60') {
					echo '<i class="fas fa-star-half-alt"></i>';
				} elseif ($percentagerating >= '60') {
					echo '<i class="fas fa-star"></i>';
				} else {
					echo '<i class="far fa-star"></i>';
				}

				if ($percentagerating >= '70' && $percentagerating < '80') {
					echo '<i class="fas fa-star-half-alt"></i>';
				} elseif ($percentagerating >= '80') {
					echo '<i class="fas fa-star"></i>';
				} else {
					echo '<i class="far fa-star"></i>';
				}

				if ($percentagerating >= '90' && $percentagerating < '100') {
					echo '<i class="fas fa-star-half-alt"></i>';
				} elseif ($percentagerating >= '100') {
					echo '<i class="fas fa-star"></i>';
				} else {
					echo '<i class="far fa-star"></i>';
				}
				?>
			</span>
			<span class="kls-rating-number"><strong>
					<?php echo $averagerating; ?>
				</strong></span>
			<span class="kls-rating-icon" style="<?php ($ratingimage == 0 ? 'display: none;' : ''); ?>"><img src="<?php echo $ratingimage; ?>" alt="Sterren logo" width="20" height="20"></span>
		</a>
	</div>
	<?php
}

/**
 * Check for housenumber on checkout
 *
 * @since 0.0.78
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
add_action('woocommerce_after_checkout_validation', 'kls_validate_house_number', 10, 2);

function kls_validate_house_number($data, $errors)
{
	if (!preg_match('/[0-9]/', $data['billing_address_1'])) {
		$errors->add('address', __('Sorry, but the address you provided does not contain a house number.', 'klasse-theme'));
	}
}

/**
 * Syncsilo fixes
 *
 * @since 0.0.79
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if (get_option('kls_syncsilo_compatibility_toggle') == 'on') {
	/**
	 * Add SyncSilo class to the products
	 *
	 * @since 0.0.79
	 * @author Joeri van der Stek <joeri@klassebv.nl>
	 */
	function kls_add_syncsilo_class($classes, $class)
	{
		if (class_exists('SyncSiloProduct') && SyncSiloProduct::is_configurable() && is_product()) {
			$classes = array_merge(array('kls_is_configurable', ''), $classes);
		}
		return $classes;
	}
	add_filter('post_class', 'kls_add_syncsilo_class', 10, 3);

	/**
	 * Add 'Configur now' text to products
	 *
	 * @since 0.1.04
	 * @author Joeri van der Stek <joeri@klassebv.nl>
	 */
	function kls_add_configure_now_text()
	{
		if (get_theme_mod('syncsilo_configure_now_toggle') == 1 && class_exists('SyncSiloProduct') && SyncSiloProduct::is_configurable()):
			echo '<span class="price">' . __('Configure now', 'klasse-theme') . '</span>';
		endif;
	}
	add_action('woocommerce_after_shop_loop_item', 'kls_add_configure_now_text');

	// Add SyncSilo script.

	function kls_enqueue_scyncsilo_script()
	{
		if (defined('YITH_WCQV')):
			wp_enqueue_script('wwa_pc/js/wp.hooks', 'https://js-cdn.syncsilo.com/wwa-configurator.min.js', array(), $GLOBALS['kls_theme_version']);
		endif;
	}
	add_filter('woocommerce_enqueue_styles', 'kls_enqueue_scyncsilo_script');

}

/**
 * Added arrow to the product slider
 *
 * @since 0.1.04
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if (get_theme_mod('product_image_arrows_toggle') == 1):
	add_filter('woocommerce_single_product_carousel_options', 'kls_update_woo_flexslider_options');
	function kls_update_woo_flexslider_options($options)
	{
		$options['directionNav'] = wp_is_mobile() ? true : false;

		return $options;
	}
endif;

/**
 * Added dots to the product slider
 *
 * @since 0.1.04
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if (get_theme_mod('product_image_dots_toggle') == 1):
	add_filter('woocommerce_single_product_carousel_options', 'sf_update_woo_flexslider_options');
	function sf_update_woo_flexslider_options($options)
	{
		$options['controlNav'] = wp_is_mobile() ? true : 'thumbnails';

		return $options;
	}
endif;

/**
 * Add registration usps
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.51
 */
function kls_add_registration_usps()
{
	if (get_theme_mod('my_account_registration_usps_toggle') == 1) {
		?>
		<p><strong>
				<?php esc_html_e('A customer account offers you many advantages:', 'klasse-theme'); ?>
			</strong></p>
		<p>
			<?php
			if (get_option('kls_woocommerce_usp_1')) {
				?>
				<span style="color: #5eba7d"><i class="fas fa-check"></i></span>
				<?php echo get_option('kls_woocommerce_usp_1'); ?><br>
				<?php
			}
			?>
			<?php
			if (get_option('kls_woocommerce_usp_2')) {
				?>
				<span style="color: #5eba7d"><i class="fas fa-check"></i></span>
				<?php echo get_option('kls_woocommerce_usp_2'); ?><br>
				<?php
			}
			?>
			<?php
			if (get_option('kls_woocommerce_usp_3')) {
				?>
				<span style="color: #5eba7d"><i class="fas fa-check"></i></span>
				<?php echo get_option('kls_woocommerce_usp_3'); ?><br>
				<?php
			}
			?>
			<?php
			if (get_option('kls_woocommerce_usp_4')) {
				?>
				<span style="color: #5eba7d"><i class="fas fa-check"></i></span>
				<?php echo get_option('kls_woocommerce_usp_4'); ?><br>
				<?php
			}
			?>
		</p>
		<?php
	}
}
add_action('woocommerce_register_form_start', 'kls_add_registration_usps');
add_action('kls_checkout_form_start', 'kls_add_registration_usps');

/**
 * Hide checkout order notes
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.51
 */
if (get_theme_mod('checkout_notes_toggle') == 1):
	add_filter('woocommerce_enable_order_notes_field', '__return_false', 9999);
endif;

/**
 * Add product 24 hours shipping
 *
 * @since 0.1.64
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * [Dev] Todo, add implementation.
 */
function kls_add_product_24hours_shipping()
{
	echo '<div class="options_group">';

	woocommerce_wp_checkbox(
		array(
			'id' => '24hour_shipping',
			'value' => get_post_meta(get_the_ID(), '24hour_shipping', true),
			'label' => __('Toggle 24 hours shipping?', 'klasse-theme'),
		)
	);
	echo '</div>';
}
add_action('woocommerce_product_options_general_product_data', 'kls_add_product_24hours_shipping');

// Save usp data
function kls_add_product_24hours_shipping_save_fields($id, $post)
{
	update_post_meta($id, '24hour_shipping', $_POST['24hour_shipping']);
}
add_action('woocommerce_process_product_meta', 'kls_add_product_24hours_shipping_save_fields', 10, 2);

/**
 * Add the product 24 hours shipping option to the bulk edit
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.64
 */
function kls_custom_field_bulk_edit_input()
{
	?>
	<div class="inline-edit-group">
		<label for="24hour_shipping">
			<span class="title">
				<?php _e('Toggle 24 hours shipping?', 'klasse-theme'); ?>
			</span>
		</label>
		<span class="input-checkbox-wrap">
			<input type="checkbox" class="checkbox" name="24hour_shipping" id="24hour_shipping" value="yes">
		</span>
	</div>
	<?php
}
add_action('woocommerce_product_bulk_edit_start', 'kls_custom_field_bulk_edit_input');

function kls_custom_field_bulk_edit_save($product)
{
	$post_id = $product->get_id();
	if (isset($_REQUEST['24hour_shipping'])) {
		$custom_field = $_REQUEST['24hour_shipping'];
		update_post_meta($post_id, '24hour_shipping', $_REQUEST['24hour_shipping']);
	}
}
add_action('woocommerce_product_bulk_edit_save', 'kls_custom_field_bulk_edit_save');

if (get_theme_mod('kls_checkout_toggle_vat_field', '0') == '1') {
	function kls_add_woocommerce_billing_fields($billing_fields)
	{
		$billing_fields2['billing_first_name'] = $billing_fields['billing_first_name'];
		$billing_fields2['billing_last_name'] = $billing_fields['billing_last_name'];
		$billing_fields2['billing_company'] = $billing_fields['billing_company'];

		$billing_fields2['billing_vat'] = array(
			'type' => 'text',
			'label' => __('VAT number', 'klasse-theme'),
			'class' => array('form-row-wide'),
			'required' => false,
			'clear' => true,
		);

		$merged_billing_fields = $billing_fields2 + $billing_fields;

		return $merged_billing_fields;
	}
	add_filter('woocommerce_billing_fields', 'kls_add_woocommerce_billing_fields');

	function kls_my_account_my_address_formatted_address($fields, $customer_id, $type)
	{
		if ($type == 'billing') {
			$fields['vat'] = get_user_meta($customer_id, 'billing_vat', true);
		}
		return $fields;
	}
	add_filter('woocommerce_my_account_my_address_formatted_address', 'kls_my_account_my_address_formatted_address', 10, 3);

	function kls_formatted_address_replacements($address, $args)
	{
		$address['{vat}'] = '';
		$address['{vat_upper}'] = '';

		if (!empty($args['vat'])) {
			$address['{vat}'] = $args['vat'];
			$address['{vat_upper}'] = strtoupper($args['vat']);
		}
		return $address;
	}
	add_filter('woocommerce_formatted_address_replacements', 'kls_formatted_address_replacements', 10, 2);

	function kls_customer_meta_fields($fields)
	{
		$fields['billing']['fields']['billing_vat'] = array(
			'label' => __('VAT number', 'klasse-theme'),
			'description' => ''
		);
		return $fields;
	}
	add_filter('woocommerce_customer_meta_fields', 'kls_customer_meta_fields');

	function kls_admin_billing_fields($fields)
	{
		$fields['vat'] = array(
			'label' => __('VAT number', 'klasse-theme'),
			'show' => true
		);

		return $fields;
	}
	add_filter('woocommerce_admin_billing_fields', 'kls_admin_billing_fields');

	// Todo, this doesn't work. It doesn't get processed correctly into the output.
	function kls_found_customer_details($customer_data)
	{
		$user_id = $_POST['user_id'];
		$customer_data['_billing_vat'] = get_user_meta($user_id, 'billing_vat', true);

		return $customer_data;
	}
	add_filter('woocommerce_found_customer_details', 'kls_found_customer_details');

	function kls_add_vat_to_invoice($template_type, $order)
	{
		if ($template_type == 'invoice') {
			if ($billing_vat = $order->get_meta('_billing_vat')) {
				echo '<div>' . __('VAT number', 'klasse-theme') . ': ' . $billing_vat . '</div>';
			}
		}
	}
	add_action('wpo_wcpdf_after_billing_address', 'kls_add_vat_to_invoice', 10, 2);

	function kls_vat_exempt($post_data)
	{
		if (get_theme_mod('kls_checkout_toggle_vat_exempt', '0') == '1') {
			parse_str($post_data, $results);

			$billing_vat = isset($results['billing_vat']) ? sanitize_text_field($results['billing_vat']) : '';
			$billing_country = isset($results['billing_country']) ? sanitize_text_field($results['billing_country']) : '';

			$customer = WC()->customer;
			$store_base_country = WC()->countries->get_base_country();

			if (!empty($billing_vat) && $billing_country !== $store_base_country) {
				if (!$customer->is_vat_exempt()) {
					$customer->set_is_vat_exempt(true);
				}
			} else {
				if ($customer->is_vat_exempt()) {
					$customer->set_is_vat_exempt(false);
				}
			}
		}
	}
	add_action('woocommerce_checkout_update_order_review', 'kls_vat_exempt', 10, 1);
}