<?php

/**
 * Change the amount of products per archive page
 *
 * @since 0.0.18
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
add_filter('loop_shop_per_page', 'kls_products_per_shop_page', 20);

function kls_products_per_shop_page($cols)
{
	if (get_theme_mod('archive_products_per_page_count')) {
		$cols = get_theme_mod('archive_products_per_page_count');
	} else {
		$cols = 12;
	}
	return $cols;
}

/**
 * Toggle the sidebar as a toggleable menu
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.52
 *
 * @return string string with body classes.
 */
function kls_add_sidebar_toggle_body_class($classes)
{
	if (get_theme_mod('archive_sidebar_toggleable_toggle') == 1) {
		$classes[] = 'sidebar-togglable';
	}

	return $classes;
}
add_filter('body_class', 'kls_add_sidebar_toggle_body_class');

/**
 * Woocommerce archive description
 *
 * @since 0.0.14
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_woocommerce_product_archive_description()
{
	// Don't display the description on search results page.
	if (is_search() && 1 == get_theme_mod('kls_archive_banner_toggle', '0') && 1 == get_theme_mod('kls_archive_banner_title_toggle', '0')) {
		return;
	}

	if (is_post_type_archive('product') && 0 === absint(get_query_var('paged'))) {
		$shop_page = get_post(wc_get_page_id('shop'));
		if ($shop_page) {
			$description = wc_format_content($shop_page->post_content);
			kls_term_description($description);
		}
	}
}
add_action('woocommerce_archive_description', 'kls_woocommerce_product_archive_description');

/**
 * Woocommerce archive taxonomy description
 *
 * @since 0.0.14
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_woocommerce_taxonomy_archive_description()
{
	if (is_product_taxonomy() && 0 === absint(get_query_var('paged'))) {
		$description = wc_format_content(term_description());
		kls_term_description($description);
	}
}
add_action('woocommerce_archive_description', 'kls_woocommerce_taxonomy_archive_description');

function kls_term_description($description)
{
	if ($description) {
		if (apply_filters('woocommerce_show_page_title', true)):
			$cat = get_queried_object();
			$cat_new_title = get_term_meta($cat->term_id, 'kls_cat_title', true);

			if (0 == get_theme_mod('kls_archive_banner_title_toggle', '1')):
				if (isset($cat_new_title) && !empty($cat_new_title)) {
					?>
					<h1 class="woocommerce-products-header__title page-title">
						<?php echo $cat_new_title; ?>
					</h1>
					<?php
				} else {
					?>
					<h1 class="woocommerce-products-header__title page-title">
						<?php woocommerce_page_title(); ?>
					</h1>
					<?php
				}
			else:
				if (isset($cat_new_title) && !empty($cat_new_title)) {
					?>
					<h2 class="woocommerce-products-header__title page-title">
						<?php echo $cat_new_title; ?>
					</h2>
					<?php
				} else {
					?>
					<h2 class="woocommerce-products-header__title page-title">
						<?php woocommerce_page_title(); ?>
					</h2>
					<?php
				}
			endif;
		endif;
		echo '<div class="term-description">' . $description . '</div>';
	}
}

/**
 * Add the product archive banner.
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.68
 */
function kls_archive_banner()
{
	if (get_theme_mod('kls_archive_banner_toggle', 0) == 1):
		if ('none' !== get_theme_mod('kls_header_archive_divi_shortcode_id', 'none')):
			?>
			<div class="theme-container et-l">
				<div class="et_builder_inner_content et_pb_gutters3">
					<?php echo do_shortcode('[et_pb_section global_module="' . get_theme_mod('kls_header_archive_divi_shortcode_id') . '"][/et_pb_section]'); ?>
				</div>
			</div>
			<?php
		else:
			$cat = get_queried_object();
			$cat_id = !is_shop() ? $cat->term_id : null;
			$image_id = get_term_meta($cat_id, 'category-image-id', true);

			if (isset($image_id) && !empty($image_id)) {
				$category_image_url = $image_id;
			} else {
				$category_image_url = get_theme_mod('kls_archive_banner_background_image', '');
			}

			if (!wp_attachment_is_image($category_image_url)) {
				?>
				<div class="theme-container theme-banner theme-archive-banner theme-archive-banner-video">
					<video autoplay muted loop>
						<source src="<?php echo esc_url_raw(wp_get_attachment_url($category_image_url)); ?>" type=" <?php echo wp_check_filetype(wp_get_attachment_url($category_image_url))['type']; ?>">
					</video>
					<?php
			} else {
				?>
					<div class="theme-container theme-banner theme-archive-banner" style="background-image: url('<?php echo esc_url(wp_get_attachment_url($category_image_url)); ?> ');
					background-size: cover;
					background-position: center;
					background-repeat: no-repeat;
					background-blend-mode: overlay;">
						<?php
			}
			?>
					<div class="theme-row">
						<div class="theme-col-12">
							<?php
							if (1 == get_theme_mod('kls_archive_banner_title_toggle', '1')):
								?>
								<h1 class="product_title entry-title">
									<?php echo is_product_category() ? esc_html(single_term_title()) : esc_html(woocommerce_page_title()); ?>
								</h1>
								<div class="breadcrumb">
									<?php
									if (function_exists('woocommerce_breadcrumb')) {
										$args = array(
											'delimiter' => ' / ',
										);
										woocommerce_breadcrumb($args);
									} elseif (function_exists('yoast_breadcrumb')) {
										yoast_breadcrumb();
									}
									?>
								</div>
								<?php
							endif;
							?>
						</div>
					</div>
				</div>
				<div class="theme-container">
					<?php
		endif;
		?>
			<?php else: ?>
				<div class="theme-container">
					<?php
					do_action('kls_breadcrumb');
	endif;
}
add_action('kls_before_archive', 'kls_archive_banner');

/**
 * Add the product archive Divi footer.
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.68
 */
if (!class_exists('klasse_META')) {

	class klasse_META
	{

		public function __construct()
		{
			// Empty.
		}

		// Initialize the class and start calling our hooks and filters.
		public function init()
		{
			add_action('product_cat_add_form_fields', array($this, 'add_category_image'), 10, 2);
			add_action('created_product_cat', array($this, 'save_category_image'), 10, 2);
			add_action('product_cat_edit_form_fields', array($this, 'update_category_image'), 10, 2);
			add_action('edited_product_cat', array($this, 'updated_category_image'), 10, 2);
			add_action('admin_enqueue_scripts', array($this, 'load_media'));
			add_action('admin_footer', array($this, 'add_script'));
		}

		public function load_media()
		{
			wp_enqueue_media();
		}

		// Add a form field in the new category page.
		public function add_category_image($taxonomy)
		{
			?>
						<div class="form-field term-group">
							<label for="category-image-id">
								<?php esc_html_e('Banner background image', 'klasse-theme'); ?>
							</label>
							<input type="hidden" id="category-image-id" name="category-image-id" class="custom_media_url" value="">
							<div id="category-image-wrapper"></div>
							<p>
								<input type="button" class="button button-secondary klasse_media_button" id="klasse_media_button" name="klasse_media_button" value="<?php esc_html_e('Upload/add image', 'klasse-theme'); ?>" />
								<input type="button" class="button button-secondary klasse_media_remove" id="klasse_media_remove" name="klasse_media_remove" value="<?php esc_html_e('Remove image', 'klasse-theme'); ?>" />
							</p>
						</div>
						<?php
		}

		// Save the form field.
		public function save_category_image($term_id, $tt_id)
		{
			if (isset($_POST['category-image-id']) && '' !== $_POST['category-image-id']) {
				$image = $_POST['category-image-id'];
				add_term_meta($term_id, 'category-image-id', $image, true);
			}
		}

		// Edit the form field.
		public function update_category_image($term, $taxonomy)
		{
			?>
						<tr class="form-field term-group-wrap">
							<th scope="row">
								<label for="category-image-id">
									<?php esc_html_e('Banner background image', 'klasse-theme'); ?>
								</label>
							</th>
							<td>
								<?php $image_id = get_term_meta($term->term_id, 'category-image-id', true); ?>
								<input type="hidden" id="category-image-id" name="category-image-id" value="<?php echo $image_id; ?>">
								<div id="category-image-wrapper">
									<?php
									if ($image_id) {
										echo wp_get_attachment_image($image_id, 'thumbnail');
									}
									?>
								</div>
								<p>
									<input type="button" class="button button-secondary klasse_media_button" id="klasse_media_button" name="klasse_media_button" value="<?php _e('Add Image', 'klasse-theme'); ?>" />
									<input type="button" class="button button-secondary klasse_media_remove" id="klasse_media_remove" name="klasse_media_remove" value="<?php _e('Remove Image', 'klasse-theme'); ?>" />
								</p>
							</td>
						</tr>
						<?php
		}

		// Update the form field value.
		public function updated_category_image($term_id, $tt_id)
		{
			if (isset($_POST['category-image-id']) && '' !== $_POST['category-image-id']) {
				$image = $_POST['category-image-id'];
				update_term_meta($term_id, 'category-image-id', $image);
			} else {
				update_term_meta($term_id, 'category-image-id', '');
			}
		}

		// Add script.
		public function add_script()
		{
			?>
						<script>
							jQuery(document).ready(function ($) {
								function ct_media_upload(button_class) {
									var _custom_media = true,
										_orig_send_attachment = wp.media.editor.send.attachment;
									$('body').on('click', button_class, function (e) {
										var button_id = '#' + $(this).attr('id');
										var send_attachment_bkp = wp.media.editor.send.attachment;
										var button = $(button_id);
										_custom_media = true;
										wp.media.editor.send.attachment = function (props, attachment) {
											if (_custom_media) {
												$('#category-image-id').val(attachment.id);
												$('#category-image-wrapper').html('<img class="custom_media_image" src="" style="margin:0;padding:0;max-height:100px;float:none;" />');
												$('#category-image-wrapper .custom_media_image').attr('src', attachment.url).css('display', 'block');
											} else {
												return _orig_send_attachment.apply(button_id, [props, attachment]);
											}
										}
										wp.media.editor.open(button);
										return false;
									});
								}
								ct_media_upload('.klasse_media_button.button');
								$('body').on('click', '.klasse_media_remove', function () {
									$('#category-image-id').val('');
									$('#category-image-wrapper').html('<img class="custom_media_image" src="" style="margin:0;padding:0;max-height:100px;float:none;" />');
								});

								$(document).ajaxComplete(function (event, xhr, settings) {
									var queryStringArr = settings.data.split('&');
									if ($.inArray('action=add-tag', queryStringArr) !== -1) {
										var xml = xhr.responseXML;
										$response = $(xml).find('term_id').text();
										if ($response != "") {
											// Clear the thumb image.
											$('#category-image-wrapper').html('');
										}
									}
								});
							});
						</script>
						<?php
		}

	}

	$klasse_META = new klasse_META();
	$klasse_META->init();
}