<?php

if ( 1 == get_theme_mod( 'kls_cart_notes_toggle' ) ) {
	/**
	 * Add a textarea field to a product in the cart.
	 *
	 * @author Joeri van der Stek <joeri@klassebv.nl>
	 *
	 * @since 0.1.62
	 */
	function kls_after_cart_item_name( $cart_item, $cart_item_key ) {
		$notes = isset( $cart_item['notes'] ) ? $cart_item['notes'] : '';
		printf(
			'<div><input class="%s" id="cart_notes_%s" data-cart-id="%s" value="%s" placeholder="%s"/></div>',
			'kls-cart-notes',
			$cart_item_key,
			$cart_item_key,
			$notes,
			__( 'Product notes (optional)', 'klasse-theme' )
		);
	}
	add_action( 'woocommerce_after_cart_item_name', 'kls_after_cart_item_name', 10, 2 );

	/**
	 *
	 * @author Joeri van der Stek <joeri@klassebv.nl>
	 *
	 * @since 0.1.62
	 */
	function prefix_update_cart_notes() {
		// Do a nonce check.
		if ( ! isset( $_POST['security'] ) || ! wp_verify_nonce( $_POST['security'], 'woocommerce-cart' ) ) {
			wp_send_json( array( 'nonce_fail' => 1 ) );
			exit;
		}
		// Save the notes to the cart meta.
		$cart                                 = WC()->cart->cart_contents;
		$cart_id                              = $_POST['cart_id'];
		$notes                                = $_POST['notes'];
		$cart_item                            = $cart[ $cart_id ];
		$cart_item['notes']                   = $notes;
		WC()->cart->cart_contents[ $cart_id ] = $cart_item;
		WC()->cart->set_session();
		wp_send_json( array( 'success' => 1 ) );
		exit;
	}
	add_action( 'wp_ajax_prefix_update_cart_notes', 'prefix_update_cart_notes' );
	add_action( 'wp_ajax_nopriv_prefix_update_cart_notes', 'prefix_update_cart_notes' );

	/**
	 *
	 * @author Joeri van der Stek <joeri@klassebv.nl>
	 *
	 * @since 0.1.62
	 */
	function prefix_checkout_create_order_line_item( $item, $cart_item_key, $values, $order ) {
		foreach ( $item as $cart_item_key => $cart_item ) {
			if ( isset( $cart_item['notes'] ) ) {
				$item->add_meta_data( 'notes', $cart_item['notes'], true );
			}
		}
	}
	add_action( 'woocommerce_checkout_create_order_line_item', 'prefix_checkout_create_order_line_item', 10, 4 );
}

/**
 * Toggle the standard payment method
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.62
 */
if ( 1 == get_theme_mod( 'kls_checkout_default_payment_toggle' ) ) {
	add_filter( 'pre_option_woocommerce_default_gateway', '__return_false', 99 );
}

/**
 * Refresh the carts shipping methods.
 * 
 * @author Joeri van der Stek <joeri@klassebv.nl>
 * 
 * @since 0.1.84
 */
function refresh_shipping_methods()
{
	ob_start();

	WC()->cart->calculate_totals();
	do_action('kls_before_shipping_table');
	?>

	<table>
		<?php if (WC()->cart->needs_shipping() && WC()->cart->show_shipping()): ?>
			<?php do_action('woocommerce_review_order_before_shipping'); ?>

			<?php wc_cart_totals_shipping_html(); ?>

			<?php do_action('woocommerce_review_order_after_shipping'); ?>
		<?php elseif (WC()->cart->needs_shipping() && 'yes' === get_option('woocommerce_enable_shipping_calc')): ?>
			<tr class="shipping">
				<td data-title="<?php esc_attr_e('Shipping', 'klasse-theme'); ?>"><?php woocommerce_shipping_calculator(); ?></td>
			</tr>
		<?php endif; ?>
	</table>
	<?php
	$shipping_html = ob_get_clean();

	echo $shipping_html;
	wp_die();
}

add_action('wp_ajax_refresh_shipping_methods', 'refresh_shipping_methods');
add_action('wp_ajax_nopriv_refresh_shipping_methods', 'refresh_shipping_methods');