<?php
/* File start */
$js_combined[] = 'jQuery(document).ready(function($){';

/**
 * All general scripts
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
require_once __DIR__ . '/general_script.php';

/**
 * All actionbar scripts
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( get_option( 'kls_action_bar_toggle' ) == 'on' ) :
	require_once __DIR__ . '/action_bar_script.php';
endif;

/**
 * All popup scripts
 *
 * @since 0.1.71
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( get_option( 'kls_popup_toggle' ) == 'on' ) :
	require_once __DIR__ . '/popup_script.php';
endif;

/**
 * All navigation scripts
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( get_theme_mod( 'navigation_toggle' ) == '1' ) :
	require_once __DIR__ . '/navigation_script.php';
endif;

/**
 * All mobile navigation scripts
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( get_theme_mod( 'navigation_toggle' ) == '1' ) :
	require_once __DIR__ . '/mobile_navigation_script.php';
endif;

/**
 * All WooCommerce scripts
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ( get_option( 'kls_webshop_toggle' ) == 'on' && class_exists( 'WooCommerce' ) ) :
	require_once __DIR__ . '/woocommerce_script.php';
endif;

/* File end */
$js_combined[] = '});';
