<?php

$js_combined[] = '
jQuery( document ).ready(
	function ($) {
		window.addEventListener(
			"mouseover",
			initCookie,
			{
				once: true
			}
		);
		window.addEventListener(
			"touchstart",
			initCookie,
			{
				once: true
			}
		);
		window.addEventListener(
			"scroll",
			initCookie,
			{
				once: true
			}
		);

		function initCookie() {
			var popupContainer = $("#popup");
			var closedClass = "closed";
			var cookieName = "' . get_option( 'kls_popup_cookie_name', 'popupclosed' ) . '";

			var popupFunction = function () {
				Cookies.set(
					cookieName,
					"1",
					{
						expires: ' . get_option( 'kls_popup_cookie_expiration', '31' ) . ',
						path: "/"
					}
				);
			};

			if (Cookies.get( cookieName ) != "1") {
				popupContainer.removeClass(closedClass).fadeIn( "slow" );
			}

			$( ".popup-close" ).on(
				"click",
				function () {
					popupContainer.addClass(closedClass).fadeOut( "slow" );
					popupFunction();
				}
			);

			$(document).mouseup(function (e) {
				if (!popupContainer.hasClass(closedClass)) {
					var container = $(".popup-container, .popup-close");
					if (!container.is(e.target) && container.has(e.target).length === 0) {
						popupContainer.addClass(closedClass).fadeOut("slow");
						popupFunction();
					}
				}
			});
		}
	}
);
';
