<?php

/**
 * Fixed navigation settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */

$js_combined[] = '
var waitForFinalEventHeader = (function () {
	var timers = {};
	return function (callback, ms, uniqueId) {
		if (!uniqueId) {
			uniqueId = "Dont call this twice without a uniqueId"
		}
		if (timers[uniqueId]) {
			clearTimeout(timers[uniqueId])
		}
		timers[uniqueId] = setTimeout(callback, ms)
	}
})();
';

if ( get_theme_mod( 'fixed_navigation_toggle' ) == 1 && strpos( get_theme_mod( 'main_navigation_background_color' ), 'rgba' ) !== false ) :
	$js_combined[] = '
	$(window).scroll(function() {
		var scroll = $(window).scrollTop();
		if(scroll > 100) {
			$("header").addClass("header-fixed");
		} else {
			$("header").removeClass("header-fixed");
		}
	});';
elseif ( get_theme_mod( 'fixed_navigation_toggle' ) == 1 ) :
	$js_combined[] = '
	$(window).scroll(function() {
		var scroll = $(window).scrollTop();
		if(scroll > 100) {
			$("header").addClass("header-fixed");
		} else {
			$("header").removeClass("header-fixed");
		}
	});';
endif;
if ( get_theme_mod( 'fixed_navigation_toggle' ) == 1 && $GLOBALS['kls_main_navigation_version'] == 'shop-v1' ) :
	if ( is_admin_bar_showing() ) : // [Dev] Todo, remove this to only include styling generated by the customizer and not based on the user. Check every dynamic script/style.
		$js_combined[] = 'var navHeight = $(".top-nav").height() + $(".main-navigation-wrapper").outerHeight() - $("#wpadminbar").height();
		var headerHeight = $("header").height();
		var zeroHeight = 32;
		var headerHeight = headerHeight + 32;
		var navMenuItemsHeight = $("nav.main-nav").height() - ($(".main-navigation-menu-wrapper").height() / 2) + 20;
		var mainNavWrapperHeight = $(".main-navigation-menu-wrapper").outerHeight() + 32;';
	else :
		$js_combined[] = 'var navHeight = $(".top-nav").height() + $(".main-navigation-wrapper").outerHeight();
		var zeroHeight = 0;
		var navMenuItemsHeight = $("nav.main-nav").height() - ($(".main-navigation-menu-wrapper").height() / 2) + 20;
		var mainNavWrapperHeight = $(".main-navigation-menu-wrapper").outerHeight();
		';
	endif;
	$js_combined[] = '
	var position = $(window).scrollTop(); 

	$(window).scroll(function() {
		var scroll = $(window).scrollTop();
		var headerHeight = $("header").height();
		if(scroll > position && scroll > navHeight) {
			$("header").css("top", -navHeight);
			$(".nav-menu").css("margin-bottom", -navMenuItemsHeight);
			$(".before-shop-wrapper").css("top", mainNavWrapperHeight);
			$(".sticky-module").addClass("sticky-module-header-fixed");
			$("header").addClass("header-expanded");
		} else {
			$("header").css("top", zeroHeight);
			$(".nav-menu").css("margin-bottom", "0");
			$(".before-shop-wrapper").css("top", headerHeight);
			$(".sticky-module").removeClass("sticky-module-header-fixed");
			$("header").removeClass("header-expanded");

		}
		position = scroll;
	});
	';
endif;

if ( get_theme_mod( 'fixed_navigation_toggle' ) == 1 && $GLOBALS['kls_main_navigation_version'] == 'shop-v1-search' ) :
	if ( is_admin_bar_showing() ) :
		$js_combined[] = 'var navHeight = $(".top-nav").height() + $(".main-navigation-wrapper").outerHeight() - $("#wpadminbar").height();
		var headerHeight = $("header").height();
		var zeroHeight = 32;
		var headerHeight = headerHeight + 32;
		var navMenuItemsHeight = $("nav.main-nav").height() - ($(".main-navigation-menu-wrapper").height() / 2) - 29;
		var mainNavWrapperHeight = $(".main-navigation-menu-wrapper").outerHeight() + 32;';
	else :
		$js_combined[] = 'var navHeight = $(".top-nav").height() + $(".main-navigation-wrapper").outerHeight();
		var zeroHeight = 0;
		var navMenuItemsHeight = $("nav.main-nav").height() - ($(".main-navigation-menu-wrapper").height() / 2) - 29;
		var mainNavWrapperHeight = $(".main-navigation-menu-wrapper").outerHeight();
		';
	endif;
	$js_combined[] = '
	var position = $(window).scrollTop(); 

	$(window).scroll(function() {
		var scroll = $(window).scrollTop();
		var headerHeight = $("header").height();
		if(scroll > position && scroll > navHeight) {
			$("header").css("top", -navHeight);
			$(".menu-icon-search-container").css("margin-bottom", -navMenuItemsHeight);
			$(".before-shop-wrapper").css("top", mainNavWrapperHeight);
			$(".sticky-module").addClass("sticky-module-header-fixed");
			$("header").addClass("header-expanded");
		} else {
			$("header").css("top", zeroHeight);
			$(".menu-icon-search-container").css("margin-bottom", "0");
			$(".before-shop-wrapper").css("top", headerHeight);
			$(".sticky-module").removeClass("sticky-module-header-fixed");
			$("header").removeClass("header-expanded");
		}
		position = scroll;
	});
	';
endif;
// Standard navigation.
$js_combined[] = '$(".menu-item-has-children a").on("click", function(){$(this).parent().toggleClass("active")});';


// Mega menu script.
$js_combined[] = '
	$(".main-navigation-wrapper").find("li.mega-menu").each(function () {
		var t = $(this),
			e = t.children("ul").children("li").length;
		e < 4 && t.addClass("mega-menu-parent mega-menu-parent-".concat(e))
	});
';

/**
 * Sidebar styling
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.66
 */
if ( get_theme_mod( 'kls_sidebar_navigation_toggle' ) == 1 ) :
	$js_combined[] = '
		$(".sidebar-menu-toggle").on("click", function(){
			$(".menu-sidebar-container").toggleClass("visible");
			$(this).toggleClass("visible");
		});

		$(document).mouseup(function(e){
			var container = $(".menu-sidebar-container, .sidebar-menu-toggle");
			if (!container.is(e.target) && container.has(e.target).length === 0){
				container.removeClass("visible");
			}
		});
	';
endif;
