<?php

/**
 * General navigation settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if (get_theme_mod('fixed_navigation_toggle') == 1):
	$css_combined[] = 'header{position: fixed;top: 0;width: 100%;z-index: 1000;}';
else:
	$css_combined[] = 'header{position: relative;z-index: 1000;}';
endif;
// Search settings
if (get_theme_mod('search_toggle') == '1'):
	$css_combined[] = '.menu-search:not(.mobile-search){margin-left: 20px;}
	.menu-search:not(.mobile-search) i{color:' . get_theme_mod('navigation_item_color') . '; transition:.2s;}
	header.header-fixed .menu-search i{color:' . get_theme_mod('navigation_fixed_item_color') . ';}
	.menu-search-form-wrapper .search-wrapper { border-bottom: 2px solid ' . get_theme_mod('navigation_sub_item_border_color') . '; }
	';
endif;

/**
 * Top navigation settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if (get_theme_mod('top_navigation_toggle') == '1'):
	$css_combined[] = '
	header .top-navigation-wrapper {max-width:' . get_theme_mod('content_max_width') . ';}
	header .top-nav{background-color:' . get_theme_mod('top_navigation_background_color') . ';transition:.2s;}
	header .top-navigation-wrapper a, header .top-nav-contact, header .top-nav-slogan, header .top-nav-button{color:' . get_theme_mod('top_navigation_item_color') . ' !important;transition:.2s;} 
	header.header-fixed .top-navigation-wrapper a, header.header-fixed .top-nav-contact, header.header-fixed .top-nav-slogan, header.header-fixed .top-nav-button{color:' . get_theme_mod('top_navigation_fixed_item_color') . ';} 
	header .top-navigation-wrapper li.current_page_item>a{color:' . get_theme_mod('top_navigation_item_active_color') . ';} 
	@media(hover:hover) and (pointer:fine){
		header .top-navigation-wrapper li:hover>a, header .top-navigation-wrapper a:hover{color:' . get_theme_mod('top_navigation_item_hover_color') . ' !important;}
	}
	header .top-navigation-wrapper {font-size:' . get_theme_mod('top_navigation_font_size') . ';} 
	header .top-nav-usps li,
	header .top-nav .kls-rating .kls-rating-number{color:' . get_theme_mod('top_navigation_item_color') . ';}
	';
endif;

/**
 * Main navigation settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if (get_theme_mod('main_navigation_toggle') == '1'):
	$css_combined[] = '
	header .main-navigation-wrapper {max-width:' . get_theme_mod('content_max_width') . ';}
	header nav{background-color:' . get_theme_mod('main_navigation_background_color') . ';}
	header .main-nav ul:not(.sub-menu)>li:not(.mini_cart_item):not(.menu-button)>a{color:' . get_theme_mod('navigation_item_color') . ';} 
	header.header-fixed .main-nav ul:not(.sub-menu)>li:not(.mini_cart_item):not(.menu-button)>a{color:' . get_theme_mod('navigation_fixed_item_color') . ';} 
	header .main-nav li.current_page_item:not(.menu-button)>a{color:' . get_theme_mod('navigation_item_active_color') . ' !important;}
	@media(hover:hover) and (pointer:fine){
		header .main-nav ul:not(.sub-menu)>li:not(.mini_cart_item):not(.menu-button)>a:hover{color:' . get_theme_mod('navigation_item_hover_color') . ';}
	}
	header .main-nav {
		font-size:' . get_theme_mod('main_navigation_font_size') . '; 
		font-weight:' . get_theme_mod('main_navigation_font_weight', '500') . ';
		text-transform:' . get_theme_mod('kls_main_navigation_text_transform', 'none') . ';
		line-height:' . get_theme_mod('kls_main_navigation_line_height', '1.7em') . ';
	} 
	header .nav-menu>div, header .nav-menu>ul{display: inline-block;}
	header .nav-menu i {font-size:' . get_theme_mod('main_navigation_icon_font_size') . ';}';
	if ($GLOBALS['kls_main_navigation_version'] != 'shop-v1' || $GLOBALS['kls_main_navigation_version'] != 'shop-v2'):
		$css_combined[] = '
		nav .main-navigation-wrapper{padding-top:' . get_theme_mod('main_navigation_padding_size') . ';padding-bottom:' . get_theme_mod('main_navigation_padding_size') . '}
		.header-fixed nav .main-navigation-wrapper{padding-top:' . get_theme_mod('main_navigation_fixed_padding_size') . ';padding-bottom:' . get_theme_mod('main_navigation_fixed_padding_size') . '}
		';
	endif;
	if ($GLOBALS['kls_main_navigation_version'] == 'shop-v1' || $GLOBALS['kls_main_navigation_version'] == 'shop-v1-search'):
		$css_combined[] = '
		header .main-navigation-menu-wrapper {max-width:' . get_theme_mod('content_max_width') . ';}
		';
	elseif ($GLOBALS['kls_main_navigation_version'] == 'shop-v2'):
		$css_combined[] = '
		header .main-navigation-menu-wrapper {max-width:' . get_theme_mod('content_max_width') . ';}
		header .nav-menu i {color:' . get_theme_mod('mobile_bottom_bar_icons_color') . ';}
		@media(max-width:' . get_theme_mod('navigation_breakpoint') . '){
			nav .main-navigation-wrapper{align-items: center !important;}
		}
		@media(max-width:450px){
			nav .logo {max-width: 100px !important;margin-right: 0 !important;}
		}
		';
	elseif ($GLOBALS['kls_main_navigation_version'] == 'shop-v3'):
		$css_combined[] = '
			header .search-wrapper input,
			header .search-wrapper button,
			header .autocomplete-suggestions{color:' . get_theme_mod('main_navigation_background_color') . ';} 
			header .search-wrapper input::placeholder{color:' . get_theme_mod('main_navigation_background_color') . ';} 
			header .search-wrapper input::-ms-input-placeholder{color:' . get_theme_mod('main_navigation_background_color') . ';} 

			header .main-navigation-menu-wrapper {max-width:' . get_theme_mod('content_max_width') . ';}
			header .nav-menu i {color:' . get_theme_mod('mobile_bottom_bar_icons_color') . ';}
			@media(max-width:' . get_theme_mod('navigation_breakpoint') . '){
				nav .main-navigation-wrapper{align-items: center !important;}
			}
			@media(max-width:450px){
				nav .logo {max-width: 100px !important;margin-right: 0 !important;}
			}
		';
	elseif ($GLOBALS['kls_main_navigation_version'] == 'shop-v4'):
		$css_combined[] = '
			header .search-wrapper input,
			header .search-wrapper button,
			header .autocomplete-suggestions{color:' . get_theme_mod('top_navigation_background_color') . ';} 
			header .search-wrapper input::placeholder{color:' . get_theme_mod('top_navigation_background_color') . ';} 
			header .search-wrapper input::-ms-input-placeholder{color:' . get_theme_mod('top_navigation_background_color') . ';} 

			header .main-navigation-menu-wrapper {max-width:' . get_theme_mod('content_max_width') . ';}
			header .nav-menu i {color:' . get_theme_mod('mobile_bottom_bar_icons_color') . ';}
			@media(max-width:' . get_theme_mod('navigation_breakpoint') . '){
				nav .main-navigation-wrapper{align-items: center !important;}
			}
			@media(max-width:450px){
				nav .logo {max-width: 100px !important;margin-right: 0 !important;}
			}
		';
	else:
		$css_combined[] = '';
	endif;
	if ($GLOBALS['kls_main_navigation_version'] == 'shop-v2' && $GLOBALS['kls_mobile_navigation_version'] == 'default-v1'):
		$css_combined[] = '@media(max-width:450px){.menu-cart-popup{right:-50px !important;}}'; // Todo, wtf is this?
	endif;
	if ($GLOBALS['kls_mobile_navigation_version'] == 'bottom_bar_shop-v2' && $GLOBALS['kls_mini_cart_style_version'] == 'v1'):
		$css_combined[] = '@media(max-width:' . get_theme_mod('navigation_breakpoint') . '){
			.menu-cart-popup {
				top: auto !important;
				bottom: -webkit-calc(100% + 20px);
				bottom: -moz-calc(100% + 20px);
				bottom: calc(100% + 20px);
			}
		}';
	endif;
	if (get_theme_mod('fixed_navigation_toggle') == 1):
		$css_combined[] = 'header.header-fixed .main-nav{background-color:' . get_theme_mod('main_navigation_scroll_background_color') . ';}';
		$css_combined[] = 'header.header-fixed .top-nav{background-color:' . get_theme_mod('top_navigation_fixed_background_color') . ';}';
	endif;
	if ($GLOBALS['kls_mobile_navigation_version'] == 'default-v1-fullwidth'):
		$css_combined[] = '';
	endif;
endif;

/**
 * Sub menu settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if (get_theme_mod('main_navigation_toggle') == '1' || get_theme_mod('top_navigation_toggle') == '1'):
	$css_combined[] = '
		header .menu-item .sub-menu li a,
		.menu-cart-popup{color:' . get_theme_mod('navigation_sub_item_color') . ' !important}
		header .menu-item .sub-menu li.current_page_item>a{color:' . get_theme_mod('navigation_sub_item_active_color') . ' !important}
		@media(hover:hover) and (pointer:fine){
			header .menu-item .sub-menu li a:hover{color:' . get_theme_mod('navigation_sub_item_hover_color') . ' !important;}
		}
		header .menu-item .sub-menu,
		.menu-cart-popup,
		.menu-search-form-wrapper{background-color:' . get_theme_mod('navigation_sub_item_background_color') . ' !important}
		header .menu-item .sub-menu li:not(:last-child) a,
		header .menu-item.mega-menu>.sub-menu li:last-child>a,
		header .menu-item .sub-menu>li:not(:last-child)>a, header .menu-item.mega-menu-parent>.sub-menu>li>a,
		header .menu-item.mega-menu-parent>.sub-menu>li>a{border-color:' . get_theme_mod('navigation_sub_item_border_color') . '}
		.menu-search-form-wrapper input{color:' . get_theme_mod('navigation_sub_item_color') . ' !important}
	';
endif;

/**
 * General mobile navigation settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
$css_combined[] = '@media (min-width: ' . get_theme_mod('navigation_breakpoint') . '){.mobile-menu{display:none!important;} .sidebar-close{display: none;} .mobile-navigation{display:none!important};}
@media (max-width: ' . get_theme_mod('navigation_breakpoint') . '){
	header{display:none!important;}
	.mobile-menu{display: flex !important;}
	.mobile-menu .mobile-menu-contact, .mobile-menu li a{font-size:' . get_theme_mod('mobile_navigation_font_size') . ';font-weight:' . get_theme_mod('mobile_navigation_font_weight') . ';}
	.mobile-menu .mobile-menu-contact .contact-info-heading{color:' . get_theme_mod('mobile_navigation_contact_title_color') . ';}
	.mobile-menu .mobile-menu-contact a{color:' . get_theme_mod('mobile_navigation_contact_link_color') . ';}
	.mobile-menu .contact-info-heading{font-size:' . get_theme_mod('mobile_navigation_contact_title_font_size') . ';}
	.mobile-menu li a{color:' . get_theme_mod('navigation_item_color') . ';}
	.mobile-menu .mobile-menu-close{color:' . get_theme_mod('navigation_item_color') . ';}
	.mobile-menu li.current_page_item>a{color:' . get_theme_mod('navigation_item_active_color') . ';}
	.mobile-menu {background-color:' . get_theme_mod('mobile_navigation_background_color') . ';}
	.mobile-menu-toggle span{background-color:' . get_theme_mod('mobile_navigation_menu_toggle_color') . ';}
	.mobile-navigation-content-logo{background-color:' . get_theme_mod('mobile_bottom_bar_logo_above_content_background_color') . ';}
	.mobile-navigation{display:block!important;}
	.mobile-navigation-wrapper{max-width:' . get_theme_mod('content_max_width') . ';}
	.mobile-navigation{font-size:' . get_theme_mod('mobile_bottom_bar_icon_font_size') . ';}
	.mobile-navigation{background-color:' . get_theme_mod('mobile_navigation_background_color') . ';}
	.mobile-navigation .menu-item{color:' . get_theme_mod('navigation_item_color') . ';}
	.mobile-navigation .mobile-navigation-item.current-page a{color:' . get_theme_mod('mobile_bottom_bar_icons_active_color') . ';}
	.mobile-navigation .mobile-navigation-item.current-page::after{background-color:' . get_theme_mod('mobile_bottom_bar_icons_active_color') . ';}
	.mobile-navigation .mobile-menu-toggle span{background-color:' . get_theme_mod('mobile_navigation_menu_toggle_color') . ';}
	.menu-button{margin-top: 10px;}
	.menu-hot-label::before {top: -7px !important;font-size: 8px !important;}
	.menu-hot-label::after {top: 5px !important;}
}';

/**
 * Bottom bar settings
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if ($GLOBALS['kls_mobile_navigation_version'] == 'bottom_bar-v1'):
	$css_combined[] = '
	@media (max-width: ' . get_theme_mod('navigation_breakpoint') . '){
		.mobile-navigation .mobile-navigation-item a, .mobile-navigation .mobile-navigation-item i, .mobile-navigation .mobile-navigation-item .item-text{color:' . get_theme_mod('mobile_bottom_bar_icons_color') . ';}
	}';
	// Mobile nav default 1
elseif ($GLOBALS['kls_mobile_navigation_version'] == 'default-v1' || $GLOBALS['kls_mobile_navigation_version'] == 'anytime-v1'):
	$css_combined[] = '
	@media (max-width: ' . get_theme_mod('navigation_breakpoint') . '){
		.mobile-navigation .mobile-navigation-item a, .mobile-navigation .item-text, .mobile-navigation .mobile-navigation-item i, .mobile-navigation .mobile-navigation-item .item-text{color:' . get_theme_mod('mobile_bottom_bar_icons_color') . ';}
	}';
	// Mobile nav bottom bar shop v2
elseif ($GLOBALS['kls_mobile_navigation_version'] == 'bottom_bar_shop-v2'):
	$css_combined[] = '
	@media (max-width: ' . get_theme_mod('navigation_breakpoint') . '){
		.mobile-navigation .mobile-navigation-item a:not(.button), .mobile-navigation .mobile-navigation-item i, .mobile-navigation .mobile-navigation-item .item-text{color:' . get_theme_mod('mobile_bottom_bar_icons_color') . ';}
	}';
endif;

/**
 * Mobile navigation position
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if (get_theme_mod('mobile_navigation_position') == 'bottom'):
	$css_combined[] = '
		.mobile-navigation {bottom: 0;}
		.mobile-search-container form#yith-ajaxsearchform>div{
			bottom: 70px !important;
		}
	';
	if ($GLOBALS['kls_mobile_navigation_version'] == 'bottom_bar-v1'):
		$css_combined[] = '.mobile-search-container .menu-search-form-wrapper {top: calc(-' . (function_exists('get_the_mobile_navigation_height') && get_the_mobile_navigation_height($GLOBALS['kls_mobile_navigation_version']) ? get_the_mobile_navigation_height($GLOBALS['kls_mobile_navigation_version']) : 70) . 'px - 8px)}';
	elseif ($GLOBALS['kls_mobile_navigation_version'] == 'default-v1'):
		$css_combined[] = '.mobile-search-container .menu-search-form-wrapper {top: calc(-' . (function_exists('get_the_mobile_navigation_height') && get_the_mobile_navigation_height($GLOBALS['kls_mobile_navigation_version']) ? get_the_mobile_navigation_height($GLOBALS['kls_mobile_navigation_version']) : 70) . 'px + 2px)}';
	elseif ($GLOBALS['kls_mobile_navigation_version'] == 'bottom_bar_shop-v2'):
		$css_combined[] = '.mobile-search-container .menu-search-form-wrapper {top: calc(-' . (function_exists('get_the_mobile_navigation_height') && get_the_mobile_navigation_height($GLOBALS['kls_mobile_navigation_version']) ? get_the_mobile_navigation_height($GLOBALS['kls_mobile_navigation_version']) : 70) . 'px - 10px)}';
	endif;
else:
	$css_combined[] = '
		.mobile-navigation {top: 0;}
	';
endif;

/**
 * Mobile menu position
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
if (get_theme_mod('mobile_menu_position') == 'right'):
	$css_combined[] = '
		.mobile-menu {right: -400px;}
		.mobile-menu.visible {right: 0;}
		.mobile-menu-close {left: 20px;}
	';
else:
	$css_combined[] = '
		.mobile-menu {left: -400px;}
		.mobile-menu.visible {left: 0;}
		.mobile-menu-close {right: 20px;}
	';
endif;

/**
 * Logo styling
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.15
 */
if (get_theme_mod('kls_logo_height')):
	$css_combined[] = '
		nav .logo {height:' . get_theme_mod('kls_logo_height', '53px') . ';display:flex;align-items:center;}
	';
endif;

/**
 * Mobile logo styling
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.22
 */
if (get_theme_mod('kls_mobile_logo_height')):
	$css_combined[] = '
		.mobile-navigation .logo {height: ' . get_theme_mod('kls_mobile_logo_height', '40px') . '; display: flex; align-items: center;}
	';
endif;

/**
 * Sidebar styling
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.66
 */
if (get_theme_mod('kls_sidebar_navigation_toggle') == 1):
	$css_combined[] = '
		.menu-sidebar-container {
			background-color: ' . get_theme_mod('kls_sidebar_navigation_background_color', '#ffffff') . ';
		}
		.menu-sidebar-container,
		.menu-sidebar-container a {
			color: ' . get_theme_mod('kls_sidebar_navigation_text_color', '#222222') . ';
		}

		.menu-sidebar-container .menu-sidebar-menu-wrapper li {
			border-left: 4px solid ' . get_theme_mod('kls_sidebar_navigation_background_color', '#ffffff') . ';
		}

		.menu-sidebar-container .menu-sidebar-menu-wrapper li.is-active {
			background-color: ' . get_theme_mod('kls_sidebar_navigation_text_color', '#222222') . ';
		}
		.menu-sidebar-container .menu-sidebar-menu-wrapper li.is-active a {
			color: ' . get_theme_mod('kls_sidebar_navigation_background_color', '#ffffff') . ';
		}

		.sidebar-menu-toggle {display: none;}

		@media(max-width:' . get_theme_mod('navigation_breakpoint') . '){
			header{
				display: block !important;
			}

			.main-nav {
				display: none !important;
			}

			html body #et-boc, footer:not(.et-l) {
				margin-left: 0 !important;
			}

			.menu-sidebar-container:not(.visible) {
				left: -200px;
			}
			

			.sidebar-menu-toggle {
				display: block;
				color: ' . get_theme_mod('kls_sidebar_navigation_text_color', '#222222') . ';
				position: absolute;
				bottom: 30px;
				right: -33px;
				background: ' . get_theme_mod('kls_sidebar_navigation_background_color', '#ffffff') . ';
				padding: 9px 12px;
				line-height: 1em;
				transition: .2s !important;
			}

			.sidebar-menu-toggle.visible i {
				transform: rotate(180deg);
			}
		}
	';
endif;

/**
 * Sidemenu styling
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.66
 */
if (get_theme_mod('kls_sidemenu_navigation_toggle') == 1):
	$css_combined[] = '
	.navigation-sidemenu .navigation-sidemenu-content {
		max-width: ' . get_theme_mod('kls_sidemenu_width', '500px') . ' !important;
		left: -' . get_theme_mod('kls_sidemenu_width', '500px') . ' !important;
	}

	.navigation-sidemenu .navigation-sidemenu-content,
	header .menu-item .sub-menu {
		background-color: ' . get_theme_mod('kls_sidemenu_background_color', '#ffffff') . ' !important;
	}
	
	.navigation-sidemenu .navigation-sidemenu-content,
	.navigation-sidemenu .navigation-sidemenu-content .sub-menu a,
	.navigation-sidemenu .navigation-sidemenu-content a {
		color: ' . get_theme_mod('kls_sidemenu_text_color', '#000000') . ' !important;
		line-height: ' . get_theme_mod('kls_sidemenu_line_height', '1.3em') . ' !important;
		text-transform: ' . get_theme_mod('kls_sidemenu_text_transform', 'none') . ' !important;
	}

	.navigation-sidemenu .navigation-sidemenu-content,
	.navigation-sidemenu .navigation-sidemenu-content a {
		font-size: ' . get_theme_mod('kls_sidemenu_font_size', '16px') . ' !important;
		font-weight: ' . get_theme_mod('kls_sidemenu_font_weight', '400') . ' !important;
	}

	.navigation-sidemenu .navigation-sidemenu-content .sub-menu a {
		font-size: ' . get_theme_mod('kls_sidemenu_submenu_font_size', '16px') . ' !important;
		font-weight: ' . get_theme_mod('kls_sidemenu_submenu_font_weight', '400') . ' !important;
	}

	.main-navigation-wrapper .nav-toggle-sidemenu:not(.theme-button) {
		color: ' . get_theme_mod('kls_sidemenu_hamburger_color', '#000000') . ' !important;
	}

	@media (hover:hover) and (pointer:fine){
		.navigation-sidemenu .navigation-sidemenu-content .nav-toggle-sidemenu:hover,
		.navigation-sidemenu .navigation-sidemenu-content .sub-menu a:hover,
		.navigation-sidemenu .navigation-sidemenu-content a:hover {
			color: ' . get_theme_mod('kls_sidemenu_text_hover_color', '#000000') . ' !important;
		}
	}
	';
endif;
