<?php

/**
 * Label settings
 *
 * @since 0.1.79
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 * 
 * Todo, styling doesn't work yet with select dropdown.
 * Todo, Gravity Form select height should be calculated better.
 */
$background_image_url = "data:image/svg+xml,%3Csvg width='10' height='6' viewBox='0 0 10 6' fill='none' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath fill-rule='evenodd' clip-rule='evenodd' d='M0.292893 0.292893C0.683417 -0.097631 1.31658 -0.097631 1.70711 0.292893L5 3.58579L8.29289 0.292893C8.68342 -0.0976311 9.31658 -0.0976311 9.70711 0.292893C10.0976 0.683417 10.0976 1.31658 9.70711 1.70711L5.70711 5.70711C5.31658 6.09763 4.68342 6.09763 4.29289 5.70711L0.292893 1.70711C-0.0976311 1.31658 -0.0976311 0.683418 0.292893 0.292893Z' fill='" . get_theme_mod('kls_form_input_color', get_theme_mod('body_text_color')) . ") '/%3E%3C/svg%3E";
$css_combined[] = '
	.nf-field-label .nf-label-span,
	.nf-field-label label,
	.gfield_label {
		color: ' . get_theme_mod('kls_form_label_color', get_theme_mod('body_text_color')) . ' !important;
		font-size: ' . get_theme_mod('kls_form_label_font_size', '18px') . ' !important;
		font-weight: ' . get_theme_mod('kls_form_label_font_weight', 'bold') . ' !important;
		letter-spacing: ' . get_theme_mod('kls_form_label_letter_spacing', '0px') . ' !important;
		line-height: ' . get_theme_mod('kls_form_label_line_height', '20px') . ' !important;
		text-transform: ' . get_theme_mod('kls_form_label_text_transform', 'none') . ' !important;
		margin-bottom: 5px !important;
	}

	.nf-field-element input:not([type="button"]):not([type="submit"]):not([type="radio"]):not([type="checkbox"]), 
	.nf-field-element select, 
	.nf-field-element textarea,
	.gfield input:not([type="button"]):not([type="submit"]):not([type="radio"]):not([type="checkbox"]),
	.gfield select,
	.gfield textarea {
		width: 100% !important;
		padding: ' . get_theme_mod('kls_form_input_padding', '10px') . ' !important;
		color: ' . get_theme_mod('kls_form_input_color', get_theme_mod('body_text_color')) . ' !important;
		background-color: ' . get_theme_mod('kls_form_input_background_color', '#f7f7f7') . ' !important;
		border: ' . get_theme_mod('kls_form_input_border_size', '1px') . ' solid ' . get_theme_mod('kls_form_input_border_color', '#eeeeee') . ' !important;
		box-sizing: border-box !important;
		-webkit-box-sizing: border-box !important;
		-moz-box-sizing: border-box !important;
		border-radius:' . get_theme_mod('kls_form_input_border_radius', '5px') . ' !important;
		-webkit-border-radius:' . get_theme_mod('kls_form_input_border_radius', '5px') . ' !important;
		-moz-border-radius:' . get_theme_mod('kls_form_input_border_radius', '5px') . ' !important;
		-ms-border-radius:' . get_theme_mod('kls_form_input_border_radius', '5px') . ' !important;
		-o-border-radius:' . get_theme_mod('kls_form_input_border_radius', '5px') . ' !important;
		font-size: ' . get_theme_mod('kls_form_input_font_size', '14px') . ' !important;
		font-weight: ' . get_theme_mod('kls_form_input_font_weight', 'normal') . ' !important;
		letter-spacing: ' . get_theme_mod('kls_form_input_letter_spacing', '0px') . ' !important;
		text-transform: ' . get_theme_mod('kls_form_input_text_transform', 'none') . ' !important;
		line-height: ' . get_theme_mod('kls_form_input_line_height', '1.7em') . ' !important;
		-webkit-appearance: none;
		box-shadow: none !important;
	}
	
	.gfield select {
		height: calc(' . get_theme_mod('kls_form_input_line_height', '1.7em') . ' + ' . get_theme_mod('kls_form_input_border_size', '1px') . ' + ' . get_theme_mod('kls_form_input_border_size', '1px') . ' + ' . get_theme_mod('kls_form_input_padding', '10px') . ' + ' . get_theme_mod('kls_form_input_padding', '10px') . ') !important;
	}

	.nf-field-element select {
		height: auto !important;
	}

	.list-select-wrap .nf-field-element > div:after,
	.nf-form-content .list-select-wrap .nf-field-element>div {
		color: ' . get_theme_mod('kls_form_input_color', get_theme_mod('body_text_color')) . ' !important;
		background-color: ' . get_theme_mod('kls_form_input_background_color', '#f7f7f7') . ' !important;
		border: 0 !important;
	}
	.nf-field-element textarea::-webkit-input-placeholder,
	.nf-field-element input:not([type="button"]):not([type="submit"]):not([type="radio"]):not([type="checkbox"])::-webkit-input-placeholder {
    	color: ' . get_theme_mod('kls_form_input_placeholder_color', get_theme_mod('body_text_color')) . ' !important;
	}
	.nf-field-element textarea:-moz-placeholder,
	.nf-field-element input:not([type="button"]):not([type="submit"]):not([type="radio"]):not([type="checkbox"]):-moz-placeholder {
    	color: ' . get_theme_mod('kls_form_input_placeholder_color', get_theme_mod('body_text_color')) . ' !important;
		opacity: 1;
	}
	.nf-field-element textarea::-moz-placeholder ,
	.nf-field-element input:not([type="button"]):not([type="submit"]):not([type="radio"]):not([type="checkbox"])::-moz-placeholder {
    	color: ' . get_theme_mod('kls_form_input_placeholder_color', get_theme_mod('body_text_color')) . ' !important;
		opacity: 1;
	}
	.nf-field-element textarea:-ms-input-placeholder,
	.nf-field-element input:not([type="button"]):not([type="submit"]):not([type="radio"]):not([type="checkbox"]):-ms-input-placeholder {
    	color: ' . get_theme_mod('kls_form_input_placeholder_color', get_theme_mod('body_text_color')) . ' !important;
	}
	.nf-field-element textarea::-ms-input-placeholder,
	.nf-field-element input:not([type="button"]):not([type="submit"]):not([type="radio"]):not([type="checkbox"])::-ms-input-placeholder {
    	color: ' . get_theme_mod('kls_form_input_placeholder_color', get_theme_mod('body_text_color')) . ' !important;
	}
	.nf-field-element textarea::placeholder,
	.nf-field-element input:not([type="button"]):not([type="submit"]):not([type="radio"]):not([type="checkbox"])::placeholder {
    	color: ' . get_theme_mod('kls_form_input_placeholder_color', get_theme_mod('body_text_color')) . ' !important;
	}

	.gform_required_legend {
		display: none !important;
	}

	.gform-theme--api, .gform-theme--foundation {
		--gf-form-gap-y: ' . get_theme_mod('kls_form_input_margin_bottom', '20px') . ' !important;
		--gform-theme-form-row-gap: ' . get_theme_mod('kls_form_input_margin_bottom', '20px') . ' !important;
	}

	.gform-theme--framework select:where(:not(.gform-theme__disable):not(.gform-theme__disable *):not(.gform-theme__disable-framework):not(.gform-theme__disable-framework *)):where(:not([multiple])){
		background-image: url("' . $background_image_url . '") !important;
	}
}
';

if (get_theme_mod('kls_form_label_toggleable_label', 0) == 1) {
	$css_combined[] = '
	.gfield {
		position: relative !important;
	}
	label.gfield_label {
		position: absolute !important;
		left: 20px;
		font-size: 14px !important;
		top: 12px !important;
		-webkit-transition: .2s !important;
		-o-transition: .2s !important;
		-moz-transition: .2s !important;
		transition: .2s !important;
	}

	label.gfield_label.toggle {
		top: -25px !important;
		font-size: 12px !important;
	}';
}