<?php

/**
 * Product slider shortcode
 *
 * @since 0.0.35
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_product_slider( $atts ) {
	// Extract shortcode attributes.
	extract(
		shortcode_atts(
			array(
				'orderby' => null,
				'order'   => null,
			),
			$atts
		)
	);
	ob_start();
	get_template_part(
		'/template-parts/shortcodes/product-slider',
		null,
		array(
			'orderby' => $orderby,
			'order'   => $order,
		)
	);
	return ob_get_clean();
}
add_shortcode( 'product_slider', 'kls_product_slider' );

/**
 * Category slider shortcode
 *
 * @since 0.0.35
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_category_slider( $atts ) {
	 // Extract shortcode attributes.
	extract(
		shortcode_atts(
			array(
				'exclude_id' => null,
				'include_id' => null,
				'hide_empty' => null,
				'orderby'    => null,
				'order'      => null,
			),
			$atts
		)
	);
	$exclude_id = explode( ',', $exclude_id );
	ob_start();
	get_template_part(
		'/template-parts/shortcodes/category-slider',
		null,
		array(
			'exclude_id' => $exclude_id,
			'include_id' => $exclude_id,
			'hide_empty' => $hide_empty,
			'orderby'    => $orderby,
			'order'      => $order,
		)
	);
	return ob_get_clean();
}
add_shortcode( 'category_slider', 'kls_category_slider' );

/**
 * Product slider shortcode
 *
 * @since 0.1.04
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_category_block_layout( $atts ) {
	// Extract shortcode attributes.
	extract(
		shortcode_atts(
			array(
				'exclude_id' => null,
				'include_id' => null,
				'hide_empty' => null,
				'orderby'    => null,
				'order'      => null,
				'layout'     => null,
				'maximum'    => '5',
			),
			$atts
		)
	);
	$exclude_id = explode( ',', $exclude_id );
	ob_start();
	get_template_part(
		'/template-parts/shortcodes/category-block-layout',
		null,
		array(
			'exclude_id' => $exclude_id,
			'include_id' => $exclude_id,
			'hide_empty' => $hide_empty,
			'orderby'    => $orderby,
			'order'      => $order,
			'layout'     => $layout,
			'maximum'    => $maximum,
		)
	);
	return ob_get_clean();
}
add_shortcode( 'category_block_layout', 'kls_category_block_layout' );

/**
 * Product block shortcode
 *
 * @since 0.1.49
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_product_block( $atts ) {
	// Extract shortcode attributes.
	extract(
		shortcode_atts(
			array(
				'orderby' => null,
				'order'   => null,
				'maximum' => '4',
			),
			$atts
		)
	);
	ob_start();
	get_template_part(
		'/template-parts/shortcodes/product-block',
		null,
		array(
			'orderby' => $orderby,
			'order'   => $order,
			'maximum' => $maximum,
		)
	);
	return ob_get_clean();
}
add_shortcode( 'product_block', 'kls_product_block' );

/**
 * Product slider shortcode
 *
 * @since 0.1.49
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_product_slider_small( $atts ) {
	// Extract shortcode attributes.
	extract(
		shortcode_atts(
			array(
				'exclude_id' => null,
				'orderby'    => null,
				'order'      => null,
				'maximum'    => '10',
			),
			$atts
		)
	);
	$exclude_id = explode( ',', $exclude_id );
	ob_start();
	get_template_part(
		'/template-parts/shortcodes/product-slider-small',
		null,
		array(
			'orderby'    => $orderby,
			'order'      => $order,
			'exclude_id' => $exclude_id,
			'maximum'    => $maximum,
		)
	);
	return ob_get_clean();
}
add_shortcode( 'product_slider_small', 'kls_product_slider_small' );

/**
 * Product slider page shortcode
 *
 * @since 0.1.58
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_product_slider_page( $atts ) {
	// Extract shortcode attributes.
	extract(
		shortcode_atts(
			array(
				'orderby' => null,
				'order'   => null,
			),
			$atts
		)
	);
	ob_start();
	get_template_part(
		'/template-parts/shortcodes/product-slider-page',
		null,
		array(
			'orderby' => $orderby,
			'order'   => $order,
		)
	);
	return ob_get_clean();
}
add_shortcode( 'product_slider_page', 'kls_product_slider_page' );

/**
 * Button shortcode
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.51
 *
 * [Dev] Todo, add position & full width option.
 */
function kls_button_shortcode( $atts ) {
	$website = (is_ssl() ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'];

	$text = isset($atts['text']) ? $atts['text'] : null;
	$styling = isset($atts['styling']) ? $atts['styling'] : 'primary';
	$url = isset($atts['url']) ? str_replace('{current_website}', $website, $atts['url']) : '#';
	$target = isset($atts['target']) ? 'target="'. $atts['target'] . '"' : null;
	$rel = isset($atts['rel']) ? 'rel="' . $atts['rel'] . '"' : null;
	$classes = isset($atts['class']) ? $atts['class'] : '';

	$data_output = '';
	foreach ($atts as $key => $value) {
		if (strpos($key, 'data-') === 0) {
			$data_output .= $key . '="' . $value . '"';
		}
	}

	return '<a class="theme-button theme-button-' . $styling . ' ' . $classes . '" href="' . $url . '" ' . $target . $rel . $data_output . '>' . $text . '</a>';
}
add_shortcode( 'theme_button', 'kls_button_shortcode' );

/**
 * WooCommerce payment methods icons shortcode
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.65
 *
 * [Dev] Todo, fix the shortcode.
 */
// function kls_payment_methods_icons_shortcode() {
// if ( ! empty( WC()->payment_gateways()->payment_gateways() )) {
// foreach ( WC()->payment_gateways()->payment_gateways() as $gateway ) {
// if ( 'yes' == $gateway->enabled ) {
// echo $gateway->get_icon();
// }
// }
// }
// }
// add_shortcode( 'betaalmethodes_iconen', 'kls_payment_methods_icons_shortcode' );

/**
 * Lost Password link
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.65
 */
function kls_add_lost_password_link() {
	return '<a href="/wp-login.php?action=lostpassword" class="password-reset-button button-link">' . esc_html__( 'Lost your password?', 'klasse-theme' ) . '</a>';
}
add_action( 'login_form_middle', 'kls_add_lost_password_link' );

/**
 * Login form shortcode
 *
 * @param mixed $atts Attributes from the shortcode.
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 *
 * @since 0.1.65
 */
function kls_login_form( $atts ) {
	$args = shortcode_atts(
		array(
			'redirect_url' => null,
		),
		$atts
	);

	if ( isset( $args['redirect_url'] ) && null !== $args['redirect_url'] ) {
		$redirect = $args['redirect_url'];
	} else {
		$redirect = ( is_ssl() ? 'https://' : 'http://' ) . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
	}

	if ( ! is_user_logged_in() ) {
		$args = array(
			'echo'           => false,
			'remember'       => true,
			'redirect'       => $redirect,
			'form_id'        => 'kls-login_form',
			'id_username'    => 'user_login',
			'id_password'    => 'user_pass',
			'id_remember'    => 'rememberme',
			'id_submit'      => 'wp-submit',
			'label_username' => esc_html__( 'Username or email address', 'klasse-theme' ),
			'label_password' => esc_html__( 'Password', 'klasse-theme' ),
			'label_remember' => esc_html__( 'Remember me', 'klasse-theme' ),
			'label_log_in'   => esc_html__( 'Log in', 'klasse-theme' ),
			'value_username' => '',
			'value_remember' => false,
		);
		kls_add_lost_password_link();
		return wp_login_form( $args );
	} else {
		return '<div id="kls-login_form" class="logout">' . wp_loginout( home_url(), false ) . '</div>';
	}
}
add_shortcode( 'login_form', 'kls_login_form' );
