<?php // phpcs:ignore
/**
 * Popup class
 *
 * @category   Klasse_Theme
 * @package    KT
 * @subpackage KT/public/includes/popup
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.71
 * Todo,
 * - Schedule feature.
 * - Multiple layouts.
 * - Change layout to Divi layout.
 * - Add an option to show or hide the popup on specific post types/categories.
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'KT_Popup' ) ) {
	/**
	 * Popup class
	 *
	 * @category    Klasse_Theme
	 * @package     KT
	 * @subpackage  KT/public/includes/popup
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.71
	 */
	class KT_Popup {

		/**
		 * Construct the popup.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.71
		 */
		public function __construct() {
			 add_action( 'wp_footer', array( $this, 'createPopup' ) );
			add_action( 'wp_enqueue_scripts', array( $this, 'enqueueScripts' ) );
		}

		public function enqueueScripts() {
			wp_enqueue_script( 'kls_cookie_script_js', get_template_directory_uri() . '/public/js/js.cookie.min.js', array( 'jquery' ), $GLOBALS['kls_theme_version'], true );
			wp_enqueue_style( 'kls_popup', KT_ASSETS_PATH_PUBLIC_STYLES . 'popup/popup.css', false, $GLOBALS['kls_theme_version'] );
		}

		public function createPopup() {
			?>
			<div id="popup" class="closed" style="display: none">
				<div class="popup-container">
					<div class="theme-row theme-row-full-width">
						<div class="theme-col theme-col-6 popup-text-container">
							<div class="popup-title"><h2><?php echo get_option( 'kls_popup_title' ); ?></h2></div>
							<div class="popup-text"><?php echo get_option( 'kls_popup_text' ); ?></div>
							<div class="popup-cta">
								<?php
								if ( get_option( 'kls_popup_cta_method' ) == 'form' ) {
									echo do_shortcode( get_option( 'kls_popup_form_shortcode' ) );
								} elseif ( get_option( 'kls_popup_cta_method' ) == 'buttoncta' ) {
									?>
									<a href="<?php echo get_option( 'kls_popup_button_url' ); ?>" class="theme-button theme-button-primary"><?php echo get_option( 'kls_popup_button_text' ); ?></a>
									<?php
								}
								?>
							</div>
						</div>
						<div class="theme-col theme-col-6 popup-image" style="background-image: url('<?php echo wp_get_attachment_image_url( get_option( 'kls_popup_image' ), 'full' ); ?>'); background-repeat: no-repeat; background-size: cover;background-position: center;">
						</div>
					</div>
					<div class="popup-close">
						<i class="fas fa-times"></i>
					</div>
				</div>
			</div>
			<?php
		}
	}

	new KT_Popup();
}
