<?php // phpcs:ignore
/**
 * FAQ post type class
 *
 * @category   Klasse_Theme
 * @package    KT
 * @subpackage KT/includes/faq
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.79
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('KT_Faq_Post_Type')) {
	/**
	 * FAQ post type class
	 *
	 * @category    Klasse_Theme
	 * @package     KT
	 * @subpackage  KT/includes/faq
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.79
	 */
	class KT_Faq_Post_Type
	{
		/**
		 * Construct the FAQ post type.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.79
		 */
		public function __construct()
		{
			add_action('init', array($this, 'faqPostType'), 0);
			add_action('init', array($this, 'faqCategoryTaxonomy'), 0);

			add_action('faq_category_add_form_fields', array($this, 'add_faq_category_icon_field'), 10, 2);
			add_action('faq_category_edit_form_fields', array($this, 'edit_faq_category_icon_field'), 10, 2);

			add_action('edited_faq_category', array($this, 'save_faq_category_icon_field'), 10, 2);
			add_action('create_faq_category', array($this, 'save_faq_category_icon_field'), 10, 2);
		}

		public function faqPostType()
		{
			$labels = array(
				'name' => _x('FAQs', 'Post Type General Name', 'klasse-theme'),
				'singular_name' => _x('FAQ', 'Post Type Singular Name', 'klasse-theme'),
				'menu_name' => __('FAQ', 'klasse-theme'),
				'parent_item_colon' => __('Parent FAQ', 'klasse-theme'),
				'all_items' => __('All FAQs', 'klasse-theme'),
				'view_item' => __('View FAQ', 'klasse-theme'),
				'add_new_item' => __('Add New FAQ', 'klasse-theme'),
				'add_new' => __('Add New', 'klasse-theme'),
				'edit_item' => __('Edit FAQ', 'klasse-theme'),
				'update_item' => __('Update FAQ', 'klasse-theme'),
				'search_items' => __('Search FAQ', 'klasse-theme'),
				'not_found' => __('Not Found', 'klasse-theme'),
				'not_found_in_trash' => __('Not found in Trash', 'klasse-theme'),
			);

			$args = array(
				'label' => __('faq', 'klasse-theme'),
				'description' => __('Frequently Asked Questions', 'klasse-theme'),
				'labels' => $labels,
				'supports' => array('title', 'editor', 'author', 'revisions'),
				'taxonomies' => array('tags', 'faq_category'),
				'hierarchical' => false,
				'public' => false,
				'show_ui' => true,
				'show_in_menu' => true,
				'show_in_nav_menus' => true,
				'show_in_admin_bar' => true,
				'menu_position' => 5,
				'can_export' => true,
				'has_archive' => false,
				'exclude_from_search' => true,
				'publicly_queryable' => false,
				'capability_type' => 'post',
				'show_in_rest' => true,
			);

			// Registering your Custom Post Type
			register_post_type('faq', $args);
		}

		public function faqCategoryTaxonomy()
		{
			$labels = array(
				'name' => _x('Categories', 'taxonomy general name'),
				'singular_name' => _x('Category', 'taxonomy singular name'),
				'search_items' => __('Search Categories'),
				'all_items' => __('All Categories'),
				'parent_item' => __('Parent Category'),
				'parent_item_colon' => __('Parent Category:'),
				'edit_item' => __('Edit Category'),
				'update_item' => __('Update Category'),
				'add_new_item' => __('Add New Category'),
				'new_item_name' => __('New Category Name'),
				'menu_name' => __('Categories'),
			);

			// Now register the taxonomy
			register_taxonomy(
				'faq_category',
				array('faq'),
				array(
					'hierarchical' => true,
					'labels' => $labels,
					'show_ui' => true,
					'show_in_rest' => true,
					'show_admin_column' => true,
					'query_var' => true,
					'rewrite' => array('slug' => 'faq_category'),
				)
			);
		}

		public function add_faq_category_icon_field()
		{
			?>
			<div class="form-field">
				<label for="faq-category-icon">
					<?php _e('Icon', 'klasse-theme'); ?>
				</label>
				<input type="text" name="faq-category-icon" id="faq-category-icon" value="">
				<p class="description">
					<?php _e('Enter the full Font Awesome 5 icon class here.', 'klasse-theme'); ?>
				</p>
			</div>
			<?php
		}

		public function edit_faq_category_icon_field($term)
		{
			$icon = get_term_meta($term->term_id, 'faq-category-icon', true);
			?>
			<tr class="form-field">
				<th scope="row"><label for="faq-category-icon">
						<?php _e('Icon', 'klasse-theme'); ?>
					</label></th>
				<td>
					<input type="text" name="faq-category-icon" id="faq-category-icon" value="<?php echo esc_attr($icon); ?>">
					<p class="description">
						<?php _e('Enter the full Font Awesome 5 icon class here.', 'klasse-theme'); ?>
					</p>
				</td>
			</tr>
			<?php
		}

		public function save_faq_category_icon_field($term_id)
		{
			if (isset($_POST['faq-category-icon'])) {
				update_term_meta($term_id, 'faq-category-icon', sanitize_text_field($_POST['faq-category-icon']));
			}
		}
	}

	new KT_Faq_Post_Type();
}