<?php // phpcs:ignore
/**
 * FAQ Module class
 *
 * @category   Klasse_Theme
 * @package    KT
 * @subpackage KT/includes/faq
 *
 * @author  Joeri van der Stek <joeri@klassebv.nl>
 * @license GPLV2 https://www.gnu.org/licenses/gpl-2.0.html
 * @link    https://klassebv.nl/
 * @since   0.1.79
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('KT_Faq_Module')) {
	/**
	 * FAQ Module class
	 *
	 * @category    Klasse_Theme
	 * @package     KT
	 * @subpackage  KT/includes/faq
	 *
	 * @author  Joeri van der Stek <joeri@klassebv.nl>
	 * @license GPLV3 http://www.gnu.org/licenses/gpl-3.0.html
	 * @link    https://klassebv.nl
	 * @since   0.1.79
	 */
	class KT_Faq_Module
	{
		/**
		 * Construct the FAQ Module.
		 *
		 * @author Joeri van der Stek <joeri@klassebv.nl>
		 *
		 * @since 0.1.79
		 */
		public function __construct()
		{
			require_once __DIR__ . '/faq_post_type.class.php';
			require_once __DIR__ . '/faq_shortcodes.class.php';

			add_action('wp_enqueue_scripts', array($this, 'registerStylesAndScripts'));
		}

		public function registerStylesAndScripts()
		{
			wp_register_style('kls_faq_module_style', KT_ASSETS_PATH_PUBLIC_STYLES . 'faq/faq.css', array(), $GLOBALS['kls_theme_version'], 'all');
			wp_register_script('kls_faq_module_script', KT_ASSETS_PATH_PUBLIC_SCRIPTS . 'faq/faq.js', false, $GLOBALS['kls_theme_version']);

			wp_localize_script('kls_faq_module_script', 'custom_search', array(
				'ajax_url' => admin_url('admin-ajax.php')
			)
			);
		}
	}

	new KT_Faq_Module();
}