<?php

/**
 * Create wishlist page settings & controls
 *
 * @since 0.0.12
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_wishlist_woocommerce_settings_controls( $wp_customize ) {
	// Seperator
	$wp_customize->add_setting(
		'wishlist_toggles_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'wishlist_toggles_title',
			array(
				'priority' => 0,
				'section'  => 'wishlist_woocommerce_options',
				'label'    => __( 'Toggleable items', 'klasse-theme' ),
			)
		)
	);

	// Toggle recently viewed products
	$wp_customize->add_setting(
		'wishlist_recently_viewed_products_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'wishlist_recently_viewed_products_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'wishlist_woocommerce_options',
			'label'    => __( 'Toggle recently viewed products', 'klasse-theme' ),
		)
	);

	// Toggle recently viewed products
	$wp_customize->add_setting(
		'wishlist_stock_status_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'wishlist_stock_status_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'wishlist_woocommerce_options',
			'label'    => __( 'Toggle stock status', 'klasse-theme' ),
		)
	);

	// Seperator
	$wp_customize->add_setting(
		'wishlist_text_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'wishlist_text_title',
			array(
				'priority' => 0,
				'section'  => 'wishlist_woocommerce_options',
				'label'    => __( 'Text settings', 'klasse-theme' ),
			)
		)
	);

	// Change the recently viewed products amount
	$wp_customize->add_setting(
		'wishlist_recently_viewed_products_amount',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'wishlist_recently_viewed_products_amount',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'wishlist_woocommerce_options',
			'label'    => __( 'Recently viewed product amount', 'klasse-theme' ),
		)
	);
}
add_action( 'customize_register', 'kls_create_wishlist_woocommerce_settings_controls' );
