<?php

/**
 * Create product page settings & controls
 *
 * @since 0.0.12
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_product_page_woocommerce_settings_controls( $wp_customize ) {
	// Seperator.
	$wp_customize->add_setting(
		'product_general_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'product_general_title',
			array(
				'priority' => 0,
				'section'  => 'product_page_woocommerce_options',
				'label'    => __( 'General settings', 'klasse-theme' ),
			)
		)
	);

	// Change Woocommerce product page theme version.
	// [Dev] Todo, find out what versions can be removed.
	// [Dev] Todo, add images to the different versions OR logical naming.
	$wp_customize->add_setting(
		'kls_woocommerce_product_page_version',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'kls_woocommerce_product_page_version',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'product_page_woocommerce_options',
			'label'    => __( 'Product page theme selection', 'klasse-theme' ),
			'choices'  => $GLOBALS['kls_product_pages'],
		)
	);

	// Change variation selection mode.
	$wp_customize->add_setting(
		'product_variation_selection_mode_select',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);

	$wp_customize->add_control(
		'product_variation_selection_mode_select',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'product_page_woocommerce_options',
			'label'    => __( 'Variation selection mode', 'klasse-theme' ),
			'choices'  => array(
				'label'      => __( 'Label', 'klasse-theme' ),
				'select-box' => __( 'Select box', 'klasse-theme' ),
				'accordion'  => __( 'Accordion', 'klasse-theme' ),
			),
		)
	);

	// Change variation selection mode.
	$wp_customize->add_setting(
		'kls_product_tabs_mode',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);

	$wp_customize->add_control(
		'kls_product_tabs_mode',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'product_page_woocommerce_options',
			'label'    => __( 'Product tabs or accordion mode', 'klasse-theme' ),
			'choices'  => array(
				'accordion'  => __( 'Accordion', 'klasse-theme' ),
				'tabs-small' => __( 'Tabs small', 'klasse-theme' ),
				'tabs'       => __( 'Tabs big', 'klasse-theme' ),
				'simple'     => __( 'Simple', 'klasse-theme' ),
			),
		)
	);

	// Seperator.
	$wp_customize->add_setting(
		'product_toggles_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'product_toggles_title',
			array(
				'priority' => 0,
				'section'  => 'product_page_woocommerce_options',
				'label'    => __( 'Toggleable items', 'klasse-theme' ),
			)
		)
	);

	// Toggle product SKU.
	$wp_customize->add_setting(
		'product_sku_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'product_sku_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_page_woocommerce_options',
			'label'    => __( 'Toggle sku', 'klasse-theme' ),
		)
	);

	// Toggle product categories.
	$wp_customize->add_setting(
		'product_categories_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'product_categories_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_page_woocommerce_options',
			'label'    => __( 'Toggle categories', 'klasse-theme' ),
		)
	);

	// Toggle product tags.
	$wp_customize->add_setting(
		'product_tags_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'product_tags_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_page_woocommerce_options',
			'label'    => __( 'Toggle tags', 'klasse-theme' ),
		)
	);

	// Toggle product tags.
	$wp_customize->add_setting(
		'product_first_tab_open_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'product_first_tab_open_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_page_woocommerce_options',
			'label'    => __( 'Toggle the first tab', 'klasse-theme' ),
		)
	);

	// Toggle read more button.
	$wp_customize->add_setting(
		'product_description_read_more_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'product_description_read_more_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_page_woocommerce_options',
			'label'    => __( 'Toggle description tab read more button', 'klasse-theme' ),
		)
	);

	// Toggle product image gallery arrows.
	$wp_customize->add_setting(
		'product_image_arrows_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'product_image_arrows_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_page_woocommerce_options',
			'label'    => __( 'Toggle product image arrows on mobile', 'klasse-theme' ),
		)
	);

	// Toggle product image gallery mobile dots.
	$wp_customize->add_setting(
		'product_image_dots_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'product_image_dots_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_page_woocommerce_options',
			'label'    => __( 'Toggle product image dots on mobile', 'klasse-theme' ),
		)
	);

	// Toggle product usps.
	$wp_customize->add_setting(
		'product_usps_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'product_usps_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_page_woocommerce_options',
			'label'    => __( 'Toggle product usps', 'klasse-theme' ),
		)
	);

	// Toggle product first container background.
	$wp_customize->add_setting(
		'kls_product_first_container_background',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_product_first_container_background',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_page_woocommerce_options',
			'label'    => __( 'Toggle the background color for the first container', 'klasse-theme' ),
		)
	);

	// Toggle product specifications.
	$wp_customize->add_setting(
		'kls_product_specifications_in_description',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_product_specifications_in_description',
		array(
			'type'            => 'checkbox',
			'priority'        => 0,
			'section'         => 'product_page_woocommerce_options',
			'label'           => __( 'Toggle the product specifications into the description.', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 'v6' == $wp_customize->get_setting( 'kls_woocommerce_product_page_version' )->value();
			},
		)
	);

	// Seperator.
	$wp_customize->add_setting(
		'product_related_products_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'product_related_products_title',
			array(
				'priority' => 0,
				'section'  => 'product_page_woocommerce_options',
				'label'    => __( 'Related products settings', 'klasse-theme' ),
			)
		)
	);

	// Toggle related products.
	$wp_customize->add_setting(
		'product_related_products_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'product_related_products_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_page_woocommerce_options',
			'label'    => __( 'Toggle related products', 'klasse-theme' ),
		)
	);

	// Change related products count.
	$wp_customize->add_setting(
		'product_related_products_count',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'product_related_products_count',
		array(
			'type'            => 'text',
			'priority'        => 0,
			'section'         => 'product_page_woocommerce_options',
			'label'           => __( 'Change related products amount', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'product_related_products_toggle' )->value();
			},
		)
	);

	// Change related products column count.
	$wp_customize->add_setting(
		'product_related_products_column_count',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'product_related_products_column_count',
		array(
			'type'            => 'text',
			'priority'        => 0,
			'section'         => 'product_page_woocommerce_options',
			'label'           => __( 'Change related products column count', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'product_related_products_toggle' )->value();
			},
		)
	);

	// Seperator.
	$wp_customize->add_setting(
		'product_up_sell_products_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'product_up_sell_products_title',
			array(
				'priority' => 0,
				'section'  => 'product_page_woocommerce_options',
				'label'    => __( 'Up sell products settings', 'klasse-theme' ),
			)
		)
	);

	// Toggle up sells.
	$wp_customize->add_setting(
		'product_up_sells_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'product_up_sells_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_page_woocommerce_options',
			'label'    => __( 'Toggle up sells', 'klasse-theme' ),
		)
	);

	// Change related products count.
	$wp_customize->add_setting(
		'product_up_sells_count',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'product_up_sells_count',
		array(
			'type'            => 'text',
			'priority'        => 0,
			'section'         => 'product_page_woocommerce_options',
			'label'           => __( 'Change up sells amount', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'product_up_sells_toggle' )->value();
			},
		)
	);

	// Change related products column count.
	$wp_customize->add_setting(
		'product_up_sells_column_count',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'product_up_sells_column_count',
		array(
			'type'            => 'text',
			'priority'        => 0,
			'section'         => 'product_page_woocommerce_options',
			'label'           => __( 'Change up sells column count', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'product_up_sells_toggle' )->value();
			},
		)
	);

	// Seperator.
	$wp_customize->add_setting(
		'product_recently_viewed_products_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'product_recently_viewed_products_title',
			array(
				'priority' => 0,
				'section'  => 'product_page_woocommerce_options',
				'label'    => __( 'Recently viewed products settings', 'klasse-theme' ),
			)
		)
	);

	// Toggle recently viewed products.
	$wp_customize->add_setting(
		'product_recently_viewed_products_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'product_recently_viewed_products_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_page_woocommerce_options',
			'label'    => __( 'Toggle recently viewed products', 'klasse-theme' ),
		)
	);

	// Change recently viewed products count.
	$wp_customize->add_setting(
		'product_recently_viewed_products_count',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'product_recently_viewed_products_count',
		array(
			'type'            => 'text',
			'priority'        => 0,
			'section'         => 'product_page_woocommerce_options',
			'label'           => __( 'Change recently viewed products amount', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'product_recently_viewed_products_toggle' )->value();
			},
		)
	);

	// Change recently viewed products column count.
	$wp_customize->add_setting(
		'product_recently_viewed_column_count',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'product_recently_viewed_column_count',
		array(
			'type'            => 'text',
			'priority'        => 0,
			'section'         => 'product_page_woocommerce_options',
			'label'           => __( 'Change recently viewed products column count', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'product_recently_viewed_products_toggle' )->value();
			},
		)
	);

	// Seperator.
	$wp_customize->add_setting(
		'product_variation_read_more_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'product_variation_read_more_title',
			array(
				'priority' => 0,
				'section'  => 'product_page_woocommerce_options',
				'label'    => __( 'Variation read more settings', 'klasse-theme' ),
			)
		)
	);

	// Toggle variation read more.
	$wp_customize->add_setting(
		'product_variation_read_more_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'product_variation_read_more_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_page_woocommerce_options',
			'label'    => __( 'Toggle variation read more toggle', 'klasse-theme' ),
		)
	);

	// Change related products count.
	$wp_customize->add_setting(
		'product_variation_read_more_amount',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'product_variation_read_more_amount',
		array(
			'type'            => 'text',
			'priority'        => 0,
			'section'         => 'product_page_woocommerce_options',
			'label'           => __( 'Change variation read more amount', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'product_variation_read_more_toggle' )->value();
			},
		)
	);

	// change variation read more text.
	$wp_customize->add_setting(
		'product_variation_read_more_text',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'product_variation_read_more_text',
		array(
			'type'            => 'text',
			'priority'        => 0,
			'section'         => 'product_page_woocommerce_options',
			'label'           => __( 'Change the variation read more text', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'product_variation_read_more_toggle' )->value();
			},
		)
	);

	// Seperator.
	$wp_customize->add_setting(
		'product_divi_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'product_divi_title',
			array(
				'priority' => 0,
				'section'  => 'product_page_woocommerce_options',
				'label'    => __( 'Divi module', 'klasse-theme' ),
			)
		)
	);

	// Add custom Divi shortcode to bottom of product page.
	$divi_library_items_list = array();
	$args                    = array( 'post_type' => 'et_pb_layout' );
	$divi_library_items      = get_posts( $args );

	$divi_library_items_list['none']     = __( 'None', 'klasse-theme' );
	$divi_library_items_list['standard'] = __( 'Standard product', 'klasse-theme' );

	foreach ( $divi_library_items as $divi_library_item ) {
		$divi_library_items_list[ $divi_library_item->ID ] = $divi_library_item->post_title;
	}

	$wp_customize->add_setting(
		'product_add_divi_shortcode_id',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);

	$wp_customize->add_control(
		'product_add_divi_shortcode_id',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'product_page_woocommerce_options',
			'label'    => __( 'Add custom Divi shortcode to the bottom of the page', 'klasse-theme' ),
			'choices'  => $divi_library_items_list,
		)
	);

	// Seperator.
	$wp_customize->add_setting(
		'kls_product_image_description_layout',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'kls_product_image_description_layout',
			array(
				'priority' => 0,
				'section'  => 'product_page_woocommerce_options',
				'label'    => __( 'Product image and text layout', 'klasse-theme' ),
			)
		)
	);

	// Product image width.
	$wp_customize->add_setting(
		'kls_product_image_width',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',

		)
	);

	$wp_customize->add_control(
		'kls_product_image_width',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'product_page_woocommerce_options',
			'label'    => __( 'Product image column width (1-12)', 'klasse-theme' ),
		)
	);

	// Product image width.
	$wp_customize->add_setting(
		'kls_product_summary_width',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',

		)
	);

	$wp_customize->add_control(
		'kls_product_summary_width',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'product_page_woocommerce_options',
			'label'    => __( 'Product summary column width (1-12)', 'klasse-theme' ),
		)
	);

	// Seperator.
	$wp_customize->add_setting(
		'kls_product_banner_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'kls_product_banner_title',
			array(
				'priority' => 0,
				'section'  => 'product_page_woocommerce_options',
				'label'    => __( 'Product banner settings', 'klasse-theme' ),
			)
		)
	);

	// Toggle product banner.
	$wp_customize->add_setting(
		'kls_product_banner_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_product_banner_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'product_page_woocommerce_options',
			'label'    => __( 'Toggle the product banner', 'klasse-theme' ),
		)
	);

	// Product banner padding.
	$wp_customize->add_setting(
		'kls_product_banner_padding',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',

		)
	);

	$wp_customize->add_control(
		'kls_product_banner_padding',
		array(
			'type'            => 'text',
			'priority'        => 0,
			'section'         => 'product_page_woocommerce_options',
			'label'           => __( 'Product banner padding', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'kls_product_banner_toggle' )->value();
			},
		)
	);

	// Product banner background image.
	$wp_customize->add_setting(
		'kls_product_banner_background_image',
		array(
			'default'   => '',
			// 'sanitize_callback' => '',
			'transport' => 'refresh',
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Media_Control(
			$wp_customize,
			'kls_product_banner_background_image',
			array(
				'label'           => __( 'Product banner background image', 'klasse-theme' ),
				'priority'        => 0,
				'section'         => 'product_page_woocommerce_options',
				'button_labels'   => array(
					'select'       => __( 'Select Image', 'klasse-theme' ),
					'change'       => __( 'Change Image', 'klasse-theme' ),
					'remove'       => __( 'Remove', 'klasse-theme' ),
					'default'      => __( 'Default', 'klasse-theme' ),
					'placeholder'  => __( 'No image selected', 'klasse-theme' ),
					'frame_title'  => __( 'Select Image', 'klasse-theme' ),
					'frame_button' => __( 'Choose Image', 'klasse-theme' ),
				),
				'active_callback' => function() use ( $wp_customize ) {
					return 1 == $wp_customize->get_setting( 'kls_product_banner_toggle' )->value();
				},
			)
		)
	);

	// Product banner background color.
	$wp_customize->add_setting(
		'kls_product_banner_background_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'kls_product_banner_background_color',
			array(
				'label'           => __( 'Product banner background color', 'klasse-theme' ),
				'section'         => 'product_page_woocommerce_options',
				'priority'        => 0,
				'show_opacity'    => true,
				'active_callback' => function() use ( $wp_customize ) {
					return 1 == $wp_customize->get_setting( 'kls_product_banner_toggle' )->value();
				},
			)
		)
	);

	// Product banner color.
	$wp_customize->add_setting(
		'kls_product_banner_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'kls_product_banner_color',
			array(
				'label'           => __( 'Product banner color', 'klasse-theme' ),
				'section'         => 'product_page_woocommerce_options',
				'priority'        => 0,
				'show_opacity'    => true,
				'active_callback' => function() use ( $wp_customize ) {
					return 1 == $wp_customize->get_setting( 'kls_product_banner_toggle' )->value();
				},
			)
		)
	);

	// Seperator.
	$wp_customize->add_setting(
		'kls_product_v6_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'kls_product_v6_title',
			array(
				'priority'        => 0,
				'section'         => 'product_page_woocommerce_options',
				'label'           => __( 'Product version 6 settings', 'klasse-theme' ),
				'active_callback' => function() use ( $wp_customize ) {
					return 'v6' == $wp_customize->get_setting( 'kls_woocommerce_product_page_version' )->value();
				},
			)
		)
	);

	// Toggle product description title.
	$wp_customize->add_setting(
		'kls_product_v6_description_title_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_product_v6_description_title_toggle',
		array(
			'type'            => 'checkbox',
			'priority'        => 0,
			'section'         => 'product_page_woocommerce_options',
			'label'           => __( 'Toggle the short description title', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 'v6' == $wp_customize->get_setting( 'kls_woocommerce_product_page_version' )->value();
			},
		)
	);

	// Product v6 usp location.
	$wp_customize->add_setting(
		'kls_product_v6_usp_location',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',

		)
	);

	$wp_customize->add_control(
		'kls_product_v6_usp_location',
		array(
			'type'            => 'text',
			'priority'        => 0,
			'section'         => 'product_page_woocommerce_options',
			'label'           => __( 'USP location (1-100)', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 'v6' == $wp_customize->get_setting( 'kls_woocommerce_product_page_version' )->value();
			},
		)
	);

	// Product v6 button location.
	$wp_customize->add_setting(
		'kls_product_v6_button_location',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',

		)
	);

	$wp_customize->add_control(
		'kls_product_v6_button_location',
		array(
			'type'            => 'text',
			'priority'        => 0,
			'section'         => 'product_page_woocommerce_options',
			'label'           => __( 'Button location (1-100)', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 'v6' == $wp_customize->get_setting( 'kls_woocommerce_product_page_version' )->value();
			},
		)
	);

	// Product v6 description location.
	$wp_customize->add_setting(
		'kls_product_v6_description_location',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',

		)
	);

	$wp_customize->add_control(
		'kls_product_v6_description_location',
		array(
			'type'            => 'text',
			'priority'        => 0,
			'section'         => 'product_page_woocommerce_options',
			'label'           => __( 'Description location (1-100)', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 'v6' == $wp_customize->get_setting( 'kls_woocommerce_product_page_version' )->value();
			},
		)
	);

	// Seperator.
	$wp_customize->add_setting(
		'product_sidebar_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'product_sidebar_title',
			array(
				'priority'        => 0,
				'section'         => 'product_page_woocommerce_options',
				'label'           => __( 'Product sidebar items version 6', 'klasse-theme' ),
				'active_callback' => function() use ( $wp_customize ) {
					return 'v6' == $wp_customize->get_setting( 'kls_woocommerce_product_page_version' )->value();
				},
			)
		)
	);

	// Toggle product sidebar.
	$wp_customize->add_setting(
		'kls_product_sidebar_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_product_sidebar_toggle',
		array(
			'type'            => 'checkbox',
			'priority'        => 0,
			'section'         => 'product_page_woocommerce_options',
			'label'           => __( 'Toggle the product sidebar', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 'v6' == $wp_customize->get_setting( 'kls_woocommerce_product_page_version' )->value();
			},
		)
	);

	// Product sidebar link 1 icon.
	$wp_customize->add_setting(
		'kls_product_sidebar_link_one_icon',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',

		)
	);

	$wp_customize->add_control(
		'kls_product_sidebar_link_one_icon',
		array(
			'type'            => 'text',
			'priority'        => 0,
			'section'         => 'product_page_woocommerce_options',
			'label'           => __( 'Product sidebar link 1 icon', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'kls_product_sidebar_toggle' )->value();
			},
		)
	);

	// Product sidebar link 1 text.
	$wp_customize->add_setting(
		'kls_product_sidebar_link_one_text',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_product_sidebar_link_one_text',
		array(
			'type'            => 'text',
			'priority'        => 0,
			'section'         => 'product_page_woocommerce_options',
			'label'           => __( 'Product sidebar link 1 title text', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'kls_product_sidebar_toggle' )->value();
			},
		)
	);

	// Product sidebar link 1.
	$wp_customize->add_setting(
		'kls_product_sidebar_link_one',
		array(
			'default'           => '',
			'sanitize_callback' => 'themeslug_sanitize_dropdown_pages',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_product_sidebar_link_one',
		array(
			'type'            => 'dropdown-pages',
			'priority'        => 0,
			'section'         => 'product_page_woocommerce_options',
			'label'           => __( 'Product sidebar link 1', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'kls_product_sidebar_toggle' )->value();
			},
		)
	);

	// Product sidebar link 1 text.
	$wp_customize->add_setting(
		'kls_product_sidebar_link_one_text_in_link',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_product_sidebar_link_one_text_in_link',
		array(
			'type'            => 'text',
			'priority'        => 0,
			'section'         => 'product_page_woocommerce_options',
			'label'           => __( 'Product sidebar link 1 text in link', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'kls_product_sidebar_toggle' )->value();
			},
		)
	);

	// Product sidebar link 2 icon.
	$wp_customize->add_setting(
		'kls_product_sidebar_link_two_icon',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_product_sidebar_link_two_icon',
		array(
			'type'            => 'text',
			'priority'        => 0,
			'section'         => 'product_page_woocommerce_options',
			'label'           => __( 'Product sidebar link 2 icon', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'kls_product_sidebar_toggle' )->value();
			},
		)
	);

	// Product sidebar link 2 text.
	$wp_customize->add_setting(
		'kls_product_sidebar_link_two_text',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_product_sidebar_link_two_text',
		array(
			'type'            => 'text',
			'priority'        => 0,
			'section'         => 'product_page_woocommerce_options',
			'label'           => __( 'Product sidebar link 2 title text', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'kls_product_sidebar_toggle' )->value();
			},
		)
	);

	// Product sidebar link 2.
	$wp_customize->add_setting(
		'kls_product_sidebar_link_two',
		array(
			'default'           => '',
			'sanitize_callback' => 'themeslug_sanitize_dropdown_pages',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_product_sidebar_link_two',
		array(
			'type'            => 'dropdown-pages',
			'priority'        => 0,
			'section'         => 'product_page_woocommerce_options',
			'label'           => __( 'Product sidebar link 2', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'kls_product_sidebar_toggle' )->value();
			},
		)
	);

	// Product sidebar link 2 text.
	$wp_customize->add_setting(
		'kls_product_sidebar_link_two_text_in_link',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_product_sidebar_link_two_text_in_link',
		array(
			'type'            => 'text',
			'priority'        => 0,
			'section'         => 'product_page_woocommerce_options',
			'label'           => __( 'Product sidebar link 2 text in link', 'klasse-theme' ),
			'active_callback' => function() use ( $wp_customize ) {
				return 1 == $wp_customize->get_setting( 'kls_product_sidebar_toggle' )->value();
			},
		)
	);
}
add_action( 'customize_register', 'kls_create_product_page_woocommerce_settings_controls' );
