<?php

/**
 * Create My Account page settings & controls
 *
 * @since 0.0.32
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_my_account_woocommerce_settings_controls( $wp_customize ) {
	 // Seperator.
	$wp_customize->add_setting(
		'my_account_toggles_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'my_account_toggles_title',
			array(
				'priority' => 0,
				'section'  => 'my_account_woocommerce_options',
				'label'    => __( 'Toggleable items', 'klasse-theme' ),
			)
		)
	);

	// Toggle downloads.
	$wp_customize->add_setting(
		'my_account_downloads_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'my_account_downloads_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'my_account_woocommerce_options',
			'label'    => __( 'Toggle downloads', 'klasse-theme' ),
		)
	);

	// Toggle my account registration usp's.
	$wp_customize->add_setting(
		'my_account_registration_usps_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'my_account_registration_usps_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'my_account_woocommerce_options',
			'label'    => __( 'Toggle registration usps', 'klasse-theme' ),
		)
	);

	// Toggle the menu.
	$wp_customize->add_setting(
		'kls_my_account_menu_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_my_account_menu_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'my_account_woocommerce_options',
			'label'    => __( 'Toggle the menu', 'klasse-theme' ),
		)
	);
}
add_action( 'customize_register', 'kls_create_my_account_woocommerce_settings_controls' );
