<?php

/**
 * Create mini cart page settings & controls
 *
 * @since 0.1.62
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_mini_cart_woocommerce_settings_controls( $wp_customize ) {
	// Seperator
	$wp_customize->add_setting(
		'kls_mini_cart_general_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'kls_mini_cart_general_title',
			array(
				'priority' => 0,
				'section'  => 'mini_cart_woocommerce_options',
				'label'    => __( 'General settings', 'klasse-theme' ),
			)
		)
	);

	// Change Woocommerce theme version
	$wp_customize->add_setting(
		'kls_mini_cart_version',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'kls_mini_cart_version',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'mini_cart_woocommerce_options',
			'label'    => __( 'Woocommerce theme selection', 'klasse-theme' ),
			'choices'  => $GLOBALS['kls_mini_cart_styling_versions'],
		)
	);

	// Seperator
	$wp_customize->add_setting(
		'kls_mini_cart_toggles_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'kls_mini_cart_toggles_title',
			array(
				'priority' => 0,
				'section'  => 'mini_cart_woocommerce_options',
				'label'    => __( 'Toggleable items', 'klasse-theme' ),
			)
		)
	);

	// Toggle mini cart after a product is added to the cart.
	$wp_customize->add_setting(
		'kls_mini_cart_open_after_add_to_cart',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_mini_cart_open_after_add_to_cart',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'mini_cart_woocommerce_options',
			'label'    => __( 'Open the mini cart after a product is added to the cart', 'klasse-theme' ),
		)
	);

	// Toggle mini cart variations.
	$wp_customize->add_setting(
		'kls_mini_cart_toggle_variations',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_mini_cart_toggle_variations',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'mini_cart_woocommerce_options',
			'label'    => __( 'Toggle product variations', 'klasse-theme' ),
		)
	);

	// Seperator
	$wp_customize->add_setting(
		'kls_mini_cart_text_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'kls_mini_cart_text_title',
			array(
				'priority' => 0,
				'section'  => 'mini_cart_woocommerce_options',
				'label'    => __( 'Text settings', 'klasse-theme' ),
			)
		)
	);
}
add_action( 'customize_register', 'kls_create_mini_cart_woocommerce_settings_controls' );
