<?php
/**
 * Create checkout flow settings & controls
 *
 * @since 0.1.62
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_checkout_flow_woocommerce_settings_controls( $wp_customize ) {
	// Seperator.
	$wp_customize->add_setting(
		'kls_checkout_flow_general_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'kls_checkout_flow_general_title',
			array(
				'priority' => 0,
				'section'  => 'checkout_flow_woocommerce_options',
				'label'    => __( 'General settings', 'klasse-theme' ),
			)
		)
	);

	// Change checkoutflow theme version.
	$wp_customize->add_setting(
		'kls_checkout_flow_version',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'kls_checkout_flow_version',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'checkout_flow_woocommerce_options',
			'label'    => __( 'Checkout flow theme selection', 'klasse-theme' ),
			'choices'  => $GLOBALS['kls_checkout_flow_styling_versions'],
		)
	);

	// Seperator.
	$wp_customize->add_setting(
		'kls_checkout_flow_toggles_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'kls_checkout_flow_toggles_title',
			array(
				'priority' => 0,
				'section'  => 'checkout_flow_woocommerce_options',
				'label'    => __( 'Toggleable items', 'klasse-theme' ),
			)
		)
	);
}
add_action( 'customize_register', 'kls_create_checkout_flow_woocommerce_settings_controls' );
