<?php

/**
 * Create cart page settings & controls
 *
 * @since 0.0.12
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_cart_woocommerce_settings_controls( $wp_customize ) {
	// Seperator.
	$wp_customize->add_setting(
		'cart_toggles_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'cart_toggles_title',
			array(
				'priority' => 0,
				'section'  => 'cart_woocommerce_options',
				'label'    => __( 'Toggleable items', 'klasse-theme' ),
			)
		)
	);
	// Toggle recently viewed products.
	$wp_customize->add_setting(
		'cart_recently_viewed_products_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'cart_recently_viewed_products_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'cart_woocommerce_options',
			'label'    => __( 'Toggle recently viewed products', 'klasse-theme' ),
		)
	);
	// Toggle product upsells.
	$wp_customize->add_setting(
		'cart_upsells_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'cart_upsells_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'cart_woocommerce_options',
			'label'    => __( 'Toggle product upsells', 'klasse-theme' ),
		)
	);

	// Toggle usps.
	$wp_customize->add_setting(
		'kls_cart_usps_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_cart_usps_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'cart_woocommerce_options',
			'label'    => __( 'Toggle usps', 'klasse-theme' ),
		)
	);

	// Toggle product notes.
	$wp_customize->add_setting(
		'kls_cart_notes_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_cart_notes_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'cart_woocommerce_options',
			'label'    => __( 'Toggle product notes', 'klasse-theme' ),
		)
	);

	// Seperator.
	$wp_customize->add_setting(
		'cart_text_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'cart_text_title',
			array(
				'priority' => 0,
				'section'  => 'cart_woocommerce_options',
				'label'    => __( 'Text settings', 'klasse-theme' ),
			)
		)
	);
		// Change the recently viewed products amount.
	$wp_customize->add_setting(
		'cart_recently_viewed_products_amount',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'cart_recently_viewed_products_amount',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'cart_woocommerce_options',
			'label'    => __( 'Recently viewed product amount', 'klasse-theme' ),
		)
	);
}
add_action( 'customize_register', 'kls_create_cart_woocommerce_settings_controls' );
