<?php

/**
 * Create settings & controls for the sidebar navigation
 *
 * @since 0.1.66
 *
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_sidebar_navigation_settings_controls( $wp_customize ) {
	 // Seperator.
	$wp_customize->add_setting(
		'kls_sidebar_general_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'kls_sidebar_general_title',
			array(
				'priority' => 0,
				'section'  => 'sidebar_navigation_options',
				'label'    => __( 'General settings', 'klasse-theme' ),
			)
		)
	);

	// Toggle main navigation.
	$wp_customize->add_setting(
		'kls_sidebar_navigation_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_sidebar_navigation_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'sidebar_navigation_options',
			'label'    => __( 'Sidebar navigation toggle', 'klasse-theme' ),
		)
	);

	// Select navigation type.
	$wp_customize->add_setting(
		'kls_sidebar_navigation_version',
		array(
			'default'   => '',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);

	$wp_customize->add_control(
		'kls_sidebar_navigation_version',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'sidebar_navigation_options',
			'label'    => __( 'Main navigation theme selection', 'klasse-theme' ),
			'choices'  => $GLOBALS['kls_sidebar_navigation'],
		)
	);

	// Seperator.
	$wp_customize->add_setting(
		'kls_sidebar_toggles_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'kls_sidebar_toggles_title',
			array(
				'priority' => 0,
				'section'  => 'sidebar_navigation_options',
				'label'    => __( 'Toggleable items', 'klasse-theme' ),
			)
		)
	);

	// Toggle close icon.
	// [Dev] Todo, implement.
	$wp_customize->add_setting(
		'kls_sidebar_close_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_sidebar_close_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'sidebar_navigation_options',
			'label'    => __( 'Make the sidebar toggleable', 'klasse-theme' ),
		)
	);

	// Toggle to hide or show the sidebar only when logged in.
	$wp_customize->add_setting(
		'kls_sidebar_only_loggedin',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_sidebar_only_loggedin',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'sidebar_navigation_options',
			'label'    => __( 'Only show sidebar when loggedin?', 'klasse-theme' ),
		)
	);

	// Toggle the logo
	$wp_customize->add_setting(
		'kls_sidebar_logo_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);

	$wp_customize->add_control(
		'kls_sidebar_logo_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'sidebar_navigation_options',
			'label'    => __( 'Toggle the logo', 'klasse-theme' ),
		)
	);

	// // Seperator.
	// $wp_customize->add_setting(
	// 'kls_sidebar_fonts_title',
	// array(
	// 'capability'        => 'edit_theme_options',
	// )
	// );

	// $wp_customize->add_control(
	// new kls_seperator(
	// $wp_customize,
	// 'kls_sidebar_fonts_title',
	// array(
	// 'priority'          => 0,
	// 'section'           => 'sidebar_navigation_options',
	// 'label'             => __( 'Font settings', 'klasse-theme' ),
	// )
	// )
	// );

	// // Main navigation font size.
	// $wp_customize->add_setting(
	// 'kls_sidebar_navigation_font_size',
	// array(
	// 'default'           => '',
	// 'sanitize_callback' => 'sanitize_text_field',
	// 'transport'         => 'refresh',
	// )
	// );

	// $wp_customize->add_control(
	// 'kls_sidebar_navigation_font_size',
	// array(
	// 'type'              => 'text',
	// 'priority'          => 0,
	// 'section'           => 'sidebar_navigation_options',
	// 'label'             => __( 'Main navigation font size', 'klasse-theme' ),
	// )
	// );

	// // Main navigation font size.
	// $wp_customize->add_setting(
	// 'kls_sidebar_navigation_icon_font_size',
	// array(
	// 'default'           => '',
	// 'sanitize_callback' => 'sanitize_text_field',
	// 'transport'         => 'refresh',
	// )
	// );

	// $wp_customize->add_control(
	// 'kls_sidebar_navigation_icon_font_size',
	// array(
	// 'type'              => 'text',
	// 'priority'          => 0,
	// 'section'           => 'sidebar_navigation_options',
	// 'label'             => __( 'Main navigation icon font size', 'klasse-theme' ),
	// )
	// );

	// // Main navigation font weight.
	// $wp_customize->add_setting(
	// 'kls_sidebar_navigation_font_weight',
	// array(
	// 'default'           => '',
	// 'transport'         => 'refresh',
	// 'type'              => 'theme_mod',
	// )
	// );

	// $wp_customize->add_control(
	// 'kls_sidebar_navigation_font_weight',
	// array(
	// 'priority'          => 0,
	// 'type'              => 'select',
	// 'section'           => 'sidebar_navigation_options',
	// 'label'             => __( 'Main navigation font weight', 'klasse-theme' ),
	// 'choices'           => array(
	// 'normal' => __( 'Normal', 'klasse-theme' ),
	// 'bold' => __( 'Bold', 'klasse-theme' ),
	// 'bolder' => __( 'Bolder', 'klasse-theme' ),
	// 'lighter' => __( 'Light', 'klasse-theme' ),
	// ),
	// )
	// );

	// Seperator.
	$wp_customize->add_setting(
		'kls_sidebar_colors_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'kls_sidebar_colors_title',
			array(
				'priority' => 0,
				'section'  => 'sidebar_navigation_options',
				'label'    => __( 'Colors', 'klasse-theme' ),
			)
		)
	);

	// Menu background color.
	$wp_customize->add_setting(
		'kls_sidebar_navigation_background_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);

	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'kls_sidebar_navigation_background_color',
			array(
				'label'        => __( 'Background color', 'klasse-theme' ),
				'section'      => 'sidebar_navigation_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);

	// Menu background color.
	$wp_customize->add_setting(
		'kls_sidebar_navigation_text_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);

	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'kls_sidebar_navigation_text_color',
			array(
				'label'        => __( 'Text color', 'klasse-theme' ),
				'section'      => 'sidebar_navigation_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);

	// Seperator.
	$wp_customize->add_setting(
		'kls_sidebar_v5_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'kls_sidebar_v5_title',
			array(
				'priority' => 0,
				'section'  => 'sidebar_navigation_options',
				'label'    => __( 'Sidebar v5 settings', 'klasse-theme' ),
			)
		)
	);

	// Sidebar v5 dashboard link.
	$wp_customize->add_setting(
		'kls_sidebar_dashboard_link',
		array(
			'default'           => '',
			'sanitize_callback' => 'themeslug_sanitize_dropdown_pages',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_sidebar_dashboard_link',
		array(
			'type'     => 'dropdown-pages',
			'priority' => 0,
			'section'  => 'sidebar_navigation_options',
			'label'    => __( 'Dashboard link', 'klasse-theme' ),
		)
	);
}
add_action( 'customize_register', 'kls_create_sidebar_navigation_settings_controls' );
