<?php
/**
 * Create customizer panel
 *
 * @since 0.0.07
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_navigation_customizer_panels( $wp_customize ) {
	// Add the navigation panel
	$wp_customize->add_panel(
		'navigation_editor',
		array(
			'priority'    => 5,
			'title'       => __( 'Navigation editor', 'klasse-theme' ),
			'description' => __( 'Edit the navigation settings', 'klasse-theme' ),
		)
	);
}
add_action( 'customize_register', 'kls_create_navigation_customizer_panels' );

/**
 * Create customizer sections
 *
 * @since 0.0.07
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_navigation_customizer_sections( $wp_customize ) {
	// Add general navigation sections.
	$wp_customize->add_section(
		'general_navigation_options',
		array(
			'title'    => __( 'General navigation', 'klasse-theme' ),
			'priority' => '0',
			'panel'    => 'navigation_editor',
		)
	);

	// Add main navigation section.
	$wp_customize->add_section(
		'main_navigation_options',
		array(
			'title'    => __( 'Main navigation', 'klasse-theme' ),
			'priority' => '5',
			'panel'    => 'navigation_editor',
		)
	);

	// Add top navigation section.
	$wp_customize->add_section(
		'top_navigation_options',
		array(
			'title' => __('Top navigation', 'klasse-theme'),
			'priority' => '10',
			'panel' => 'navigation_editor',
		)
	);

	// Add sidebar navigation section.
	$wp_customize->add_section(
		'sidebar_navigation_options',
		array(
			'title'    => __( 'Sidebar navigation', 'klasse-theme' ),
			'priority' => '12',
			'panel'    => 'navigation_editor',
		)
	);

	if (get_theme_mod('kls_sidemenu_navigation_toggle') == '1') {
		$wp_customize->add_section(
			'sidemenu_navigation_options',
			array(
				'title'    => __( 'Sidemenu navigation', 'klasse-theme' ),
				'priority' => '14',
				'panel'    => 'navigation_editor',
			)
		);
	}

	// Add general mobile navigation section.
	$wp_customize->add_section(
		'general_mobile_navigation_options',
		array(
			'title'    => __( 'General mobile navigation', 'klasse-theme' ),
			'priority' => '15',
			'panel'    => 'navigation_editor',
		)
	);

	// Add general mobile navigation section.
	$wp_customize->add_section(
		'general_mobile_menu_options',
		array(
			'title'    => __( 'General mobile menu', 'klasse-theme' ),
			'priority' => '20',
			'panel'    => 'navigation_editor',
		)
	);
}
add_action( 'customize_register', 'kls_create_navigation_customizer_sections' );

require_once __DIR__ . '/general-mobile-navigation-settings.php';
require_once __DIR__ . '/general-mobile-menu-settings.php';
require_once __DIR__ . '/general-navigation-settings.php';
require_once __DIR__ . '/main-navigation-settings.php';
require_once __DIR__ . '/sidemenu-navigation-settings.php';
require_once __DIR__ . '/sidebar-navigation-settings.php';
require_once __DIR__ . '/top-navigation-settings.php';

/**
 * Create settings & controls for the mobile navigation
 *
 * @since 0.0.11
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_mobile_navigation_settings_controls( $wp_customize ) {

}
add_action( 'customize_register', 'kls_create_mobile_navigation_settings_controls' );
