<?php

/**
 * Create settings & controls for general mobile menu
 *
 * @since 0.0.90
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_general_mobile_menu_settings_controls( $wp_customize ) {
	// Seperator
	$wp_customize->add_setting(
		'mobile_menu_general_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'mobile_menu_general_title',
			array(
				'priority' => 0,
				'section'  => 'general_mobile_menu_options',
				'label'    => __( 'General settings', 'klasse-theme' ),
			)
		)
	);
	// Select menu type
	$wp_customize->add_setting(
		'mobile_menu_version',
		array(
			'default'   => '',
			// 'sanitize_callback' => 'sanitize_select_field',
			'transport' => 'refresh',
			'type'      => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		'mobile_menu_version',
		array(
			'priority' => 0,
			'type'     => 'select',
			'section'  => 'general_mobile_menu_options',
			'label'    => __( 'Mobile navigation theme selection', 'klasse-theme' ),
			'choices'  => array(
				'default-v1'         => __( 'Default v1', 'klasse-theme' ),
				// 'bottom_bar-v1' => __('Bottom bar v1', 'klasse-theme'),
				'bottom_bar_shop-v2' => __( 'Shop menu v2', 'klasse-theme' ),
			),
		)
	);
	// Seperator
	$wp_customize->add_setting(
		'mobile_menu_toggles_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'mobile_menu_toggles_title',
			array(
				'priority' => 0,
				'section'  => 'general_mobile_menu_options',
				'label'    => __( 'Toggleable items', 'klasse-theme' ),
			)
		)
	);
	// Change menu position
	$wp_customize->add_setting(
		'mobile_menu_position',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_radio_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'mobile_menu_position',
		array(
			'type'     => 'radio',
			'priority' => 0,
			'section'  => 'general_mobile_menu_options',
			'label'    => __( 'Mobile menu left or right position', 'klasse-theme' ),
			'choices'  => array(
				'left'  => __( 'Left', 'klasse-theme' ),
				'right' => __( 'Right', 'klasse-theme' ),
			),
		)
	);
	// Toggle bottom bar menu navigation logo
	$wp_customize->add_setting(
		'mobile_bottom_bar_logo_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'mobile_bottom_bar_logo_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'general_mobile_menu_options',
			'label'    => __( 'Toggle logo in menu', 'klasse-theme' ),
		)
	);
		// Toggle bottom bar navigation contact info
	$wp_customize->add_setting(
		'mobile_navigation_toggle_contact_info',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'mobile_navigation_toggle_contact_info',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'general_mobile_menu_options',
			'label'    => __( 'Mobile navigation contact info toggle', 'klasse-theme' ),
		)
	);

		// Toggle bottom bar navigation contact info adres
		$wp_customize->add_setting(
			'mobile_navigation_toggle_contact_info_addres',
			array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_checkbox_field',
				'transport'         => 'refresh',
			)
		);
		$wp_customize->add_control(
			'mobile_navigation_toggle_contact_info_addres',
			array(
				'type'     => 'checkbox',
				'priority' => 0,
				'section'  => 'general_mobile_menu_options',
				'label'    => __( 'Mobile navigation contact info address toggle', 'klasse-theme' ),
			)
		);

		// Toggle bottom bar navigation social media
		$wp_customize->add_setting(
			'mobile_navigation_toggle_social_media',
			array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_checkbox_field',
				'transport'         => 'refresh',
			)
		);
		$wp_customize->add_control(
			'mobile_navigation_toggle_social_media',
			array(
				'type'     => 'checkbox',
				'priority' => 0,
				'section'  => 'general_mobile_menu_options',
				'label'    => __( 'Mobile navigation social media toggle', 'klasse-theme' ),
			)
		);
		// Seperator
		$wp_customize->add_setting(
			'mobile_menu_text_title',
			array(
				'capability' => 'edit_theme_options',
			)
		);
		$wp_customize->add_control(
			new kls_seperator(
				$wp_customize,
				'mobile_menu_text_title',
				array(
					'priority' => 0,
					'section'  => 'general_mobile_menu_options',
					'label'    => __( 'Text settings', 'klasse-theme' ),
				)
			)
		);

		// Bottom bar contact title font size
		$wp_customize->add_setting(
			'mobile_navigation_contact_title_text',
			array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'refresh',
			)
		);
		$wp_customize->add_control(
			'mobile_navigation_contact_title_text',
			array(
				'type'     => 'text',
				'priority' => 0,
				'section'  => 'general_mobile_menu_options',
				'label'    => __( 'Mobile navigation contact title text', 'klasse-theme' ),
			)
		);

	// Seperator
	$wp_customize->add_setting(
		'mobile_menu_fonts_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'mobile_menu_fonts_title',
			array(
				'priority' => 0,
				'section'  => 'general_mobile_menu_options',
				'label'    => __( 'Font settings', 'klasse-theme' ),
			)
		)
	);
			// Bottom bar contact title font size
	$wp_customize->add_setting(
		'mobile_navigation_contact_title_font_size',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'mobile_navigation_contact_title_font_size',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'general_mobile_menu_options',
			'label'    => __( 'Mobile navigation contact title font size', 'klasse-theme' ),
		)
	);
	// Seperator
	$wp_customize->add_setting(
		'mobile_menu_colors_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'mobile_menu_colors_title',
			array(
				'priority' => 0,
				'section'  => 'general_mobile_menu_options',
				'label'    => __( 'Colors', 'klasse-theme' ),
			)
		)
	);
	// Bottom bar navigation contact info title color
	$wp_customize->add_setting(
		'mobile_navigation_contact_title_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'mobile_navigation_contact_title_color',
			array(
				'show_opacity' => true,
				'priority'     => 0,
				'section'      => 'general_mobile_menu_options',
				'label'        => __( 'Mobile navigation contact title color', 'klasse-theme' ),
			)
		)
	);
	// Mobile navigation contact info title color
	$wp_customize->add_setting(
		'mobile_navigation_contact_link_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'mobile_navigation_contact_link_color',
			array(
				'show_opacity' => true,
				'priority'     => 0,
				'section'      => 'general_mobile_menu_options',
				'label'        => __( 'Mobile navigation contact links color', 'klasse-theme' ),
			)
		)
	);
	// Seperator
	$wp_customize->add_setting(
		'mobile_highlighted_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'mobile_highlighted_title',
			array(
				'priority' => 0,
				'section'  => 'general_mobile_menu_options',
				'label'    => __( 'Highlighted button', 'klasse-theme' ),
			)
		)
	);
	// Mobile navigation featured button
	$wp_customize->add_setting(
		'kls_featured_button_mobile_menu_link',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_featured_button_mobile_menu_link',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'general_mobile_menu_options',
			'label'    => __( 'Mobile navigation featured button link', 'klasse-theme' ),
		)
	);
	// Mobile navigation featured button
	$wp_customize->add_setting(
		'kls_featured_button_mobile_menu_text',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'kls_featured_button_mobile_menu_text',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'general_mobile_menu_options',
			'label'    => __( 'Mobile navigation featured button text', 'klasse-theme' ),
		)
	);
}
add_action( 'customize_register', 'kls_create_general_mobile_menu_settings_controls' );
