(function ($) {

	$( window ).load(
		function () {
			$( '.multi-image-control' ).each(
				function(){
					var begin_attachment_string = $( this ).find( ".images-input" ).val();
					var begin_attachment_array = begin_attachment_string.split( "," );
					for (var i = 0; i < begin_attachment_array.length; i++) {
						if (begin_attachment_array[i] != "") {
							$( this ).find( ".images" ).append( "<li class='image-list'>" + begin_attachment_array[i] + "</li>" );
						}
					}

					var imagesList = $( this ).find( ".images" );
					var imagesInput = $( this ).find( ".images-input" );

					$( this ).find( ".button-secondary.upload" ).click(
						function () {
							var custom_uploader = wp.media.frames.file_frame = wp.media(
								{
									multiple: true
								}
							);
				
							// [ToDo] Dev, filter out duplicates
							custom_uploader.on(
								'select',
								function () {
									var selection = custom_uploader.state().get( 'selection' );
									var attachments = [];
									selection.map(
										function (attachment) {
											attachment = attachment.toJSON();
											imagesList.append( "<li class='image-list'>" + attachment.url + "</li>" );
											attachments.push( attachment.url );
										}
									);
									var attachment_string = attachments.join() + "," + imagesInput.val();
									imagesInput.val( attachment_string ).trigger( 'change' );
								}
							);
							custom_uploader.open();
						}
					);

					// Remove all
					$( this ).find( ".images-remove-all" ).on(
						'click',
						function () {
							imagesInput.val( '' ).trigger( 'change' );
							$( this ).parent().parent().find( '.images li' ).remove();
						}
					);
				}
			);

			// Remove specific
			// [ToDo] Dev, doesn't work after a new font is uploaded.
			$( '.images li' ).click(
				function () {
					var imagesInput = $( this ).parent().parent().find( '.images-input' );
					var img_src = $( this ).text();
					$( this ).remove();
					var attachment_string = imagesInput.val();
					attachment_string = attachment_string.replace( img_src + ",", "" );
					imagesInput.val( attachment_string ).trigger( 'change' );
				}
			);
		}
	);

})( jQuery );
