<?php
/**
 * Create customizer panel
 *
 * @since 0.0.12
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_general_customizer_panels( $wp_customize ) {
	// Add the general panel
	$wp_customize->add_panel(
		'general_theme_editor',
		array(
			'priority'    => 0,
			'title'       => __( 'General theme editor', 'klasse-theme' ),
			'description' => __( 'Edit the main theme settings', 'klasse-theme' ),
		)
	);
}
add_action( 'customize_register', 'kls_create_general_customizer_panels' );

/**
 * Create customizer sections
 *
 * @since 0.0.12
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_general_customizer_sections( $wp_customize ) {
	// Add general general sections
	$wp_customize->add_section(
		'general_theme_options',
		array(
			'title'    => __( 'General theme settings', 'klasse-theme' ),
			'priority' => '0',
			'panel'    => 'general_theme_editor',
		)
	);
}
add_action( 'customize_register', 'kls_create_general_customizer_sections' );

/**
 * Create fonts sections
 *
 * @since 0.0.12
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_fonts_customizer_sections( $wp_customize ) {
	// Add general fonts sections
	$wp_customize->add_section(
		'fonts_theme_options',
		array(
			'title'    => __( 'fonts settings', 'klasse-theme' ),
			'priority' => '10',
			'panel'    => 'general_theme_editor',
		)
	);
}
add_action( 'customize_register', 'kls_create_fonts_customizer_sections' );

/**
 * Create color sections
 *
 * @since 0.0.21
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_color_customizer_sections( $wp_customize ) {
	// Add general color sections
	$wp_customize->add_section(
		'color_theme_options',
		array(
			'title'    => __( 'Color settings', 'klasse-theme' ),
			'priority' => '20',
			'panel'    => 'general_theme_editor',
		)
	);
}
add_action( 'customize_register', 'kls_create_color_customizer_sections' );

require_once __DIR__ . '/general-theme-settings.php';
require_once __DIR__ . '/fonts-theme-settings.php';
require_once __DIR__ . '/color-theme-settings.php';
