<?php

/**
 * Create general settings & controls
 *
 * @since 0.0.12
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_general_theme_settings_controls( $wp_customize ) {
	// Seperator
	$wp_customize->add_setting(
		'content_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'content_title',
			array(
				'priority' => 0,
				'section'  => 'general_theme_options',
				'label'    => __( 'Content settings', 'klasse-theme' ),
			)
		)
	);
	// Set content max width
	$wp_customize->add_setting(
		'content_max_width',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'content_max_width',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'general_theme_options',
			'label'    => __( 'Content max width', 'klasse-theme' ),
		)
	);
}
add_action( 'customize_register', 'kls_create_general_theme_settings_controls' );
