<?php

/**
 * Create settings & controls for the main footer
 *
 * @since 0.0.07
 * @author Joeri van der Stek <joeri@klassebv.nl>
 */
function kls_create_main_footer_settings_controls( $wp_customize ) {
	// Seperator
	$wp_customize->add_setting(
		'footer_general_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'footer_general_title',
			array(
				'priority' => 0,
				'section'  => 'main_footer_options',
				'label'    => __( 'General settings', 'klasse-theme' ),
			)
		)
	);
	// Toggle main footer
	$wp_customize->add_setting(
		'main_footer_toggle',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_checkbox_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'main_footer_toggle',
		array(
			'type'     => 'checkbox',
			'priority' => 0,
			'section'  => 'main_footer_options',
			'label'    => __( 'Toggle main footer', 'klasse-theme' ),
		)
	);
	// Seperator
	$wp_customize->add_setting(
		'footer_font_size_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'footer_font_size_title',
			array(
				'priority' => 0,
				'section'  => 'main_footer_options',
				'label'    => __( 'Footer font sizes', 'klasse-theme' ),
			)
		)
	);
	// Main footer font size
	$wp_customize->add_setting(
		'main_footer_font_size',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'main_footer_font_size',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'main_footer_options',
			'label'    => __( 'Main footer font size', 'klasse-theme' ),
		)
	);
	// Main footer heading font size
	$wp_customize->add_setting(
		'main_footer_heading_font_size',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'main_footer_heading_font_size',
		array(
			'type'     => 'text',
			'priority' => 0,
			'section'  => 'main_footer_options',
			'label'    => __( 'Main footer heading font size', 'klasse-theme' ),
		)
	);
	// Seperator
	$wp_customize->add_setting(
		'footer_colors_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'footer_colors_title',
			array(
				'priority' => 0,
				'section'  => 'main_footer_options',
				'label'    => __( 'Footer colors', 'klasse-theme' ),
			)
		)
	);
	// Menu background color
	$wp_customize->add_setting(
		'main_footer_background_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'main_footer_background_color',
			array(
				'label'        => __( 'Footer background color', 'klasse-theme' ),
				'section'      => 'main_footer_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
	// Main footer text color
	$wp_customize->add_setting(
		'main_footer_text_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'main_footer_text_color',
			array(
				'label'        => __( 'Footer text color', 'klasse-theme' ),
				'section'      => 'main_footer_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
	// Main footer headings color
	$wp_customize->add_setting(
		'main_footer_heading_text_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'main_footer_heading_text_color',
			array(
				'label'        => __( 'Footer heading color', 'klasse-theme' ),
				'section'      => 'main_footer_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
	// Main footer link color
	$wp_customize->add_setting(
		'main_footer_link_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'main_footer_link_color',
			array(
				'label'        => __( 'Footer link color', 'klasse-theme' ),
				'section'      => 'main_footer_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
	// Main footer link hover color
	$wp_customize->add_setting(
		'main_footer_link_hover_color',
		array(
			'default'    => '',
			'transport'  => 'refresh',
			'capability' => 'edit_theme_options',
			'type'       => 'theme_mod',
		)
	);
	$wp_customize->add_control(
		new Customize_Alpha_Color_Control(
			$wp_customize,
			'main_footer_link_hover_color',
			array(
				'label'        => __( 'Footer link hover color', 'klasse-theme' ),
				'section'      => 'main_footer_options',
				'priority'     => 0,
				'show_opacity' => true,
			)
		)
	);
	// Seperator
	$wp_customize->add_setting(
		'footer_text_title',
		array(
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_control(
		new kls_seperator(
			$wp_customize,
			'footer_text_title',
			array(
				'priority' => 0,
				'section'  => 'main_footer_options',
				'label'    => __( 'Footer shop v2 text', 'klasse-theme' ),
			)
		)
	);
	// Main footer shopv2 text
	$wp_customize->add_setting(
		'main_footer_shopv2_text',
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_textarea_field',
			'transport'         => 'refresh',
		)
	);
	$wp_customize->add_control(
		'main_footer_shopv2_text',
		array(
			'type'     => 'textarea',
			'priority' => 0,
			'section'  => 'main_footer_options',
			'label'    => __( 'Main footer set shop v2 text', 'klasse-theme' ),
		)
	);
}
add_action( 'customize_register', 'kls_create_main_footer_settings_controls' );
